/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.SampleRegionWALObserver;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestWALObserver {
    private static final Log LOG = LogFactory.getLog(TestWALObserver.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static byte[] TEST_TABLE = Bytes.toBytes((String)"observedTable");
    private static byte[][] TEST_FAMILY = new byte[][]{Bytes.toBytes((String)"fam1"), Bytes.toBytes((String)"fam2"), Bytes.toBytes((String)"fam3")};
    private static byte[][] TEST_QUALIFIER = new byte[][]{Bytes.toBytes((String)"q1"), Bytes.toBytes((String)"q2"), Bytes.toBytes((String)"q3")};
    private static byte[][] TEST_VALUE = new byte[][]{Bytes.toBytes((String)"v1"), Bytes.toBytes((String)"v2"), Bytes.toBytes((String)"v3")};
    private static byte[] TEST_ROW = Bytes.toBytes((String)"testRow");
    @Rule
    public TestName currentTest = new TestName();
    private Configuration conf;
    private FileSystem fs;
    private Path dir;
    private Path hbaseRootDir;
    private String logName;
    private Path oldLogDir;
    private Path logDir;
    private WALFactory wals;
    private static final byte[] UNSPECIFIED_REGION = new byte[0];

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.coprocessor.wal.classes", new String[]{SampleRegionWALObserver.class.getName(), SampleRegionWALObserver.Legacy.class.getName()});
        conf.set("hbase.coprocessor.region.classes", SampleRegionWALObserver.class.getName());
        conf.setBoolean("dfs.support.append", true);
        conf.setInt("dfs.client.block.recovery.retries", 2);
        TEST_UTIL.startMiniCluster(1);
        Path hbaseRootDir = TEST_UTIL.getDFSCluster().getFileSystem().makeQualified(new Path("/hbase"));
        LOG.info((Object)("hbase.rootdir=" + hbaseRootDir));
        FSUtils.setRootDir((Configuration)conf, (Path)hbaseRootDir);
    }

    @AfterClass
    public static void teardownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.conf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        this.fs = TEST_UTIL.getDFSCluster().getFileSystem();
        this.hbaseRootDir = FSUtils.getRootDir((Configuration)this.conf);
        this.dir = new Path(this.hbaseRootDir, TestWALObserver.class.getName());
        this.oldLogDir = new Path(this.hbaseRootDir, "oldWALs");
        this.logDir = new Path(this.hbaseRootDir, DefaultWALProvider.getWALDirectoryName((String)this.currentTest.getMethodName()));
        this.logName = "WALs";
        if (TEST_UTIL.getDFSCluster().getFileSystem().exists(this.hbaseRootDir)) {
            TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseRootDir, true);
        }
        this.wals = new WALFactory(this.conf, null, this.currentTest.getMethodName());
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.wals.shutdown();
        }
        catch (IOException exception) {
            LOG.warn((Object)("Ignoring failure to close wal factory. " + exception.getMessage()));
            LOG.debug((Object)"details of failure to close wal factory.", (Throwable)exception);
        }
        TEST_UTIL.getDFSCluster().getFileSystem().delete(this.hbaseRootDir, true);
    }

    @Test
    public void testWALObserverWriteToWAL() throws Exception {
        WAL log = this.wals.getWAL(UNSPECIFIED_REGION);
        this.verifyWritesSeen(log, this.getCoprocessor(log, SampleRegionWALObserver.class), false);
    }

    @Test
    public void testLegacyWALObserverWriteToWAL() throws Exception {
        WAL log = this.wals.getWAL(UNSPECIFIED_REGION);
        this.verifyWritesSeen(log, this.getCoprocessor(log, SampleRegionWALObserver.Legacy.class), true);
    }

    private void verifyWritesSeen(WAL log, SampleRegionWALObserver cp, boolean seesLegacy) throws Exception {
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(Bytes.toString((byte[])TEST_TABLE));
        HTableDescriptor htd = this.createBasic3FamilyHTD(Bytes.toString((byte[])TEST_TABLE));
        Path basedir = new Path(this.hbaseRootDir, Bytes.toString((byte[])TEST_TABLE));
        this.deleteDir(basedir);
        this.fs.mkdirs(new Path(basedir, hri.getEncodedName()));
        AtomicLong sequenceId = new AtomicLong(0L);
        cp.setTestValues(TEST_TABLE, TEST_ROW, TEST_FAMILY[0], TEST_QUALIFIER[0], TEST_FAMILY[1], TEST_QUALIFIER[1], TEST_FAMILY[2], TEST_QUALIFIER[2]);
        Assert.assertFalse((boolean)cp.isPreWALWriteCalled());
        Assert.assertFalse((boolean)cp.isPostWALWriteCalled());
        Assert.assertFalse((boolean)cp.isPreWALWriteDeprecatedCalled());
        Assert.assertFalse((boolean)cp.isPostWALWriteDeprecatedCalled());
        Put p = this.creatPutWith2Families(TEST_ROW);
        NavigableMap familyMap = p.getFamilyCellMap();
        WALEdit edit = new WALEdit();
        this.addFamilyMapToWALEdit(familyMap, edit);
        boolean foundFamily0 = false;
        boolean foundFamily2 = false;
        boolean modifiedFamily1 = false;
        ArrayList cells = edit.getCells();
        for (Cell cell : cells) {
            if (Arrays.equals(cell.getFamily(), TEST_FAMILY[0])) {
                foundFamily0 = true;
            }
            if (Arrays.equals(cell.getFamily(), TEST_FAMILY[2])) {
                foundFamily2 = true;
            }
            if (!Arrays.equals(cell.getFamily(), TEST_FAMILY[1]) || Arrays.equals(cell.getValue(), TEST_VALUE[1])) continue;
            modifiedFamily1 = true;
        }
        Assert.assertTrue((boolean)foundFamily0);
        Assert.assertFalse((boolean)foundFamily2);
        Assert.assertFalse((boolean)modifiedFamily1);
        long now = EnvironmentEdgeManager.currentTime();
        long txid = log.append(htd, hri, (WALKey)new HLogKey(hri.getEncodedNameAsBytes(), hri.getTable(), now), edit, sequenceId, true, null);
        log.sync(txid);
        foundFamily0 = false;
        foundFamily2 = false;
        modifiedFamily1 = false;
        for (Cell cell : cells) {
            if (Arrays.equals(cell.getFamily(), TEST_FAMILY[0])) {
                foundFamily0 = true;
            }
            if (Arrays.equals(cell.getFamily(), TEST_FAMILY[2])) {
                foundFamily2 = true;
            }
            if (!Arrays.equals(cell.getFamily(), TEST_FAMILY[1]) || Arrays.equals(cell.getValue(), TEST_VALUE[1])) continue;
            modifiedFamily1 = true;
        }
        Assert.assertFalse((boolean)foundFamily0);
        Assert.assertTrue((boolean)foundFamily2);
        Assert.assertTrue((boolean)modifiedFamily1);
        Assert.assertTrue((boolean)cp.isPreWALWriteCalled());
        Assert.assertTrue((boolean)cp.isPostWALWriteCalled());
        Assert.assertEquals((Object)seesLegacy, (Object)cp.isPreWALWriteDeprecatedCalled());
        Assert.assertEquals((Object)seesLegacy, (Object)cp.isPostWALWriteDeprecatedCalled());
    }

    @Test
    public void testNonLegacyWALKeysDoNotExplode() throws Exception {
        TableName tableName = TableName.valueOf((byte[])TEST_TABLE);
        HTableDescriptor htd = this.createBasic3FamilyHTD(Bytes.toString((byte[])TEST_TABLE));
        HRegionInfo hri = new HRegionInfo(tableName, null, null);
        AtomicLong sequenceId = new AtomicLong(0L);
        this.fs.mkdirs(new Path(FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName), hri.getEncodedName()));
        Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        WAL wal = this.wals.getWAL(UNSPECIFIED_REGION);
        SampleRegionWALObserver newApi = this.getCoprocessor(wal, SampleRegionWALObserver.class);
        newApi.setTestValues(TEST_TABLE, TEST_ROW, null, null, null, null, null, null);
        SampleRegionWALObserver oldApi = this.getCoprocessor(wal, SampleRegionWALObserver.Legacy.class);
        oldApi.setTestValues(TEST_TABLE, TEST_ROW, null, null, null, null, null, null);
        LOG.debug((Object)"ensuring wal entries haven't happened before we start");
        Assert.assertFalse((boolean)newApi.isPreWALWriteCalled());
        Assert.assertFalse((boolean)newApi.isPostWALWriteCalled());
        Assert.assertFalse((boolean)newApi.isPreWALWriteDeprecatedCalled());
        Assert.assertFalse((boolean)newApi.isPostWALWriteDeprecatedCalled());
        Assert.assertFalse((boolean)oldApi.isPreWALWriteCalled());
        Assert.assertFalse((boolean)oldApi.isPostWALWriteCalled());
        Assert.assertFalse((boolean)oldApi.isPreWALWriteDeprecatedCalled());
        Assert.assertFalse((boolean)oldApi.isPostWALWriteDeprecatedCalled());
        LOG.debug((Object)"writing to WAL with non-legacy keys.");
        int countPerFamily = 5;
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            this.addWALEdits(tableName, hri, TEST_ROW, hcd.getName(), 5, EnvironmentEdgeManager.getDelegate(), wal, htd, sequenceId);
        }
        LOG.debug((Object)"Verify that only the non-legacy CP saw edits.");
        Assert.assertTrue((boolean)newApi.isPreWALWriteCalled());
        Assert.assertTrue((boolean)newApi.isPostWALWriteCalled());
        Assert.assertFalse((boolean)newApi.isPreWALWriteDeprecatedCalled());
        Assert.assertFalse((boolean)newApi.isPostWALWriteDeprecatedCalled());
        Assert.assertFalse((boolean)oldApi.isPreWALWriteCalled());
        Assert.assertFalse((boolean)oldApi.isPostWALWriteCalled());
        Assert.assertFalse((boolean)oldApi.isPreWALWriteDeprecatedCalled());
        Assert.assertFalse((boolean)oldApi.isPostWALWriteDeprecatedCalled());
        LOG.debug((Object)"reseting cp state.");
        newApi.setTestValues(TEST_TABLE, TEST_ROW, null, null, null, null, null, null);
        oldApi.setTestValues(TEST_TABLE, TEST_ROW, null, null, null, null, null, null);
        LOG.debug((Object)"write a log edit that supports legacy cps.");
        long now = EnvironmentEdgeManager.currentTime();
        HLogKey legacyKey = new HLogKey(hri.getEncodedNameAsBytes(), hri.getTable(), now);
        WALEdit edit = new WALEdit();
        byte[] nonce = Bytes.toBytes((String)"1772");
        edit.add((Cell)new KeyValue(TEST_ROW, TEST_FAMILY[0], nonce, now, nonce));
        long txid = wal.append(htd, hri, (WALKey)legacyKey, edit, sequenceId, true, null);
        wal.sync(txid);
        LOG.debug((Object)"Make sure legacy cps can see supported edits after having been skipped.");
        Assert.assertTrue((String)"non-legacy WALObserver didn't see pre-write.", (boolean)newApi.isPreWALWriteCalled());
        Assert.assertTrue((String)"non-legacy WALObserver didn't see post-write.", (boolean)newApi.isPostWALWriteCalled());
        Assert.assertFalse((String)"non-legacy WALObserver shouldn't have seen legacy pre-write.", (boolean)newApi.isPreWALWriteDeprecatedCalled());
        Assert.assertFalse((String)"non-legacy WALObserver shouldn't have seen legacy post-write.", (boolean)newApi.isPostWALWriteDeprecatedCalled());
        Assert.assertTrue((String)"legacy WALObserver didn't see pre-write.", (boolean)oldApi.isPreWALWriteCalled());
        Assert.assertTrue((String)"legacy WALObserver didn't see post-write.", (boolean)oldApi.isPostWALWriteCalled());
        Assert.assertTrue((String)"legacy WALObserver didn't see legacy pre-write.", (boolean)oldApi.isPreWALWriteDeprecatedCalled());
        Assert.assertTrue((String)"legacy WALObserver didn't see legacy post-write.", (boolean)oldApi.isPostWALWriteDeprecatedCalled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyWALEditAreNotSeen() throws Exception {
        HRegionInfo hri = this.createBasic3FamilyHRegionInfo(Bytes.toString((byte[])TEST_TABLE));
        HTableDescriptor htd = this.createBasic3FamilyHTD(Bytes.toString((byte[])TEST_TABLE));
        AtomicLong sequenceId = new AtomicLong(0L);
        try (WAL log = this.wals.getWAL(UNSPECIFIED_REGION);){
            SampleRegionWALObserver cp = this.getCoprocessor(log, SampleRegionWALObserver.class);
            cp.setTestValues(TEST_TABLE, null, null, null, null, null, null, null);
            Assert.assertFalse((boolean)cp.isPreWALWriteCalled());
            Assert.assertFalse((boolean)cp.isPostWALWriteCalled());
            long now = EnvironmentEdgeManager.currentTime();
            long txid = log.append(htd, hri, new WALKey(hri.getEncodedNameAsBytes(), hri.getTable(), now), new WALEdit(), sequenceId, true, null);
            log.sync(txid);
            Assert.assertFalse((String)"Empty WALEdit should skip coprocessor evaluation.", (boolean)cp.isPreWALWriteCalled());
            Assert.assertFalse((String)"Empty WALEdit should skip coprocessor evaluation.", (boolean)cp.isPostWALWriteCalled());
        }
    }

    @Test
    public void testWALCoprocessorReplay() throws Exception {
        TableName tableName = TableName.valueOf((String)"testWALCoprocessorReplay");
        final HTableDescriptor htd = this.getBasic3FamilyHTableDescriptor(tableName);
        AtomicLong sequenceId = new AtomicLong(0L);
        final HRegionInfo hri = new HRegionInfo(tableName, null, null);
        Path basedir = FSUtils.getTableDir((Path)this.hbaseRootDir, (TableName)tableName);
        this.deleteDir(basedir);
        this.fs.mkdirs(new Path(basedir, hri.getEncodedName()));
        final Configuration newConf = HBaseConfiguration.create((Configuration)this.conf);
        WAL wal = this.wals.getWAL(UNSPECIFIED_REGION);
        WALEdit edit = new WALEdit();
        long now = EnvironmentEdgeManager.currentTime();
        int countPerFamily = 1000;
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            this.addWALEdits(tableName, hri, TEST_ROW, hcd.getName(), 1000, EnvironmentEdgeManager.getDelegate(), wal, htd, sequenceId);
        }
        wal.append(htd, hri, new WALKey(hri.getEncodedNameAsBytes(), tableName, now), edit, sequenceId, true, null);
        wal.sync();
        User user = HBaseTestingUtility.getDifferentUser(newConf, ".replay.wal.secondtime");
        user.runAs(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                Path p = TestWALObserver.this.runWALSplit(newConf);
                LOG.info((Object)("WALSplit path == " + p));
                FileSystem newFS = FileSystem.get((Configuration)newConf);
                WALFactory wals2 = new WALFactory(TestWALObserver.this.conf, null, TestWALObserver.this.currentTest.getMethodName() + "2");
                WAL wal2 = wals2.getWAL(UNSPECIFIED_REGION);
                HRegion region = HRegion.openHRegion((Configuration)newConf, (FileSystem)FileSystem.get((Configuration)newConf), (Path)TestWALObserver.this.hbaseRootDir, (HRegionInfo)hri, (HTableDescriptor)htd, (WAL)wal2, (RegionServerServices)TEST_UTIL.getHBaseCluster().getRegionServer(0), null);
                long seqid2 = region.getOpenSeqNum();
                SampleRegionWALObserver cp2 = (SampleRegionWALObserver)region.getCoprocessorHost().findCoprocessor(SampleRegionWALObserver.class.getName());
                Assert.assertNotNull((Object)((Object)cp2));
                Assert.assertTrue((boolean)cp2.isPreWALRestoreCalled());
                Assert.assertTrue((boolean)cp2.isPostWALRestoreCalled());
                Assert.assertFalse((boolean)cp2.isPreWALRestoreDeprecatedCalled());
                Assert.assertFalse((boolean)cp2.isPostWALRestoreDeprecatedCalled());
                region.close();
                wals2.close();
                return null;
            }
        });
    }

    @Test
    public void testWALObserverLoaded() throws Exception {
        WAL log = this.wals.getWAL(UNSPECIFIED_REGION);
        Assert.assertNotNull((Object)((Object)this.getCoprocessor(log, SampleRegionWALObserver.class)));
    }

    private SampleRegionWALObserver getCoprocessor(WAL wal, Class<? extends SampleRegionWALObserver> clazz) throws Exception {
        WALCoprocessorHost host = wal.getCoprocessorHost();
        Coprocessor c = host.findCoprocessor(clazz.getName());
        return (SampleRegionWALObserver)c;
    }

    private HRegionInfo createBasic3FamilyHRegionInfo(String tableName) {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)tableName));
        for (int i = 0; i < TEST_FAMILY.length; ++i) {
            HColumnDescriptor a = new HColumnDescriptor(TEST_FAMILY[i]);
            htd.addFamily(a);
        }
        return new HRegionInfo(htd.getTableName(), null, null, false);
    }

    private void deleteDir(Path p) throws IOException {
        if (this.fs.exists(p) && !this.fs.delete(p, true)) {
            throw new IOException("Failed remove of " + p);
        }
    }

    private Put creatPutWith2Families(byte[] row) throws IOException {
        Put p = new Put(row);
        for (int i = 0; i < TEST_FAMILY.length - 1; ++i) {
            p.add(TEST_FAMILY[i], TEST_QUALIFIER[i], TEST_VALUE[i]);
        }
        return p;
    }

    private void addFamilyMapToWALEdit(Map<byte[], List<Cell>> familyMap, WALEdit walEdit) {
        for (List<Cell> edits : familyMap.values()) {
            for (Cell cell : edits) {
                walEdit.add(cell);
            }
        }
    }

    private Path runWALSplit(Configuration c) throws IOException {
        List splits = WALSplitter.split((Path)this.hbaseRootDir, (Path)this.logDir, (Path)this.oldLogDir, (FileSystem)FileSystem.get((Configuration)c), (Configuration)c, (WALFactory)this.wals);
        Assert.assertEquals((long)1L, (long)splits.size());
        Assert.assertTrue((boolean)this.fs.exists((Path)splits.get(0)));
        LOG.info((Object)("Split file=" + splits.get(0)));
        return (Path)splits.get(0);
    }

    private void addWALEdits(TableName tableName, HRegionInfo hri, byte[] rowName, byte[] family, int count, EnvironmentEdge ee, WAL wal, HTableDescriptor htd, AtomicLong sequenceId) throws IOException {
        String familyStr = Bytes.toString((byte[])family);
        long txid = -1L;
        for (int j = 0; j < count; ++j) {
            byte[] qualifierBytes = Bytes.toBytes((String)Integer.toString(j));
            byte[] columnBytes = Bytes.toBytes((String)(familyStr + ":" + Integer.toString(j)));
            WALEdit edit = new WALEdit();
            edit.add((Cell)new KeyValue(rowName, family, qualifierBytes, ee.currentTime(), columnBytes));
            txid = wal.append(htd, hri, new WALKey(hri.getEncodedNameAsBytes(), tableName, ee.currentTime()), edit, sequenceId, true, null);
        }
        if (-1L != txid) {
            wal.sync(txid);
        }
    }

    private HTableDescriptor getBasic3FamilyHTableDescriptor(TableName tableName) {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        for (int i = 0; i < TEST_FAMILY.length; ++i) {
            HColumnDescriptor a = new HColumnDescriptor(TEST_FAMILY[i]);
            htd.addFamily(a);
        }
        return htd;
    }

    private HTableDescriptor createBasic3FamilyHTD(String tableName) {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)tableName));
        HColumnDescriptor a = new HColumnDescriptor(Bytes.toBytes((String)"a"));
        htd.addFamily(a);
        HColumnDescriptor b = new HColumnDescriptor(Bytes.toBytes((String)"b"));
        htd.addFamily(b);
        HColumnDescriptor c = new HColumnDescriptor(Bytes.toBytes((String)"c"));
        htd.addFamily(c);
        return htd;
    }
}

