/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.master.AssignmentListener;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.ServerListener;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestAssignmentListener {
    private static final Log LOG = LogFactory.getLog(TestAssignmentListener.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testServerListener() throws IOException, InterruptedException {
        ServerManager serverManager = TEST_UTIL.getHBaseCluster().getMaster().getServerManager();
        DummyServerListener listener = new DummyServerListener();
        serverManager.registerListener((ServerListener)listener);
        try {
            MiniHBaseCluster miniCluster = TEST_UTIL.getMiniHBaseCluster();
            miniCluster.startRegionServer();
            listener.awaitModifications(1);
            Assert.assertEquals((long)1L, (long)listener.getAddedCount());
            Assert.assertEquals((long)0L, (long)listener.getRemovedCount());
            listener.reset();
            miniCluster.startRegionServer();
            listener.awaitModifications(1);
            Assert.assertEquals((long)1L, (long)listener.getAddedCount());
            Assert.assertEquals((long)0L, (long)listener.getRemovedCount());
            int nrs = miniCluster.getRegionServerThreads().size();
            listener.reset();
            miniCluster.stopRegionServer(nrs - 1);
            listener.awaitModifications(1);
            Assert.assertEquals((long)0L, (long)listener.getAddedCount());
            Assert.assertEquals((long)1L, (long)listener.getRemovedCount());
            listener.reset();
            miniCluster.stopRegionServer(nrs - 2);
            listener.awaitModifications(1);
            Assert.assertEquals((long)0L, (long)listener.getAddedCount());
            Assert.assertEquals((long)1L, (long)listener.getRemovedCount());
        }
        finally {
            serverManager.unregisterListener((ServerListener)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testAssignmentListener() throws IOException, InterruptedException {
        AssignmentManager am = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        DummyAssignmentListener listener = new DummyAssignmentListener();
        am.registerListener((AssignmentListener)listener);
        try {
            String TABLE_NAME_STR = "testtb";
            TableName TABLE_NAME = TableName.valueOf((String)"testtb");
            byte[] FAMILY = Bytes.toBytes((String)"cf");
            LOG.info((Object)"Create Table");
            TEST_UTIL.createTable(TABLE_NAME, FAMILY);
            listener.awaitModifications(1);
            Assert.assertEquals((long)1L, (long)listener.getLoadCount());
            Assert.assertEquals((long)0L, (long)listener.getCloseCount());
            try (HTable table = new HTable(TEST_UTIL.getConfiguration(), TABLE_NAME);){
                for (int i = 0; i < 10; ++i) {
                    byte[] key = Bytes.toBytes((String)("row-" + i));
                    Put put = new Put(key);
                    put.add(FAMILY, null, key);
                    table.put(put);
                }
            }
            LOG.info((Object)"Split Table");
            listener.reset();
            admin.split(TABLE_NAME, Bytes.toBytes((String)"row-3"));
            listener.awaitModifications(3);
            Assert.assertEquals((long)2L, (long)listener.getLoadCount());
            Assert.assertEquals((long)1L, (long)listener.getCloseCount());
            MiniHBaseCluster miniCluster = TEST_UTIL.getMiniHBaseCluster();
            int mergeable = 0;
            while (mergeable < 2) {
                Thread.sleep(100L);
                admin.majorCompact(TABLE_NAME);
                mergeable = 0;
                for (JVMClusterUtil.RegionServerThread regionThread : miniCluster.getRegionServerThreads()) {
                    for (HRegion region : regionThread.getRegionServer().getOnlineRegions(TABLE_NAME)) {
                        mergeable += region.isMergeable() ? 1 : 0;
                    }
                }
            }
            LOG.info((Object)"Merge Regions");
            listener.reset();
            List regions = admin.getTableRegions(TABLE_NAME);
            Assert.assertEquals((long)2L, (long)regions.size());
            admin.mergeRegions(((HRegionInfo)regions.get(0)).getEncodedNameAsBytes(), ((HRegionInfo)regions.get(1)).getEncodedNameAsBytes(), true);
            listener.awaitModifications(3);
            Assert.assertEquals((long)1L, (long)admin.getTableRegions(TABLE_NAME).size());
            Assert.assertEquals((long)1L, (long)listener.getLoadCount());
            Assert.assertEquals((long)2L, (long)listener.getCloseCount());
            LOG.info((Object)"Drop Table");
            listener.reset();
            TEST_UTIL.deleteTable(TABLE_NAME);
            listener.awaitModifications(1);
            Assert.assertEquals((long)0L, (long)listener.getLoadCount());
            Assert.assertEquals((long)1L, (long)listener.getCloseCount());
        }
        finally {
            am.unregisterListener((AssignmentListener)listener);
        }
    }

    static class DummyServerListener
    extends DummyListener
    implements ServerListener {
        private AtomicInteger removedCount = new AtomicInteger(0);
        private AtomicInteger addedCount = new AtomicInteger(0);

        public void serverAdded(ServerName serverName) {
            LOG.info((Object)("Server added " + serverName));
            this.addedCount.incrementAndGet();
            this.modified.incrementAndGet();
        }

        public void serverRemoved(ServerName serverName) {
            LOG.info((Object)("Server removed " + serverName));
            this.removedCount.incrementAndGet();
            this.modified.incrementAndGet();
        }

        public void reset() {
            this.addedCount.set(0);
            this.removedCount.set(0);
        }

        public int getAddedCount() {
            return this.addedCount.get();
        }

        public int getRemovedCount() {
            return this.removedCount.get();
        }
    }

    static class DummyAssignmentListener
    extends DummyListener
    implements AssignmentListener {
        private AtomicInteger closeCount = new AtomicInteger(0);
        private AtomicInteger openCount = new AtomicInteger(0);

        public void regionOpened(HRegionInfo regionInfo, ServerName serverName) {
            LOG.info((Object)("Assignment open region=" + regionInfo + " server=" + serverName));
            this.openCount.incrementAndGet();
            this.modified.incrementAndGet();
        }

        public void regionClosed(HRegionInfo regionInfo) {
            LOG.info((Object)("Assignment close region=" + regionInfo));
            this.closeCount.incrementAndGet();
            this.modified.incrementAndGet();
        }

        public void reset() {
            this.openCount.set(0);
            this.closeCount.set(0);
        }

        public int getLoadCount() {
            return this.openCount.get();
        }

        public int getCloseCount() {
            return this.closeCount.get();
        }
    }

    static class DummyListener {
        protected AtomicInteger modified = new AtomicInteger(0);

        DummyListener() {
        }

        public void awaitModifications(int count) throws InterruptedException {
            while (!this.modified.compareAndSet(count, 0)) {
                Thread.sleep(100L);
            }
        }
    }
}

