/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={SmallTests.class})
public class TestMinVersions {
    HBaseTestingUtility hbu = HBaseTestingUtility.createLocalHTU();
    private final byte[] T0 = Bytes.toBytes((String)"0");
    private final byte[] T1 = Bytes.toBytes((String)"1");
    private final byte[] T2 = Bytes.toBytes((String)"2");
    private final byte[] T3 = Bytes.toBytes((String)"3");
    private final byte[] T4 = Bytes.toBytes((String)"4");
    private final byte[] T5 = Bytes.toBytes((String)"5");
    private final byte[] c0 = HBaseTestingUtility.COLUMNS[0];
    @Rule
    public TestName name = new TestName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetClosestBefore() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 1, 1000, 1, KeepDeletedCells.FALSE);
        HRegion region = this.hbu.createLocalHRegion(htd, null, null);
        try {
            long ts = EnvironmentEdgeManager.currentTime() - 2000L;
            Put p = new Put(this.T1, ts);
            p.add(this.c0, this.c0, this.T1);
            region.put(p);
            p = new Put(this.T1, ts + 1L);
            p.add(this.c0, this.c0, this.T4);
            region.put(p);
            p = new Put(this.T3, ts);
            p.add(this.c0, this.c0, this.T3);
            region.put(p);
            Result r = region.getClosestRowBefore(this.T1, this.c0);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            r = region.getClosestRowBefore(this.T2, this.c0);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            region.flushcache();
            region.compactStores(true);
            r = region.getClosestRowBefore(this.T1, this.c0);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            r = region.getClosestRowBefore(this.T2, this.c0);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
        }
        finally {
            HRegion.closeHRegion((HRegion)region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStoreMemStore() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 3, 1000, 1, KeepDeletedCells.FALSE);
        HRegion region = this.hbu.createLocalHRegion(htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime() - 2000L;
        try {
            Put p = new Put(this.T1, ts - 1L);
            p.add(this.c0, this.c0, this.T2);
            region.put(p);
            p = new Put(this.T1, ts - 3L);
            p.add(this.c0, this.c0, this.T0);
            region.put(p);
            region.flushcache();
            region.compactStores(true);
            p = new Put(this.T1, ts);
            p.add(this.c0, this.c0, this.T3);
            region.put(p);
            p = new Put(this.T1, ts - 2L);
            p.add(this.c0, this.c0, this.T1);
            region.put(p);
            p = new Put(this.T1, ts - 3L);
            p.add(this.c0, this.c0, this.T0);
            region.put(p);
            Get g = new Get(this.T1);
            g.setMaxVersions();
            Result r = region.get(g);
            this.checkResult(r, this.c0, this.T3, this.T2, this.T1);
            g = new Get(this.T1);
            g.setMaxVersions();
            g.addColumn(this.c0, this.c0);
            r = region.get(g);
            this.checkResult(r, this.c0, this.T3, this.T2, this.T1);
        }
        finally {
            HRegion.closeHRegion((HRegion)region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 3, 1000, 1, KeepDeletedCells.FALSE);
        HRegion region = this.hbu.createLocalHRegion(htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime() - 2000L;
        try {
            Put p = new Put(this.T1, ts - 2L);
            p.add(this.c0, this.c0, this.T1);
            region.put(p);
            p = new Put(this.T1, ts - 1L);
            p.add(this.c0, this.c0, this.T2);
            region.put(p);
            p = new Put(this.T1, ts);
            p.add(this.c0, this.c0, this.T3);
            region.put(p);
            Delete d = new Delete(this.T1, ts - 1L);
            region.delete(d);
            Get g = new Get(this.T1);
            g.setMaxVersions();
            Result r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T3});
            g = new Get(this.T1);
            g.setMaxVersions();
            g.addColumn(this.c0, this.c0);
            r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T3});
            region.flushcache();
            region.compactStores(true);
            g = new Get(this.T1);
            g.setMaxVersions();
            r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T3});
            g = new Get(this.T1);
            g.setMaxVersions();
            g.addColumn(this.c0, this.c0);
            r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T3});
        }
        finally {
            HRegion.closeHRegion((HRegion)region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMemStore() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 2, 1000, 1, KeepDeletedCells.FALSE);
        HRegion region = this.hbu.createLocalHRegion(htd, null, null);
        long ts = EnvironmentEdgeManager.currentTime() - 2000L;
        try {
            Put p = new Put(this.T1, ts - 2L);
            p.add(this.c0, this.c0, this.T2);
            region.put(p);
            p = new Put(this.T1, ts - 1L);
            p.add(this.c0, this.c0, this.T3);
            region.put(p);
            p = new Put(this.T1, ts);
            p.add(this.c0, this.c0, this.T4);
            region.put(p);
            region.flushcache();
            region.compactStores(true);
            p = new Put(this.T1, ts - 3L);
            p.add(this.c0, this.c0, this.T1);
            region.put(p);
            Result r = region.get(new Get(this.T1));
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            Get g = new Get(this.T1);
            g.setMaxVersions();
            r = region.get(g);
            this.checkResult(r, this.c0, this.T4, this.T3);
            g = new Get(this.T1);
            g.setMaxVersions();
            g.addColumn(this.c0, this.c0);
            r = region.get(g);
            this.checkResult(r, this.c0, this.T4, this.T3);
            p = new Put(this.T1, ts + 1L);
            p.add(this.c0, this.c0, this.T5);
            region.put(p);
            g = new Get(this.T1);
            g.setMaxVersions();
            r = region.get(g);
            this.checkResult(r, this.c0, this.T5, this.T4);
            g = new Get(this.T1);
            g.setMaxVersions();
            g.addColumn(this.c0, this.c0);
            r = region.get(g);
            this.checkResult(r, this.c0, this.T5, this.T4);
        }
        finally {
            HRegion.closeHRegion((HRegion)region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBaseCase() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 2, 1000, 1, KeepDeletedCells.FALSE);
        HRegion region = this.hbu.createLocalHRegion(htd, null, null);
        try {
            long ts = EnvironmentEdgeManager.currentTime() - 2000L;
            Put p = new Put(this.T1, ts - 3L);
            p.add(this.c0, this.c0, this.T1);
            region.put(p);
            p = new Put(this.T1, ts - 2L);
            p.add(this.c0, this.c0, this.T2);
            region.put(p);
            p = new Put(this.T1, ts - 1L);
            p.add(this.c0, this.c0, this.T3);
            region.put(p);
            p = new Put(this.T1, ts);
            p.add(this.c0, this.c0, this.T4);
            region.put(p);
            Result r = region.get(new Get(this.T1));
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            Get g = new Get(this.T1);
            g.setTimeRange(0L, ts + 1L);
            r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            g.setTimeRange(0L, ts - 2L);
            r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T1});
            g = new Get(this.T1);
            g.setMaxVersions();
            r = region.get(g);
            this.checkResult(r, this.c0, this.T4, this.T3);
            g = new Get(this.T1);
            g.setMaxVersions();
            g.addColumn(this.c0, this.c0);
            r = region.get(g);
            this.checkResult(r, this.c0, this.T4, this.T3);
            region.flushcache();
            g = new Get(this.T1);
            g.setTimeRange(0L, ts - 2L);
            r = region.get(g);
            Assert.assertTrue((boolean)r.isEmpty());
            region.compactStores(true);
            g = new Get(this.T1);
            g.setTimeRange(0L, ts + 1L);
            r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T4});
            g.setTimeRange(0L, ts);
            r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T3});
            g.setTimeRange(0L, ts - 1L);
            r = region.get(g);
            Assert.assertTrue((boolean)r.isEmpty());
        }
        finally {
            HRegion.closeHRegion((HRegion)region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFilters() throws Exception {
        HTableDescriptor htd = this.hbu.createTableDescriptor(this.name.getMethodName(), 2, 1000, 1, KeepDeletedCells.FALSE);
        HRegion region = this.hbu.createLocalHRegion(htd, null, null);
        byte[] c1 = HBaseTestingUtility.COLUMNS[1];
        long ts = EnvironmentEdgeManager.currentTime() - 2000L;
        try {
            Put p = new Put(this.T1, ts - 3L);
            p.add(this.c0, this.c0, this.T0);
            p.add(c1, c1, this.T0);
            region.put(p);
            p = new Put(this.T1, ts - 2L);
            p.add(this.c0, this.c0, this.T1);
            p.add(c1, c1, this.T1);
            region.put(p);
            p = new Put(this.T1, ts - 1L);
            p.add(this.c0, this.c0, this.T2);
            p.add(c1, c1, this.T2);
            region.put(p);
            p = new Put(this.T1, ts);
            p.add(this.c0, this.c0, this.T3);
            p.add(c1, c1, this.T3);
            region.put(p);
            ArrayList<Long> tss = new ArrayList<Long>();
            tss.add(ts - 1L);
            tss.add(ts - 2L);
            Get g = new Get(this.T1);
            g.addColumn(c1, c1);
            g.setFilter((Filter)new TimestampsFilter(tss));
            g.setMaxVersions();
            Result r = region.get(g);
            this.checkResult(r, c1, this.T2, this.T1);
            g = new Get(this.T1);
            g.addColumn(this.c0, this.c0);
            g.setFilter((Filter)new TimestampsFilter(tss));
            g.setMaxVersions();
            r = region.get(g);
            this.checkResult(r, this.c0, this.T2, this.T1);
            region.flushcache();
            region.compactStores(true);
            g = new Get(this.T1);
            g.addColumn(c1, c1);
            g.setFilter((Filter)new TimestampsFilter(tss));
            g.setMaxVersions();
            r = region.get(g);
            this.checkResult(r, c1, new byte[][]{this.T2});
            g = new Get(this.T1);
            g.addColumn(this.c0, this.c0);
            g.setFilter((Filter)new TimestampsFilter(tss));
            g.setMaxVersions();
            r = region.get(g);
            this.checkResult(r, this.c0, new byte[][]{this.T2});
        }
        finally {
            HRegion.closeHRegion((HRegion)region);
        }
    }

    private void checkResult(Result r, byte[] col, byte[] ... vals) {
        Assert.assertEquals((long)r.size(), (long)vals.length);
        List kvs = r.getColumnCells(col, col);
        Assert.assertEquals((long)kvs.size(), (long)vals.length);
        for (int i = 0; i < vals.length; ++i) {
            Assert.assertTrue((boolean)CellUtil.matchingValue((Cell)((Cell)kvs.get(i)), (byte[])vals[i]));
        }
    }
}

