/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessControlFilter;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.access.TableAuthManager;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.TestTableName;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={LargeTests.class})
public class TestWithDisabledAuthorization
extends SecureTestUtil {
    private static final Log LOG = LogFactory.getLog(TestWithDisabledAuthorization.class);
    private static final HBaseTestingUtility TEST_UTIL;
    private static final byte[] TEST_FAMILY;
    private static final byte[] TEST_FAMILY2;
    private static final byte[] TEST_ROW;
    private static final byte[] TEST_Q1;
    private static final byte[] TEST_Q2;
    private static final byte[] TEST_Q3;
    private static final byte[] TEST_Q4;
    private static final byte[] ZERO;
    private static MasterCoprocessorEnvironment CP_ENV;
    private static AccessController ACCESS_CONTROLLER;
    private static RegionServerCoprocessorEnvironment RSCP_ENV;
    private RegionCoprocessorEnvironment RCP_ENV;
    @Rule
    public TestTableName TEST_TABLE = new TestTableName();
    private static User SUPERUSER;
    private static User USER_ADMIN;
    private static User USER_RW;
    private static User USER_RO;
    private static User USER_OWNER;
    private static User USER_CREATE;
    private static User USER_NONE;
    private static User USER_QUAL;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        TestWithDisabledAuthorization.enableSecurity(conf);
        conf.setBoolean("hbase.security.access.early_out", false);
        conf.setBoolean("hbase.security.exec.permission.checks", true);
        TestWithDisabledAuthorization.verifyConfiguration(conf);
        conf.setBoolean("hbase.security.authorization", false);
        TEST_UTIL.startMiniCluster();
        MasterCoprocessorHost cpHost = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterCoprocessorHost();
        cpHost.load(AccessController.class, 0, conf);
        ACCESS_CONTROLLER = (AccessController)cpHost.findCoprocessor(AccessController.class.getName());
        CP_ENV = cpHost.createEnvironment(AccessController.class, (Coprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        RegionServerCoprocessorHost rsHost = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getRegionServerCoprocessorHost();
        RSCP_ENV = rsHost.createEnvironment(AccessController.class, (Coprocessor)ACCESS_CONTROLLER, 0, 1, conf);
        TEST_UTIL.waitUntilAllRegionsAssigned(AccessControlLists.ACL_TABLE_NAME);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        USER_ADMIN = User.createUserForTesting((Configuration)conf, (String)"admin2", (String[])new String[0]);
        USER_OWNER = User.createUserForTesting((Configuration)conf, (String)"owner", (String[])new String[0]);
        USER_CREATE = User.createUserForTesting((Configuration)conf, (String)"tbl_create", (String[])new String[0]);
        USER_RW = User.createUserForTesting((Configuration)conf, (String)"rwuser", (String[])new String[0]);
        USER_RO = User.createUserForTesting((Configuration)conf, (String)"rouser", (String[])new String[0]);
        USER_QUAL = User.createUserForTesting((Configuration)conf, (String)"rwpartial", (String[])new String[0]);
        USER_NONE = User.createUserForTesting((Configuration)conf, (String)"nouser", (String[])new String[0]);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor htd = new HTableDescriptor(this.TEST_TABLE.getTableName());
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY);
        hcd.setMaxVersions(100);
        htd.addFamily(hcd);
        htd.setOwner(USER_OWNER);
        admin.createTable(htd, (byte[][])new byte[][]{Bytes.toBytes((String)"s")});
        TEST_UTIL.waitUntilAllRegionsAssigned(this.TEST_TABLE.getTableName());
        HRegion region = TEST_UTIL.getHBaseCluster().getRegions(this.TEST_TABLE.getTableName()).get(0);
        RegionCoprocessorHost rcpHost = region.getCoprocessorHost();
        this.RCP_ENV = rcpHost.createEnvironment(AccessController.class, (Coprocessor)ACCESS_CONTROLLER, 0, 1, TEST_UTIL.getConfiguration());
        TestWithDisabledAuthorization.grantGlobal(TEST_UTIL, USER_ADMIN.getShortName(), Permission.Action.ADMIN, Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE);
        TestWithDisabledAuthorization.grantOnTable(TEST_UTIL, USER_RW.getShortName(), this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ, Permission.Action.WRITE);
        TestWithDisabledAuthorization.grantOnTable(TEST_UTIL, USER_CREATE.getShortName(), this.TEST_TABLE.getTableName(), null, null, Permission.Action.CREATE, Permission.Action.READ, Permission.Action.WRITE);
        TestWithDisabledAuthorization.grantOnTable(TEST_UTIL, USER_RO.getShortName(), this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ);
        TestWithDisabledAuthorization.grantOnTable(TEST_UTIL, USER_QUAL.getShortName(), this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q1, Permission.Action.READ, Permission.Action.WRITE);
        Assert.assertEquals((long)5L, (long)AccessControlLists.getTablePermissions((Configuration)TEST_UTIL.getConfiguration(), (TableName)this.TEST_TABLE.getTableName()).size());
    }

    @After
    public void tearDown() throws Exception {
        try {
            TEST_UTIL.deleteTable(this.TEST_TABLE.getTableName());
        }
        catch (TableNotFoundException ex) {
            LOG.info((Object)("Test deleted table " + this.TEST_TABLE.getTableName()));
        }
        Assert.assertEquals((long)0L, (long)AccessControlLists.getTablePermissions((Configuration)TEST_UTIL.getConfiguration(), (TableName)this.TEST_TABLE.getTableName()).size());
        Assert.assertEquals((long)0L, (long)AccessControlLists.getNamespacePermissions((Configuration)TEST_UTIL.getConfiguration(), (String)this.TEST_TABLE.getTableName().getNamespaceAsString()).size());
    }

    @Test
    public void testCheckPermissions() throws Exception {
        SecureTestUtil.AccessTestAction checkGlobalAdmin = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestWithDisabledAuthorization.this.checkGlobalPerms(TEST_UTIL, Permission.Action.ADMIN);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkGlobalAdmin, SUPERUSER, USER_ADMIN);
        TestWithDisabledAuthorization.verifyDenied(checkGlobalAdmin, USER_OWNER, USER_CREATE, USER_RW, USER_RO, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkGlobalRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestWithDisabledAuthorization.this.checkGlobalPerms(TEST_UTIL, Permission.Action.READ);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkGlobalRead, SUPERUSER, USER_ADMIN);
        TestWithDisabledAuthorization.verifyDenied(checkGlobalRead, USER_OWNER, USER_CREATE, USER_RW, USER_RO, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkGlobalReadWrite = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestWithDisabledAuthorization.this.checkGlobalPerms(TEST_UTIL, Permission.Action.READ, Permission.Action.WRITE);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkGlobalReadWrite, SUPERUSER, USER_ADMIN);
        TestWithDisabledAuthorization.verifyDenied(checkGlobalReadWrite, USER_OWNER, USER_CREATE, USER_RW, USER_RO, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkTableAdmin = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestWithDisabledAuthorization.this.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), null, null, Permission.Action.ADMIN);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkTableAdmin, SUPERUSER, USER_ADMIN, USER_OWNER);
        TestWithDisabledAuthorization.verifyDenied(checkTableAdmin, USER_CREATE, USER_RW, USER_RO, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkTableCreate = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestWithDisabledAuthorization.this.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), null, null, Permission.Action.CREATE);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkTableCreate, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE);
        TestWithDisabledAuthorization.verifyDenied(checkTableCreate, USER_RW, USER_RO, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkTableRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestWithDisabledAuthorization.this.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), null, null, Permission.Action.READ);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkTableRead, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE);
        TestWithDisabledAuthorization.verifyDenied(checkTableRead, USER_RW, USER_RO, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkTableReadWrite = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestWithDisabledAuthorization.this.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), null, null, Permission.Action.READ, Permission.Action.WRITE);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkTableReadWrite, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE);
        TestWithDisabledAuthorization.verifyDenied(checkTableReadWrite, USER_RW, USER_RO, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkColumnRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestWithDisabledAuthorization.this.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkColumnRead, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW, USER_RO);
        TestWithDisabledAuthorization.verifyDenied(checkColumnRead, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkColumnReadWrite = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestWithDisabledAuthorization.this.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ, Permission.Action.WRITE);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkColumnReadWrite, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW);
        TestWithDisabledAuthorization.verifyDenied(checkColumnReadWrite, USER_RO, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkQualifierRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestWithDisabledAuthorization.this.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q1, Permission.Action.READ);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkQualifierRead, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW, USER_RO, USER_QUAL);
        TestWithDisabledAuthorization.verifyDenied(checkQualifierRead, USER_NONE);
        SecureTestUtil.AccessTestAction checkQualifierReadWrite = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestWithDisabledAuthorization.this.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q1, Permission.Action.READ, Permission.Action.WRITE);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkQualifierReadWrite, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW, USER_QUAL);
        TestWithDisabledAuthorization.verifyDenied(checkQualifierReadWrite, USER_RO, USER_NONE);
        SecureTestUtil.AccessTestAction checkMultiQualifierRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestWithDisabledAuthorization.this.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), new Permission[]{new TablePermission(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q1, new Permission.Action[]{Permission.Action.READ}), new TablePermission(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q2, new Permission.Action[]{Permission.Action.READ})});
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkMultiQualifierRead, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW, USER_RO);
        TestWithDisabledAuthorization.verifyDenied(checkMultiQualifierRead, USER_QUAL, USER_NONE);
        SecureTestUtil.AccessTestAction checkMultiQualifierReadWrite = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestWithDisabledAuthorization.this.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), new Permission[]{new TablePermission(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q1, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}), new TablePermission(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY, TEST_Q2, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE})});
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(checkMultiQualifierReadWrite, SUPERUSER, USER_ADMIN, USER_OWNER, USER_CREATE, USER_RW);
        TestWithDisabledAuthorization.verifyDenied(checkMultiQualifierReadWrite, USER_RO, USER_QUAL, USER_NONE);
    }

    @Test
    public void testPassiveGrantRevoke() throws Exception {
        User tblUser = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"tbluser", (String[])new String[0]);
        SecureTestUtil.AccessTestAction checkTableRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                TestWithDisabledAuthorization.this.checkTablePerms(TEST_UTIL, TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ);
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyDenied(tblUser, checkTableRead);
        SecureTestUtil.AccessTestAction tableRead = new SecureTestUtil.AccessTestAction(){

            @Override
            public Void run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
                     Table t = conn.getTable(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());){
                    t.get(new Get(TEST_ROW).addFamily(TEST_FAMILY));
                }
                return null;
            }
        };
        TestWithDisabledAuthorization.verifyAllowed(tblUser, tableRead);
        TestWithDisabledAuthorization.grantOnTable(TEST_UTIL, tblUser.getShortName(), this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ);
        TestWithDisabledAuthorization.verifyAllowed(tblUser, checkTableRead);
        TestWithDisabledAuthorization.verifyAllowed(tblUser, tableRead);
        TestWithDisabledAuthorization.revokeFromTable(TEST_UTIL, tblUser.getShortName(), this.TEST_TABLE.getTableName(), TEST_FAMILY, null, Permission.Action.READ);
        TestWithDisabledAuthorization.verifyDenied(tblUser, checkTableRead);
        TestWithDisabledAuthorization.verifyAllowed(tblUser, tableRead);
    }

    @Test
    public void testPassiveMasterOperations() throws Exception {
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
                ACCESS_CONTROLLER.preCreateTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), htd, null);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
                htd.addFamily(new HColumnDescriptor(TEST_FAMILY2));
                ACCESS_CONTROLLER.preModifyTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), htd);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preTruncateTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY2);
                ACCESS_CONTROLLER.preAddColumn(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), hcd);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY2);
                ACCESS_CONTROLLER.preModifyColumn(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), hcd);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteColumn(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestWithDisabledAuthorization.this.TEST_TABLE.getTableName(), TEST_FAMILY2);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preEnableTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDisableTable(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HRegionInfo region = new HRegionInfo(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                ServerName srcServer = ServerName.valueOf((String)"1.1.1.1", (int)1, (long)0L);
                ServerName destServer = ServerName.valueOf((String)"2.2.2.2", (int)2, (long)0L);
                ACCESS_CONTROLLER.preMove(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), region, srcServer, destServer);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HRegionInfo region = new HRegionInfo(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                ACCESS_CONTROLLER.preAssign(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), region);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HRegionInfo region = new HRegionInfo(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                ACCESS_CONTROLLER.preUnassign(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), region, true);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preBalance(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null));
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preBalanceSwitch(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), true);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HBaseProtos.SnapshotDescription snapshot = HBaseProtos.SnapshotDescription.newBuilder().setName("foo").build();
                HTableDescriptor htd = new HTableDescriptor(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                ACCESS_CONTROLLER.preSnapshot(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), snapshot, htd);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HBaseProtos.SnapshotDescription snapshot = HBaseProtos.SnapshotDescription.newBuilder().setName("foo").build();
                HTableDescriptor htd = new HTableDescriptor(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                ACCESS_CONTROLLER.preCloneSnapshot(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), snapshot, htd);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HBaseProtos.SnapshotDescription snapshot = HBaseProtos.SnapshotDescription.newBuilder().setName("foo").build();
                HTableDescriptor htd = new HTableDescriptor(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                ACCESS_CONTROLLER.preRestoreSnapshot(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), snapshot, htd);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HBaseProtos.SnapshotDescription snapshot = HBaseProtos.SnapshotDescription.newBuilder().setName("foo").build();
                ACCESS_CONTROLLER.preDeleteSnapshot(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), snapshot);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ArrayList tableNamesList = Lists.newArrayList();
                tableNamesList.add(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                ArrayList descriptors = Lists.newArrayList();
                ACCESS_CONTROLLER.preGetTableDescriptors(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), (List)tableNamesList, (List)descriptors, ".+");
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ArrayList descriptors = Lists.newArrayList();
                ACCESS_CONTROLLER.preGetTableNames(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), (List)descriptors, ".+");
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                NamespaceDescriptor ns = NamespaceDescriptor.create((String)"test").build();
                ACCESS_CONTROLLER.preCreateNamespace(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), ns);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDeleteNamespace(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), "test");
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                NamespaceDescriptor ns = NamespaceDescriptor.create((String)"test").build();
                ACCESS_CONTROLLER.preModifyNamespace(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), ns);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preGetNamespaceDescriptor(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), "test");
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ArrayList descriptors = Lists.newArrayList();
                ACCESS_CONTROLLER.preListNamespaceDescriptors(ObserverContext.createAndPrepare((CoprocessorEnvironment)CP_ENV, null), (List)descriptors);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
    }

    @Test
    public void testPassiveRegionServerOperations() throws Exception {
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preStopRegionServer(ObserverContext.createAndPrepare((CoprocessorEnvironment)RSCP_ENV, null));
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                HTableDescriptor htd = new HTableDescriptor(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                HRegion region_a = (HRegion)Mockito.mock(HRegion.class);
                Mockito.when((Object)region_a.getTableDesc()).thenReturn((Object)htd);
                HRegion region_b = (HRegion)Mockito.mock(HRegion.class);
                Mockito.when((Object)region_b.getTableDesc()).thenReturn((Object)htd);
                ACCESS_CONTROLLER.preMerge(ObserverContext.createAndPrepare((CoprocessorEnvironment)RSCP_ENV, null), region_a, region_b);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preRollWALWriterRequest(ObserverContext.createAndPrepare((CoprocessorEnvironment)RSCP_ENV, null));
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
    }

    @Test
    public void testPassiveRegionOperations() throws Exception {
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preOpen(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV, null));
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preFlush(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV, null));
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preSplit(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV, null));
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preGetClosestRowBefore(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV, null), TEST_ROW, TEST_FAMILY, new Result());
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ArrayList cells = Lists.newArrayList();
                ACCESS_CONTROLLER.preGetOp(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV, null), new Get(TEST_ROW), (List)cells);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preExists(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV, null), new Get(TEST_ROW), true);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.prePut(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV, null), new Put(TEST_ROW), new WALEdit(), Durability.USE_DEFAULT);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preDelete(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV, null), new Delete(TEST_ROW), new WALEdit(), Durability.USE_DEFAULT);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preBatchMutate(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV, null), new MiniBatchOperationInProgress(null, null, null, 0, 0));
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCheckAndPut(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV, null), TEST_ROW, TEST_FAMILY, TEST_Q1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator("foo".getBytes()), new Put(TEST_ROW), true);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preCheckAndDelete(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV, null), TEST_ROW, TEST_FAMILY, TEST_Q1, CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator("foo".getBytes()), new Delete(TEST_ROW), true);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preAppend(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV, null), new Append(TEST_ROW));
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preIncrement(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV, null), new Increment(TEST_ROW));
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ACCESS_CONTROLLER.preScannerOpen(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV, null), new Scan(), (RegionScanner)Mockito.mock(RegionScanner.class));
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                ArrayList paths = Lists.newArrayList();
                ACCESS_CONTROLLER.preBulkLoadHFile(ObserverContext.createAndPrepare((CoprocessorEnvironment)TestWithDisabledAuthorization.this.RCP_ENV, null), (List)paths);
                return null;
            }
        }, SUPERUSER, USER_ADMIN, USER_RW, USER_RO, USER_OWNER, USER_CREATE, USER_QUAL, USER_NONE);
    }

    @Test
    public void testPassiveCellPermissions() throws Exception {
        final Configuration conf = TEST_UTIL.getConfiguration();
        TestWithDisabledAuthorization.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());){
                    Put p = new Put(TEST_ROW).add(TEST_FAMILY, TEST_Q1, ZERO);
                    p.setACL(USER_NONE.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ}));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY, TEST_Q2, ZERO);
                    p.setACL(USER_NONE.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                    p = new Put(TEST_ROW).add(TEST_FAMILY, TEST_Q3, ZERO).add(TEST_FAMILY, TEST_Q4, ZERO);
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        final ArrayList scanResults = Lists.newArrayList();
        SecureTestUtil.AccessTestAction scanAction = new SecureTestUtil.AccessTestAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Cell> run() throws Exception {
                Scan scan = new Scan();
                scan.setStartRow(TEST_ROW);
                scan.setStopRow(Bytes.add((byte[])TEST_ROW, (byte[])new byte[]{0}));
                scan.addFamily(TEST_FAMILY);
                Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                Table t = connection.getTable(TestWithDisabledAuthorization.this.TEST_TABLE.getTableName());
                try {
                    ResultScanner scanner = t.getScanner(scan);
                    Result result = null;
                    do {
                        if ((result = scanner.next()) == null) continue;
                        scanResults.addAll(result.listCells());
                    } while (result != null);
                }
                finally {
                    t.close();
                    connection.close();
                }
                return scanResults;
            }
        };
        scanResults.clear();
        TestWithDisabledAuthorization.verifyAllowed(scanAction, USER_OWNER);
        Assert.assertEquals((long)4L, (long)scanResults.size());
        scanResults.clear();
        TestWithDisabledAuthorization.verifyAllowed(scanAction, USER_NONE);
        Assert.assertEquals((long)4L, (long)scanResults.size());
    }

    static {
        Logger.getLogger(AccessController.class).setLevel(Level.TRACE);
        Logger.getLogger(AccessControlFilter.class).setLevel(Level.TRACE);
        Logger.getLogger(TableAuthManager.class).setLevel(Level.TRACE);
        TEST_UTIL = new HBaseTestingUtility();
        TEST_FAMILY = Bytes.toBytes((String)"f1");
        TEST_FAMILY2 = Bytes.toBytes((String)"f2");
        TEST_ROW = Bytes.toBytes((String)"testrow");
        TEST_Q1 = Bytes.toBytes((String)"q1");
        TEST_Q2 = Bytes.toBytes((String)"q2");
        TEST_Q3 = Bytes.toBytes((String)"q3");
        TEST_Q4 = Bytes.toBytes((String)"q4");
        ZERO = Bytes.toBytes((long)0L);
    }
}

