/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax.syntaxtransform;

import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformCopyBase;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;

public class ElementTransformSubst
extends ElementTransformCopyBase {
    private final NodeTransform nodeTransform;

    public ElementTransformSubst(Map<Var, ? extends Node> mapping) {
        this.nodeTransform = new NodeTransformSubst(mapping);
    }

    @Override
    public Element transform(ElementTriplesBlock el) {
        ElementTriplesBlock etb = new ElementTriplesBlock();
        boolean changed = false;
        for (Triple t : el.getPattern()) {
            Triple t2 = this.transform(t);
            changed = changed || t != t2;
            etb.addTriple(t2);
        }
        if (changed) {
            return etb;
        }
        return el;
    }

    @Override
    public Element transform(ElementPathBlock el) {
        ElementPathBlock epb = new ElementPathBlock();
        boolean changed = false;
        for (TriplePath p : el.getPattern()) {
            TriplePath p2 = this.transform(p);
            changed = changed || p != p2;
            epb.addTriplePath(p2);
        }
        if (changed) {
            return epb;
        }
        return el;
    }

    private TriplePath transform(TriplePath path) {
        Node s = path.getSubject();
        Node s1 = this.transform(s);
        Node o = path.getObject();
        Node o1 = this.transform(o);
        if (path.isTriple()) {
            Node p = path.getPredicate();
            Node p1 = this.transform(p);
            if (s == s1 && p == p1 && o == o1) {
                return path;
            }
            return new TriplePath(Triple.create((Node)s1, (Node)p1, (Node)o1));
        }
        if (s == s1 && o == o1) {
            return path;
        }
        return new TriplePath(s1, path.getPath(), o1);
    }

    @Override
    public Triple transform(Triple triple) {
        Node s = triple.getSubject();
        Node s1 = this.transform(s);
        Node p = triple.getPredicate();
        Node p1 = this.transform(p);
        Node o = triple.getObject();
        Node o1 = this.transform(o);
        if (s == s1 && p == p1 && o == o1) {
            return triple;
        }
        return Triple.create((Node)s1, (Node)p1, (Node)o1);
    }

    @Override
    public Quad transform(Quad quad) {
        Node g = quad.getGraph();
        Node g1 = this.transform(g);
        Node s = quad.getSubject();
        Node s1 = this.transform(s);
        Node p = quad.getPredicate();
        Node p1 = this.transform(p);
        Node o = quad.getObject();
        Node o1 = this.transform(o);
        if (g == g1 && s == s1 && p == p1 && o == o1) {
            return quad;
        }
        return Quad.create(g1, s1, p1, o1);
    }

    private Node transform(Node n) {
        return (Node)this.nodeTransform.apply(n);
    }
}

