/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util;

import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.jena.atlas.logging.Log;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JenaXMLInput {
    private static SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private static XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public static XMLReader createXMLReader() throws ParserConfigurationException, SAXException {
        SAXParser saxParser = saxParserFactory.newSAXParser();
        XMLReader xmlreader = saxParser.getXMLReader();
        xmlreader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        xmlreader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        xmlreader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        return xmlreader;
    }

    public static XMLInputFactory initXMLInputFactory(XMLInputFactory xmlInputFactory) {
        String name = xmlInputFactory.getClass().getName();
        boolean isWoodstox = name.startsWith("com.ctc.wstx.stax.");
        boolean isJDK = name.contains("sun.xml.internal");
        boolean isXerces = name.startsWith("org.apache.xerces");
        JenaXMLInput.setXMLInputFactoryProperty(xmlInputFactory, "javax.xml.stream.supportDTD", Boolean.FALSE);
        JenaXMLInput.setXMLInputFactoryProperty(xmlInputFactory, "javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        if (!isWoodstox) {
            JenaXMLInput.setXMLInputFactoryProperty(xmlInputFactory, "http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        return xmlInputFactory;
    }

    private static void setXMLInputFactoryProperty(XMLInputFactory xf, String name, Object value) {
        try {
            xf.setProperty(name, value);
        }
        catch (IllegalArgumentException ex) {
            Log.error(JenaXMLInput.class, (String)("Problem setting StAX property - name: \"" + name + "\" - value: \"" + value + "\" - error: " + ex.getMessage()));
        }
    }

    public static XMLStreamReader newXMLStreamReader(InputStream in) throws XMLStreamException {
        return xmlInputFactory.createXMLStreamReader(in);
    }

    public static XMLStreamReader newXMLStreamReader(Reader in) throws XMLStreamException {
        return xmlInputFactory.createXMLStreamReader(in);
    }

    public static XMLEventReader newXMLEventReader(InputStream in) throws XMLStreamException {
        return xmlInputFactory.createXMLEventReader(in);
    }

    public static XMLEventReader newXMLEventReader(Reader in) throws XMLStreamException {
        return xmlInputFactory.createXMLEventReader(in);
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        return factory;
    }

    static {
        JenaXMLInput.initXMLInputFactory(xmlInputFactory);
    }
}

