/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo.avatars;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import javax.inject.Named;
import org.apache.maven.report.projectinfo.avatars.AvatarsProvider;
import org.codehaus.plexus.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="gravatar")
class GravatarProvider
implements AvatarsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(GravatarProvider.class);
    private static final String AVATAR_SIZE = "s=60";
    private static final String AVATAR_DIRECTORY = "avatars";
    private static final String AVATAR_DEFAULT_FILE_NAME = "00000000000000000000000000000000.jpg";
    private String baseUrl = "https://www.gravatar.com/avatar/";
    private Path outputDirectory;

    GravatarProvider() {
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
    }

    @Override
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory.toPath();
    }

    @Override
    public String getAvatarUrl(String email) {
        return this.getAvatarUrl(email, "blank");
    }

    private String getAvatarUrl(String email, String defaultAvatar) {
        if (email == null || email.isEmpty()) {
            return this.getSpacerGravatarUrl();
        }
        try {
            email = email.trim().toLowerCase(Locale.ROOT);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(email.getBytes());
            byte[] byteData = md.digest();
            StringBuilder sb = new StringBuilder();
            int lowerEightBitsOnly = 255;
            for (byte aByteData : byteData) {
                sb.append(Integer.toString((aByteData & 0xFF) + 256, 16).substring(1));
            }
            return this.baseUrl + sb + ".jpg?d=" + defaultAvatar + "&" + AVATAR_SIZE;
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.warn("Error while getting MD5 hash, use default image: {}", (Object)e.getMessage());
            return this.getSpacerGravatarUrl();
        }
    }

    @Override
    public String getLocalAvatarPath(String email) throws IOException {
        String avatarUrl = this.getAvatarUrl(email, "404");
        try {
            URL url = new URI(avatarUrl).toURL();
            Path name = Paths.get(url.getPath(), new String[0]).getFileName();
            if (AVATAR_DEFAULT_FILE_NAME.equals(name.toString())) {
                this.copyDefault();
            } else {
                this.copyUrl(url, this.outputDirectory.resolve(AVATAR_DIRECTORY).resolve(name));
            }
            return "avatars/" + name;
        }
        catch (IOException | URISyntaxException e) {
            if (e instanceof FileNotFoundException) {
                LOGGER.debug("Error while getting external avatar url for: {}, use default image: {}:{}", new Object[]{email, e.getClass().getName(), e.getMessage()});
            } else {
                LOGGER.warn("Error while getting external avatar url for: {}, use default image: {}:{}", new Object[]{email, e.getClass().getName(), e.getMessage()});
            }
            this.copyDefault();
            return "avatars/00000000000000000000000000000000.jpg";
        }
    }

    private String getSpacerGravatarUrl() {
        return this.baseUrl + AVATAR_DEFAULT_FILE_NAME + "?d=blank&f=y&" + AVATAR_SIZE;
    }

    private void copyUrl(URL url, Path outputPath) throws IOException {
        if (!Files.exists(outputPath, new LinkOption[0])) {
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            try (InputStream in = url.openStream();
                 OutputStream out = Files.newOutputStream(outputPath, new OpenOption[0]);){
                LOGGER.debug("Copying URL {} to {}", (Object)url, (Object)outputPath);
                IOUtil.copy((InputStream)in, (OutputStream)out);
            }
        }
    }

    private void copyDefault() throws IOException {
        Path outputPath = this.outputDirectory.resolve(AVATAR_DIRECTORY).resolve(AVATAR_DEFAULT_FILE_NAME);
        if (!Files.exists(outputPath, new LinkOption[0])) {
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            try (InputStream in = this.getClass().getResourceAsStream("default-avatar.jpg");
                 OutputStream out = Files.newOutputStream(outputPath, new OpenOption[0]);){
                IOUtil.copy((InputStream)in, (OutputStream)out);
            }
        }
    }
}

