/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.exec.MavenExecutor;
import org.apache.maven.shared.release.exec.MavenExecutorException;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractRunGoalsPhase
extends AbstractReleasePhase {
    private final Map<String, MavenExecutor> mavenExecutors;

    protected AbstractRunGoalsPhase(Map<String, MavenExecutor> mavenExecutors) {
        this.mavenExecutors = Objects.requireNonNull(mavenExecutors);
    }

    protected ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, boolean logArguments) throws ReleaseExecutionException {
        return this.execute(releaseDescriptor, releaseEnvironment, new File(releaseDescriptor.getWorkingDirectory()), this.getAdditionalArguments(releaseDescriptor), logArguments);
    }

    protected ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, File workingDirectory, String additionalArguments, boolean logArguments) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        try {
            String goals = this.getGoals(releaseDescriptor);
            if (goals != null && !goals.isEmpty()) {
                String pomFileName;
                File executionRoot;
                MavenExecutor mavenExecutor;
                this.logInfo(result, "Executing goals '" + MessageUtils.buffer().strong((Object)goals) + "'...");
                if (logArguments) {
                    this.logInfo(result, "    with additional arguments: " + (additionalArguments == null ? "(none)" : additionalArguments));
                }
                if ((mavenExecutor = this.mavenExecutors.get(releaseEnvironment.getMavenExecutorId())) == null) {
                    throw new ReleaseExecutionException("Cannot find Maven executor with id: " + releaseEnvironment.getMavenExecutorId());
                }
                if (releaseDescriptor.getPomFileName() != null) {
                    File rootPom = new File(workingDirectory, releaseDescriptor.getPomFileName());
                    executionRoot = rootPom.getParentFile();
                    pomFileName = rootPom.getName();
                } else {
                    executionRoot = workingDirectory;
                    pomFileName = null;
                }
                mavenExecutor.executeGoals(executionRoot, goals, releaseEnvironment, releaseDescriptor.isInteractive(), additionalArguments, pomFileName, result);
            }
        }
        catch (MavenExecutorException e) {
            throw new ReleaseExecutionException(e.getMessage(), (Throwable)e);
        }
        result.setResultCode(0);
        return result;
    }

    protected abstract String getGoals(ReleaseDescriptor var1);

    protected String getAdditionalArguments(ReleaseDescriptor releaseDescriptor) {
        StringBuilder builder = new StringBuilder();
        if (releaseDescriptor.getAdditionalArguments() != null) {
            builder.append(releaseDescriptor.getAdditionalArguments());
        }
        if (!releaseDescriptor.getActivateProfiles().isEmpty()) {
            builder.append(" -P ").append(StringUtils.join(releaseDescriptor.getActivateProfiles().iterator(), (String)","));
        }
        return builder.length() > 0 ? builder.toString().trim() : null;
    }

    protected File determineWorkingDirectory(File checkoutDirectory, String relativePathProjectDirectory) {
        File workingDirectory = checkoutDirectory;
        if (relativePathProjectDirectory != null && !relativePathProjectDirectory.isEmpty()) {
            workingDirectory = new File(checkoutDirectory, relativePathProjectDirectory);
        }
        return workingDirectory;
    }
}

