/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop.config;

import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;

public class RangerChainedPluginConfig
extends RangerPluginConfig {
    public RangerChainedPluginConfig(String serviceType, String serviceName, String appId, RangerPluginConfig sourcePluginConfig) {
        super(serviceType, serviceName, appId, sourcePluginConfig.getClusterName(), sourcePluginConfig.getClusterType(), null);
        this.set(this.getPropertyPrefix() + ".service.name", serviceName);
        this.copyProperty(sourcePluginConfig, ".policy.source.impl");
        this.copyProperty(sourcePluginConfig, ".policy.cache.dir");
        this.copyProperty(sourcePluginConfig, ".policy.rest.url");
        this.copyProperty(sourcePluginConfig, ".policy.rest.ssl.config.file");
        this.copyProperty(sourcePluginConfig, ".policy.pollIntervalMs", 30000);
        this.copyProperty(sourcePluginConfig, ".policy.rest.client.connection.timeoutMs", 120000);
        this.copyProperty(sourcePluginConfig, ".policy.rest.read.timeoutMs", 30000);
        this.copyProperty(sourcePluginConfig, ".policy.rest.supports.policy.deltas");
        this.copyProperty(sourcePluginConfig, ".tag.rest.supports.tag.deltas");
    }

    protected void copyProperty(RangerPluginConfig sourcePluginConfig, String propertySuffix) {
        String value = sourcePluginConfig.get("ranger.plugin." + sourcePluginConfig.getServiceType() + propertySuffix);
        if (value != null) {
            this.set(this.getPropertyPrefix() + propertySuffix, sourcePluginConfig.get("ranger.plugin." + sourcePluginConfig.getServiceType() + propertySuffix));
        }
    }

    protected void copyProperty(RangerPluginConfig sourcePluginConfig, String propertySuffix, int defaultValue) {
        this.setInt(this.getPropertyPrefix() + propertySuffix, sourcePluginConfig.getInt("ranger.plugin" + sourcePluginConfig.getServiceType() + propertySuffix, defaultValue));
    }
}

