/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.conditionevaluator.RangerScriptExecutionContext;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;

public class RangerTagsAllPresentConditionEvaluator
extends RangerAbstractConditionEvaluator {
    private static final Log LOG = LogFactory.getLog(RangerTagsAllPresentConditionEvaluator.class);
    private final Set<String> policyConditionTags = new HashSet<String>();

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerTagsAllPresentConditionEvaluator.init(" + this.condition + ")"));
        }
        super.init();
        if (this.condition != null) {
            for (String value : this.condition.getValues()) {
                this.policyConditionTags.add(value.trim());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerTagsAllPresentConditionEvaluator.init(" + this.condition + "): Tags[" + this.policyConditionTags + "]"));
        }
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerTagsAllPresentConditionEvaluator.isMatched(" + request + ")"));
        }
        boolean matched = true;
        if (CollectionUtils.isNotEmpty(this.policyConditionTags)) {
            RangerAccessRequest readOnlyRequest = request.getReadOnlyCopy();
            RangerScriptExecutionContext context = new RangerScriptExecutionContext(readOnlyRequest);
            Set<String> resourceTags = context.getAllTagTypes();
            boolean bl = matched = resourceTags != null && resourceTags.containsAll(this.policyConditionTags);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerTagsAllPresentConditionEvaluator.isMatched(" + request + "): " + matched));
        }
        return matched;
    }
}

