/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.contextenricher;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.contextenricher.RangerAbstractContextEnricher;
import org.apache.ranger.plugin.contextenricher.RangerUserStoreRefresher;
import org.apache.ranger.plugin.contextenricher.RangerUserStoreRetriever;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.apache.ranger.plugin.util.DownloadTrigger;
import org.apache.ranger.plugin.util.DownloaderTask;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerUserStore;

public class RangerUserStoreEnricher
extends RangerAbstractContextEnricher {
    private static final Log LOG = LogFactory.getLog(RangerUserStoreEnricher.class);
    private static final Log PERF_SET_USERSTORE_LOG = RangerPerfTracer.getPerfLogger("userstoreenricher.setuserstore");
    private static final String USERSTORE_REFRESHER_POLLINGINTERVAL_OPTION = "userStoreRefresherPollingInterval";
    private static final String USERSTORE_RETRIEVER_CLASSNAME_OPTION = "userStoreRetrieverClassName";
    private RangerUserStoreRefresher userStoreRefresher;
    private RangerUserStoreRetriever userStoreRetriever;
    private RangerUserStore rangerUserStore;
    private boolean disableCacheIfServiceNotFound = true;
    private final BlockingQueue<DownloadTrigger> userStoreDownloadQueue = new LinkedBlockingQueue<DownloadTrigger>();
    private Timer userStoreDownloadTimer;

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerUserStoreEnricher.init()");
        }
        super.init();
        String userStoreRetrieverClassName = this.getOption(USERSTORE_RETRIEVER_CLASSNAME_OPTION);
        long pollingIntervalMs = this.getLongOption(USERSTORE_REFRESHER_POLLINGINTERVAL_OPTION, 3600000L);
        if (StringUtils.isNotBlank((String)userStoreRetrieverClassName)) {
            try {
                Class<?> userStoreRetriverClass = Class.forName(userStoreRetrieverClassName);
                this.userStoreRetriever = (RangerUserStoreRetriever)userStoreRetriverClass.newInstance();
            }
            catch (ClassNotFoundException exception) {
                LOG.error((Object)("Class " + userStoreRetrieverClassName + " not found, exception=" + exception));
            }
            catch (ClassCastException exception) {
                LOG.error((Object)("Class " + userStoreRetrieverClassName + " is not a type of RangerUserStoreRetriever, exception=" + exception));
            }
            catch (IllegalAccessException exception) {
                LOG.error((Object)("Class " + userStoreRetrieverClassName + " illegally accessed, exception=" + exception));
            }
            catch (InstantiationException exception) {
                LOG.error((Object)("Class " + userStoreRetrieverClassName + " could not be instantiated, exception=" + exception));
            }
            if (this.userStoreRetriever != null) {
                String propertyPrefix = "ranger.plugin." + this.serviceDef.getName();
                this.disableCacheIfServiceNotFound = this.getBooleanConfig(propertyPrefix + ".disable.cache.if.servicenotfound", true);
                String cacheDir = this.getConfig(propertyPrefix + ".policy.cache.dir", null);
                String cacheFilename = String.format("%s_%s_userstore.json", this.appId, this.serviceName);
                cacheFilename = cacheFilename.replace(File.separatorChar, '_');
                cacheFilename = cacheFilename.replace(File.pathSeparatorChar, '_');
                String cacheFile = cacheDir == null ? null : cacheDir + File.separator + cacheFilename;
                this.userStoreRetriever.setServiceName(this.serviceName);
                this.userStoreRetriever.setServiceDef(this.serviceDef);
                this.userStoreRetriever.setAppId(this.appId);
                this.userStoreRetriever.setPluginConfig(this.getPluginConfig());
                this.userStoreRetriever.init(this.enricherDef.getEnricherOptions());
                this.userStoreRefresher = new RangerUserStoreRefresher(this.userStoreRetriever, this, null, -1L, this.userStoreDownloadQueue, cacheFile);
                LOG.info((Object)("Created Thread(RangerUserStoreRefresher(" + this.getName() + ")"));
                try {
                    this.userStoreRefresher.populateUserStoreInfo();
                }
                catch (Throwable exception) {
                    LOG.error((Object)"Exception when retrieving userstore information for this enricher", exception);
                }
                this.userStoreRefresher.setDaemon(true);
                this.userStoreRefresher.startRefresher();
                this.userStoreDownloadTimer = new Timer("userStoreDownloadTimer", true);
                try {
                    this.userStoreDownloadTimer.schedule((TimerTask)new DownloaderTask(this.userStoreDownloadQueue), pollingIntervalMs, pollingIntervalMs);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Scheduled userStoreDownloadRefresher to download userstore every " + pollingIntervalMs + " milliseconds"));
                    }
                }
                catch (IllegalStateException exception) {
                    LOG.error((Object)"Error scheduling userStoreDownloadTimer:", (Throwable)exception);
                    LOG.error((Object)("*** UserStore information will NOT be downloaded every " + pollingIntervalMs + " milliseconds ***"));
                    this.userStoreDownloadTimer = null;
                }
            }
        } else {
            LOG.error((Object)"No value specified for userStoreRetrieverClassName in the RangerUserStoreEnricher options");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerUserStoreEnricher.init()");
        }
    }

    @Override
    public void enrich(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerUserStoreEnricher.enrich(" + request + ")"));
        }
        this.enrich(request, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerUserStoreEnricher.enrich(" + request + ")"));
        }
    }

    @Override
    public void enrich(RangerAccessRequest request, Object dataStore) {
        RangerUserStore rangerUserStore;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerUserStoreEnricher.enrich(" + request + ") with dataStore:[" + dataStore + "]"));
        }
        if (dataStore instanceof RangerUserStore) {
            rangerUserStore = (RangerUserStore)dataStore;
        } else {
            rangerUserStore = this.rangerUserStore;
            if (dataStore != null) {
                LOG.warn((Object)("Incorrect type of dataStore :[" + dataStore.getClass().getName() + "], falling back to original enrich"));
            }
        }
        RangerAccessRequestUtil.setRequestUserStoreInContext(request.getContext(), rangerUserStore);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerUserStoreEnricher.enrich(" + request + ") with dataStore:[" + dataStore + "])"));
        }
    }

    public boolean isDisableCacheIfServiceNotFound() {
        return this.disableCacheIfServiceNotFound;
    }

    public RangerUserStore getRangerUserStore() {
        return this.rangerUserStore;
    }

    public void setRangerUserStore(RangerUserStore rangerUserStore) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerUserStoreEnricher.setRangerUserStore(rangerUserStore=" + rangerUserStore + ")"));
        }
        if (rangerUserStore == null) {
            LOG.info((Object)("UserStore information is null for service " + this.serviceName));
            this.rangerUserStore = null;
        } else {
            RangerPerfTracer perf = null;
            if (RangerPerfTracer.isPerfTraceEnabled(PERF_SET_USERSTORE_LOG)) {
                perf = RangerPerfTracer.getPerfTracer(PERF_SET_USERSTORE_LOG, "RangerUserStoreEnricher.setRangerUserStore(newUserStoreVersion=" + rangerUserStore.getUserStoreVersion() + ")");
            }
            this.rangerUserStore = rangerUserStore;
            RangerPerfTracer.logAlways(perf);
        }
        this.setRangerUserStoreInPlugin();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerUserStoreEnricher.setRangerUserStore(rangerUserStore=" + rangerUserStore + ")"));
        }
    }

    @Override
    public boolean preCleanup() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerUserStoreEnricher.preCleanup()");
        }
        super.preCleanup();
        if (this.userStoreDownloadTimer != null) {
            this.userStoreDownloadTimer.cancel();
            this.userStoreDownloadTimer = null;
        }
        if (this.userStoreRefresher != null) {
            this.userStoreRefresher.cleanup();
            this.userStoreRefresher = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerUserStoreEnricher.preCleanup() : result=true");
        }
        return true;
    }

    private void setRangerUserStoreInPlugin() {
        RangerAuthContext authContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> setRangerUserStoreInPlugin()");
        }
        if ((authContext = this.getAuthContext()) != null) {
            authContext.addOrReplaceRequestContextEnricher(this, this.rangerUserStore);
            this.notifyAuthContextChanged();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== setRangerUserStoreInPlugin()");
        }
    }
}

