/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.FutureArrays;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetBuilder;
import org.apache.solr.search.DocSetCollector;
import org.apache.solr.search.DocSetProducer;
import org.apache.solr.search.Filter;
import org.apache.solr.search.SolrIndexSearcher;

abstract class PointSetQuery
extends Query
implements DocSetProducer {
    final PrefixCodedTerms sortedPackedPoints;
    final int sortedPackedPointsHashCode;
    final String field;
    final int bytesPerDim;
    final int numDims;
    int maxDocFreq = Integer.MAX_VALUE;

    public void setMaxDocFreq(int maxDocFreq) {
        this.maxDocFreq = maxDocFreq;
    }

    public static PointSetQuery newSetQuery(String field, final float ... sortedValues) {
        final BytesRef encoded = new BytesRef(new byte[4]);
        return new PointSetQuery(field, 1, 4, new Stream(){
            int upto;

            @Override
            public BytesRef next() {
                if (this.upto == sortedValues.length) {
                    return null;
                }
                FloatPoint.encodeDimension((float)sortedValues[this.upto], (byte[])encoded.bytes, (int)0);
                ++this.upto;
                return encoded;
            }
        }){

            @Override
            protected String toString(byte[] value) {
                assert (value.length == 4);
                return Float.toString(FloatPoint.decodeDimension((byte[])value, (int)0));
            }
        };
    }

    public static PointSetQuery newSetQuery(String field, final long ... sortedValues) {
        final BytesRef encoded = new BytesRef(new byte[8]);
        return new PointSetQuery(field, 1, 8, new Stream(){
            int upto;

            @Override
            public BytesRef next() {
                if (this.upto == sortedValues.length) {
                    return null;
                }
                LongPoint.encodeDimension((long)sortedValues[this.upto], (byte[])encoded.bytes, (int)0);
                ++this.upto;
                return encoded;
            }
        }){

            @Override
            protected String toString(byte[] value) {
                assert (value.length == 8);
                return Long.toString(LongPoint.decodeDimension((byte[])value, (int)0));
            }
        };
    }

    public static PointSetQuery newSetQuery(String field, final int ... sortedValues) {
        final BytesRef encoded = new BytesRef(new byte[4]);
        return new PointSetQuery(field, 1, 4, new Stream(){
            int upto;

            @Override
            public BytesRef next() {
                if (this.upto == sortedValues.length) {
                    return null;
                }
                IntPoint.encodeDimension((int)sortedValues[this.upto], (byte[])encoded.bytes, (int)0);
                ++this.upto;
                return encoded;
            }
        }){

            @Override
            protected String toString(byte[] value) {
                assert (value.length == 4);
                return Integer.toString(IntPoint.decodeDimension((byte[])value, (int)0));
            }
        };
    }

    public static PointSetQuery newSetQuery(String field, double ... values) {
        final double[] sortedValues = (double[])values.clone();
        Arrays.sort(sortedValues);
        final BytesRef encoded = new BytesRef(new byte[8]);
        return new PointSetQuery(field, 1, 8, new Stream(){
            int upto;

            @Override
            public BytesRef next() {
                if (this.upto == sortedValues.length) {
                    return null;
                }
                DoublePoint.encodeDimension((double)sortedValues[this.upto], (byte[])encoded.bytes, (int)0);
                ++this.upto;
                return encoded;
            }
        }){

            @Override
            protected String toString(byte[] value) {
                assert (value.length == 8);
                return Double.toString(DoublePoint.decodeDimension((byte[])value, (int)0));
            }
        };
    }

    public PointSetQuery(String field, int numDims, int bytesPerDim, Stream packedPoints) {
        BytesRef current;
        this.field = field;
        this.bytesPerDim = bytesPerDim;
        this.numDims = numDims;
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        BytesRefBuilder previous = null;
        while ((current = packedPoints.next()) != null) {
            if (current.length != numDims * bytesPerDim) {
                throw new IllegalArgumentException("packed point length should be " + numDims * bytesPerDim + " but got " + current.length + "; field=\"" + field + "\" numDims=" + numDims + " bytesPerDim=" + bytesPerDim);
            }
            if (previous == null) {
                previous = new BytesRefBuilder();
            } else {
                int cmp = previous.get().compareTo(current);
                if (cmp == 0) continue;
                if (cmp > 0) {
                    throw new IllegalArgumentException("values are out of order: saw " + previous + " before " + current);
                }
            }
            builder.add(field, current);
            previous.copyBytes(current);
        }
        this.sortedPackedPoints = builder.finish();
        this.sortedPackedPointsHashCode = this.sortedPackedPoints.hashCode();
    }

    private FixedBitSet getLiveDocs(IndexSearcher searcher) throws IOException {
        if (!searcher.getIndexReader().hasDeletions()) {
            return null;
        }
        if (searcher instanceof SolrIndexSearcher) {
            return ((SolrIndexSearcher)searcher).getLiveDocSet().getBits();
        }
        DocSetCollector docSetCollector = new DocSetCollector(0, searcher.getIndexReader().maxDoc());
        searcher.search((Query)new MatchAllDocsQuery(), (Collector)docSetCollector);
        return ((BitDocSet)docSetCollector.getDocSet()).getBits();
    }

    @Override
    public DocSet createDocSet(SolrIndexSearcher searcher) throws IOException {
        return this.getDocSet(searcher);
    }

    public DocSet getDocSet(IndexSearcher searcher) throws IOException {
        IndexReaderContext top = ReaderUtil.getTopLevelContext((IndexReaderContext)searcher.getTopReaderContext());
        List segs = top.leaves();
        DocSetBuilder builder = new DocSetBuilder(top.reader().maxDoc(), Math.min(64, (top.reader().maxDoc() >>> 10) + 4));
        PointValues[] segPoints = new PointValues[segs.size()];
        for (int i = 0; i < segPoints.length; ++i) {
            segPoints[i] = ((LeafReaderContext)segs.get(i)).reader().getPointValues(this.field);
        }
        int maxCollect = Math.min(this.maxDocFreq, top.reader().maxDoc());
        CutoffPointVisitor visitor = new CutoffPointVisitor(maxCollect);
        PrefixCodedTerms.TermIterator iterator = this.sortedPackedPoints.iterator();
        BytesRef point = iterator.next();
        while (point != null) {
            block5: {
                visitor.setPoint(point);
                for (int i = 0; i < segs.size(); ++i) {
                    if (segPoints[i] == null) continue;
                    visitor.setBase(((LeafReaderContext)segs.get((int)i)).docBase);
                    segPoints[i].intersect((PointValues.IntersectVisitor)visitor);
                    if (visitor.getCount() <= this.maxDocFreq) {
                        continue;
                    }
                    break block5;
                }
                int collected = visitor.getCount();
                int[] ids = visitor.getGlobalIds();
                for (int i = 0; i < collected; ++i) {
                    builder.add(ids[i]);
                }
            }
            point = iterator.next();
        }
        FixedBitSet liveDocs = this.getLiveDocs(searcher);
        DocSet set = builder.build(liveDocs);
        return set;
    }

    public final Weight createWeight(final IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){
            Filter filter;

            public Scorer scorer(LeafReaderContext context) throws IOException {
                DocIdSet readerSet;
                if (this.filter == null) {
                    DocSet set = PointSetQuery.this.getDocSet(searcher);
                    this.filter = set.getTopFilter();
                }
                if ((readerSet = this.filter.getDocIdSet(context, null)) == null) {
                    return null;
                }
                DocIdSetIterator readerSetIterator = readerSet.iterator();
                if (readerSetIterator == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), readerSetIterator);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    public String getField() {
        return this.field;
    }

    public int getNumDims() {
        return this.numDims;
    }

    public int getBytesPerDim() {
        return this.bytesPerDim;
    }

    public final int hashCode() {
        int hash = this.classHash();
        hash = 31 * hash + this.field.hashCode();
        hash = 31 * hash + this.sortedPackedPointsHashCode;
        hash = 31 * hash + this.numDims;
        hash = 31 * hash + this.bytesPerDim;
        hash = 31 * hash + this.maxDocFreq;
        return hash;
    }

    public final boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((PointSetQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(PointSetQuery other) {
        return other.field.equals(this.field) && other.numDims == this.numDims && other.bytesPerDim == this.bytesPerDim && other.sortedPackedPointsHashCode == this.sortedPackedPointsHashCode && other.sortedPackedPoints.equals((Object)this.sortedPackedPoints) && other.maxDocFreq == this.maxDocFreq;
    }

    public final String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("{");
        PrefixCodedTerms.TermIterator iterator = this.sortedPackedPoints.iterator();
        byte[] pointBytes = new byte[this.numDims * this.bytesPerDim];
        boolean first = true;
        BytesRef point = iterator.next();
        while (point != null) {
            if (!first) {
                sb.append(" ");
            }
            first = false;
            System.arraycopy(point.bytes, point.offset, pointBytes, 0, pointBytes.length);
            sb.append(this.toString(pointBytes));
            point = iterator.next();
        }
        sb.append("}");
        return sb.toString();
    }

    protected abstract String toString(byte[] var1);

    private class CutoffPointVisitor
    implements PointValues.IntersectVisitor {
        int[] ids;
        int base;
        int count;
        private final byte[] pointBytes;

        public CutoffPointVisitor(int sz) {
            this.pointBytes = new byte[PointSetQuery.this.bytesPerDim * PointSetQuery.this.numDims];
            this.ids = new int[sz];
        }

        private void add(int id) {
            if (this.count < this.ids.length) {
                this.ids[this.count] = id + this.base;
            }
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }

        public int[] getGlobalIds() {
            return this.ids;
        }

        public void setPoint(BytesRef point) {
            assert (point.length == this.pointBytes.length);
            System.arraycopy(point.bytes, point.offset, this.pointBytes, 0, this.pointBytes.length);
            this.count = 0;
        }

        public void setBase(int base) {
            this.base = base;
        }

        public void grow(int count) {
        }

        public void visit(int docID) {
            this.add(docID);
        }

        public void visit(int docID, byte[] packedValue) {
            if (Arrays.equals(packedValue, this.pointBytes)) {
                this.add(docID);
            }
        }

        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            boolean crosses = false;
            for (int dim = 0; dim < PointSetQuery.this.numDims; ++dim) {
                int offset = dim * PointSetQuery.this.bytesPerDim;
                int cmpMin = FutureArrays.compareUnsigned((byte[])minPackedValue, (int)offset, (int)(offset + PointSetQuery.this.bytesPerDim), (byte[])this.pointBytes, (int)offset, (int)(offset + PointSetQuery.this.bytesPerDim));
                if (cmpMin > 0) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                int cmpMax = FutureArrays.compareUnsigned((byte[])maxPackedValue, (int)offset, (int)(offset + PointSetQuery.this.bytesPerDim), (byte[])this.pointBytes, (int)offset, (int)(offset + PointSetQuery.this.bytesPerDim));
                if (cmpMax < 0) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                if (cmpMin == 0 && cmpMax == 0) continue;
                crosses = true;
            }
            if (crosses) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
    }

    public static abstract class Stream
    implements BytesRefIterator {
        public abstract BytesRef next();
    }
}

