/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.facet.FacetContext;

public abstract class SlotAcc
implements Closeable {
    String key;
    protected final FacetContext fcontext;
    protected LeafReaderContext currentReaderContext;
    protected int currentDocBase;

    public SlotAcc(FacetContext fcontext) {
        this.fcontext = fcontext;
    }

    public void setNextReader(LeafReaderContext readerContext) throws IOException {
        LeafReaderContext lastReaderContext = this.currentReaderContext;
        this.currentReaderContext = readerContext;
        this.currentDocBase = this.currentReaderContext.docBase;
        if (lastReaderContext == null || lastReaderContext.ord >= this.currentReaderContext.ord) {
            this.resetIterators();
        }
    }

    @Deprecated
    public void collect(int doc, int slot) throws IOException {
        throw new UnsupportedOperationException("SlotAcc implementations must implement 'collect(int,int,IntFunction<SlotContext>)' or the (deprecated)'collect(int,int)'");
    }

    @Deprecated
    public void collect(int doc, int slot, IntFunction<SlotContext> slotContext) throws IOException {
        this.collect(doc, slot);
    }

    public int collect(DocSet docs, int slot, IntFunction<SlotContext> slotContext) throws IOException {
        int count = 0;
        SolrIndexSearcher searcher = this.fcontext.searcher;
        List leaves = searcher.getIndexReader().leaves();
        Iterator ctxIt = leaves.iterator();
        LeafReaderContext ctx = null;
        int segBase = 0;
        int adjustedMax = 0;
        DocIterator docsIt = docs.iterator();
        while (docsIt.hasNext()) {
            int doc = docsIt.nextDoc();
            if (doc >= adjustedMax) {
                int segMax;
                do {
                    if ((ctx = (LeafReaderContext)ctxIt.next()) != null) continue;
                    throw new RuntimeException("INTERNAL FACET ERROR");
                } while (doc >= (adjustedMax = (segBase = ctx.docBase) + (segMax = ctx.reader().maxDoc())));
                assert (doc >= ctx.docBase);
                this.setNextReader(ctx);
            }
            ++count;
            this.collect(doc - segBase, slot, slotContext);
        }
        return count;
    }

    public abstract int compare(int var1, int var2);

    public abstract Object getValue(int var1) throws IOException;

    public void setValues(SimpleOrderedMap<Object> bucket, int slotNum) throws IOException {
        if (this.key == null) {
            return;
        }
        Object val = this.getValue(slotNum);
        if (val != null) {
            bucket.add(this.key, val);
        }
    }

    public abstract void reset() throws IOException;

    protected void resetIterators() throws IOException {
    }

    public abstract void resize(Resizer var1);

    @Override
    public void close() throws IOException {
    }

    public static final class SlotContext {
        private final Query slotQuery;

        public SlotContext(Query slotQuery) {
            this.slotQuery = slotQuery;
        }

        public Query getSlotQuery() {
            return this.slotQuery;
        }
    }

    public static abstract class Resizer {
        public abstract int getNewSize();

        public abstract int getNewSlot(int var1);

        public double[] resize(double[] old, double defaultValue) {
            double[] values = new double[this.getNewSize()];
            if (defaultValue != 0.0) {
                Arrays.fill(values, 0, values.length, defaultValue);
            }
            for (int i = 0; i < old.length; ++i) {
                int newSlot;
                double val = old[i];
                if (val == defaultValue || (newSlot = this.getNewSlot(i)) < 0) continue;
                values[newSlot] = val;
            }
            return values;
        }

        public int[] resize(int[] old, int defaultValue) {
            int[] values = new int[this.getNewSize()];
            if (defaultValue != 0) {
                Arrays.fill(values, 0, values.length, defaultValue);
            }
            for (int i = 0; i < old.length; ++i) {
                int newSlot;
                int val = old[i];
                if (val == defaultValue || (newSlot = this.getNewSlot(i)) < 0) continue;
                values[newSlot] = val;
            }
            return values;
        }

        public long[] resize(long[] old, long defaultValue) {
            long[] values = new long[this.getNewSize()];
            if (defaultValue != 0L) {
                Arrays.fill(values, 0, values.length, defaultValue);
            }
            for (int i = 0; i < old.length; ++i) {
                int newSlot;
                long val = old[i];
                if (val == defaultValue || (newSlot = this.getNewSlot(i)) < 0) continue;
                values[newSlot] = val;
            }
            return values;
        }

        public FixedBitSet resize(FixedBitSet old) {
            FixedBitSet values = new FixedBitSet(this.getNewSize());
            int oldSize = old.length();
            int oldSlot = 0;
            while ((oldSlot = values.nextSetBit(oldSlot)) != Integer.MAX_VALUE) {
                int newSlot = this.getNewSlot(oldSlot);
                values.set(newSlot);
                if (++oldSlot < oldSize) continue;
                break;
            }
            return values;
        }

        public <T> T[] resize(T[] old, T defaultValue) {
            Object[] values = (Object[])Array.newInstance(old.getClass().getComponentType(), this.getNewSize());
            if (defaultValue != null) {
                Arrays.fill(values, 0, values.length, defaultValue);
            }
            for (int i = 0; i < old.length; ++i) {
                int newSlot;
                T val = old[i];
                if (val == defaultValue || (newSlot = this.getNewSlot(i)) < 0) continue;
                values[newSlot] = val;
            }
            return values;
        }
    }
}

