/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.SpecVersionDetector;
import com.networknt.schema.resource.MapSchemaMapper;
import com.networknt.schema.resource.SchemaMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.cyclonedx.Version;
import org.xml.sax.SAXException;

public abstract class CycloneDxSchema {
    public static final String NS_BOM_10 = "http://cyclonedx.org/schema/bom/1.0";
    public static final String NS_BOM_11 = "http://cyclonedx.org/schema/bom/1.1";
    public static final String NS_BOM_12 = "http://cyclonedx.org/schema/bom/1.2";
    public static final String NS_BOM_13 = "http://cyclonedx.org/schema/bom/1.3";
    public static final String NS_BOM_14 = "http://cyclonedx.org/schema/bom/1.4";
    public static final String NS_BOM_15 = "http://cyclonedx.org/schema/bom/1.5";
    public static final String NS_BOM_16 = "http://cyclonedx.org/schema/bom/1.6";
    @Deprecated
    public static final String NS_DEPENDENCY_GRAPH_10 = "http://cyclonedx.org/schema/ext/dependency-graph/1.0";
    public static final String NS_BOM_LATEST = "http://cyclonedx.org/schema/bom/1.6";
    public static final Version VERSION_LATEST = Version.VERSION_16;
    public static final List<Version> ALL_VERSIONS = Arrays.asList(Version.values());

    public JsonSchema getJsonSchema(Version schemaVersion, ObjectMapper mapper) throws IOException {
        InputStream spdxInstream = this.getJsonSchemaAsStream(schemaVersion);
        SchemaValidatorsConfig config = new SchemaValidatorsConfig();
        config.setPreloadJsonSchema(false);
        HashMap<String, String> offlineMappings = new HashMap<String, String>();
        offlineMappings.put("http://cyclonedx.org/schema/spdx.schema.json", this.getClass().getClassLoader().getResource("spdx.schema.json").toExternalForm());
        offlineMappings.put("http://cyclonedx.org/schema/jsf-0.82.schema.json", this.getClass().getClassLoader().getResource("jsf-0.82.schema.json").toExternalForm());
        offlineMappings.put("http://cyclonedx.org/schema/bom-1.2.schema.json", this.getClass().getClassLoader().getResource("bom-1.2-strict.schema.json").toExternalForm());
        offlineMappings.put("http://cyclonedx.org/schema/bom-1.3.schema.json", this.getClass().getClassLoader().getResource("bom-1.3-strict.schema.json").toExternalForm());
        offlineMappings.put("http://cyclonedx.org/schema/bom-1.4.schema.json", this.getClass().getClassLoader().getResource("bom-1.4.schema.json").toExternalForm());
        offlineMappings.put("http://cyclonedx.org/schema/bom-1.5.schema.json", this.getClass().getClassLoader().getResource("bom-1.5.schema.json").toExternalForm());
        offlineMappings.put("http://cyclonedx.org/schema/bom-1.6.schema.json", this.getClass().getClassLoader().getResource("bom-1.6.schema.json").toExternalForm());
        JsonNode schemaNode = mapper.readTree(spdxInstream);
        MapSchemaMapper offlineSchemaMapper = new MapSchemaMapper(offlineMappings);
        JsonSchemaFactory factory = JsonSchemaFactory.builder((JsonSchemaFactory)JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersionDetector.detect((JsonNode)schemaNode))).jsonMapper(mapper).schemaMappers(s -> s.add((SchemaMapper)offlineSchemaMapper)).build();
        return factory.getSchema(schemaNode, config);
    }

    private InputStream getJsonSchemaAsStream(Version schemaVersion) {
        if (Version.VERSION_12 == schemaVersion) {
            return this.getClass().getClassLoader().getResourceAsStream("bom-1.2-strict.schema.json");
        }
        if (Version.VERSION_13 == schemaVersion) {
            return this.getClass().getClassLoader().getResourceAsStream("bom-1.3-strict.schema.json");
        }
        if (Version.VERSION_14 == schemaVersion) {
            return this.getClass().getClassLoader().getResourceAsStream("bom-1.4.schema.json");
        }
        if (Version.VERSION_15 == schemaVersion) {
            return this.getClass().getClassLoader().getResourceAsStream("bom-1.5.schema.json");
        }
        return this.getClass().getClassLoader().getResourceAsStream("bom-1.6.schema.json");
    }

    public Schema getXmlSchema(Version schemaVersion) throws SAXException {
        if (Version.VERSION_10 == schemaVersion) {
            return this.getXmlSchema10();
        }
        if (Version.VERSION_11 == schemaVersion) {
            return this.getXmlSchema11();
        }
        if (Version.VERSION_12 == schemaVersion) {
            return this.getXmlSchema12();
        }
        if (Version.VERSION_13 == schemaVersion) {
            return this.getXmlSchema13();
        }
        if (Version.VERSION_14 == schemaVersion) {
            return this.getXmlSchema14();
        }
        if (Version.VERSION_15 == schemaVersion) {
            return this.getXmlSchema15();
        }
        return this.getXmlSchema16();
    }

    private Schema getXmlSchema10() throws SAXException {
        return this.getXmlSchema(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"), this.getClass().getClassLoader().getResourceAsStream("bom-1.0.xsd"));
    }

    private Schema getXmlSchema11() throws SAXException {
        return this.getXmlSchema(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"), this.getClass().getClassLoader().getResourceAsStream("bom-1.1.xsd"));
    }

    private Schema getXmlSchema12() throws SAXException {
        return this.getXmlSchema(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"), this.getClass().getClassLoader().getResourceAsStream("bom-1.2.xsd"));
    }

    private Schema getXmlSchema13() throws SAXException {
        return this.getXmlSchema(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"), this.getClass().getClassLoader().getResourceAsStream("bom-1.3.xsd"));
    }

    private Schema getXmlSchema14() throws SAXException {
        return this.getXmlSchema(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"), this.getClass().getClassLoader().getResourceAsStream("bom-1.4.xsd"));
    }

    private Schema getXmlSchema15() throws SAXException {
        return this.getXmlSchema(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"), this.getClass().getClassLoader().getResourceAsStream("bom-1.5.xsd"));
    }

    private Schema getXmlSchema16() throws SAXException {
        return this.getXmlSchema(this.getClass().getClassLoader().getResourceAsStream("spdx.xsd"), this.getClass().getClassLoader().getResourceAsStream("bom-1.6.xsd"));
    }

    public Schema getXmlSchema(InputStream ... inputStreams) throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] schemaFiles = new Source[inputStreams.length];
        for (int i = 0; i < inputStreams.length; ++i) {
            schemaFiles[i] = new StreamSource(inputStreams[i]);
        }
        return schemaFactory.newSchema(schemaFiles);
    }
}

