/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.cyclonedx.model.license.Expression;

public class ExpressionDeserializer
extends JsonDeserializer<Expression> {
    public Expression deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (node.has("expression") && node.get("expression").isObject()) {
            node = node.get("expression");
        }
        if (node.isTextual()) {
            return new Expression(node.asText());
        }
        return this.parseExpressionNode(node);
    }

    private Expression parseExpressionNode(JsonNode node) {
        JsonNode textNode;
        Expression expression = new Expression();
        if (node.has("bom-ref")) {
            expression.setBomRef(node.get("bom-ref").asText());
        }
        if (node.has("acknowledgement")) {
            expression.setAcknowledgement(node.get("acknowledgement").asText());
        }
        if ((textNode = node.get("expression")) != null) {
            expression.setValue(textNode.asText());
        } else if (node.has("")) {
            expression.setValue(node.get("").asText());
        }
        return expression;
    }
}

