/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.util.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Lifecycles;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.OrganizationalContact;
import org.cyclonedx.model.OrganizationalEntity;
import org.cyclonedx.model.Property;
import org.cyclonedx.model.Service;
import org.cyclonedx.model.Tool;
import org.cyclonedx.model.metadata.ToolInformation;
import org.cyclonedx.util.deserializer.LicenseDeserializer;
import org.cyclonedx.util.deserializer.LifecycleDeserializer;
import org.cyclonedx.util.deserializer.PropertiesDeserializer;

public class MetadataDeserializer
extends JsonDeserializer<Metadata> {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
    private final LifecycleDeserializer lifecycleDeserializer = new LifecycleDeserializer();
    private final PropertiesDeserializer propertiesDeserializer = new PropertiesDeserializer();
    private final LicenseDeserializer licenseDeserializer = new LicenseDeserializer();

    public Metadata deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        Metadata metadata = new Metadata();
        ObjectMapper mapper = this.getMapper(jsonParser);
        if (node.has("authors")) {
            JsonNode authorsNode = node.get("authors");
            List<OrganizationalContact> authors = MetadataDeserializer.deserializeOrganizationalContact(authorsNode, mapper);
            metadata.setAuthors(authors);
        }
        if (node.has("component")) {
            Component component = (Component)mapper.convertValue((Object)node.get("component"), Component.class);
            metadata.setComponent(component);
        }
        if (node.has("manufacture")) {
            OrganizationalEntity manufacture = (OrganizationalEntity)mapper.convertValue((Object)node.get("manufacture"), OrganizationalEntity.class);
            metadata.setManufacture(manufacture);
        }
        if (node.has("manufacturer")) {
            OrganizationalEntity manufacturer = (OrganizationalEntity)mapper.convertValue((Object)node.get("manufacturer"), OrganizationalEntity.class);
            metadata.setManufacturer(manufacturer);
        }
        if (node.has("lifecycles")) {
            JsonParser lifecycleParser = node.get("lifecycles").traverse(jsonParser.getCodec());
            lifecycleParser.nextToken();
            Lifecycles lifecycles = this.lifecycleDeserializer.deserialize(lifecycleParser, ctxt);
            metadata.setLifecycles(lifecycles);
        }
        if (node.has("supplier")) {
            OrganizationalEntity supplier = (OrganizationalEntity)mapper.convertValue((Object)node.get("supplier"), OrganizationalEntity.class);
            metadata.setSupplier(supplier);
        }
        if (node.has("licenses")) {
            JsonParser licensesParser = node.get("licenses").traverse(jsonParser.getCodec());
            licensesParser.nextToken();
            LicenseChoice licenses = this.licenseDeserializer.deserialize(licensesParser, ctxt);
            metadata.setLicenses(licenses);
        }
        if (node.has("timestamp")) {
            this.setTimestamp(node, metadata);
        }
        if (node.has("properties")) {
            JsonParser propertiesParser = node.get("properties").traverse(jsonParser.getCodec());
            propertiesParser.nextToken();
            Object properties = this.propertiesDeserializer.deserialize(propertiesParser, ctxt);
            metadata.setProperties((List<Property>)properties);
        }
        if (node.has("tools")) {
            this.parseTools(node.get("tools"), metadata, mapper);
        }
        return metadata;
    }

    private void parseComponents(JsonNode componentsNode, ToolInformation toolInformation, ObjectMapper mapper) {
        if (componentsNode != null) {
            if (componentsNode.isArray()) {
                List components = (List)mapper.convertValue((Object)componentsNode, (TypeReference)new TypeReference<List<Component>>(){});
                toolInformation.setComponents(components);
            } else if (componentsNode.isObject()) {
                Component component = (Component)mapper.convertValue((Object)componentsNode, Component.class);
                toolInformation.setComponents(Collections.singletonList(component));
            }
        }
    }

    private void parseServices(JsonNode servicesNode, ToolInformation toolInformation, ObjectMapper mapper) {
        if (servicesNode != null) {
            if (servicesNode.isArray()) {
                List services = (List)mapper.convertValue((Object)servicesNode, (TypeReference)new TypeReference<List<Service>>(){});
                toolInformation.setServices(services);
            } else if (servicesNode.isObject()) {
                Service service = (Service)mapper.convertValue((Object)servicesNode, Service.class);
                toolInformation.setServices(Collections.singletonList(service));
            }
        }
    }

    static List<OrganizationalContact> deserializeOrganizationalContact(JsonNode node, ObjectMapper mapper) {
        ArrayList<OrganizationalContact> organizationalContactList = new ArrayList<OrganizationalContact>();
        if (node.has("author")) {
            node = node.get("author");
        }
        if (node.isArray()) {
            for (JsonNode authorNode : node) {
                MetadataDeserializer.deserializeAuthor(authorNode, mapper, organizationalContactList);
            }
        } else if (node.isObject()) {
            MetadataDeserializer.deserializeAuthor(node, mapper, organizationalContactList);
        }
        return organizationalContactList;
    }

    private void parseTools(JsonNode toolsNode, Metadata metadata, ObjectMapper mapper) throws JsonProcessingException {
        if (toolsNode.isArray()) {
            this.setToolInfo(toolsNode, metadata, mapper);
        } else if (toolsNode.has("tool")) {
            JsonNode toolNode = toolsNode.get("tool");
            if (toolNode.isArray()) {
                this.setToolInfo(toolNode, metadata, mapper);
            } else {
                Tool tool = (Tool)mapper.convertValue((Object)toolNode, Tool.class);
                metadata.setTools(Collections.singletonList(tool));
            }
        } else {
            ToolInformation toolInformation = new ToolInformation();
            if (toolsNode.has("components")) {
                this.parseComponents(toolsNode.get("components"), toolInformation, mapper);
            }
            if (toolsNode.has("services")) {
                this.parseServices(toolsNode.get("services"), toolInformation, mapper);
            }
            metadata.setToolChoice(toolInformation);
        }
    }

    private void setToolInfo(JsonNode node, Metadata metadata, ObjectMapper mapper) {
        List tools = (List)mapper.convertValue((Object)node, (TypeReference)new TypeReference<List<Tool>>(){});
        metadata.setTools(tools);
    }

    static void deserializeAuthor(JsonNode node, ObjectMapper mapper, List<OrganizationalContact> organizationalContactList) {
        OrganizationalContact author = (OrganizationalContact)mapper.convertValue((Object)node, OrganizationalContact.class);
        organizationalContactList.add(author);
    }

    private ObjectMapper getMapper(JsonParser jsonParser) {
        if (jsonParser.getCodec() instanceof ObjectMapper) {
            return (ObjectMapper)jsonParser.getCodec();
        }
        return new ObjectMapper();
    }

    private void setTimestamp(JsonNode node, Metadata metadata) {
        JsonNode timestampNode = node.get("timestamp");
        if (timestampNode != null && timestampNode.isTextual()) {
            try {
                Date timestamp = this.dateFormat.parse(timestampNode.textValue());
                metadata.setTimestamp(timestamp);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }
}

