/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.printer.concretesyntaxmodel;

import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.comments.BlockComment;
import org.drools.javaparser.ast.comments.Comment;
import org.drools.javaparser.ast.comments.JavadocComment;
import org.drools.javaparser.ast.comments.LineComment;
import org.drools.javaparser.printer.SourcePrinter;
import org.drools.javaparser.printer.concretesyntaxmodel.CsmElement;

public class CsmComment
implements CsmElement {
    static void process(Comment comment, SourcePrinter printer) {
        String content = printer.normalizeEolInTextBlock(comment.getContent());
        if (comment instanceof BlockComment) {
            printer.print("/*");
            printer.print(content);
            printer.println("*/");
        } else if (comment instanceof JavadocComment) {
            printer.print("/**");
            printer.print(content);
            printer.println("*/");
        } else if (comment instanceof LineComment) {
            printer.print("//");
            printer.print(content);
            printer.println();
        } else {
            throw new UnsupportedOperationException(comment.getClass().getSimpleName());
        }
    }

    @Override
    public void prettyPrint(Node node, SourcePrinter printer) {
        node.getComment().ifPresent(c -> CsmComment.process(c, printer));
    }
}

