/*
 * Decompiled with CFR 0.152.
 */
package org.drools.javaparser.printer.lexicalpreservation;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.drools.javaparser.JavaParser;
import org.drools.javaparser.JavaToken;
import org.drools.javaparser.ParseResult;
import org.drools.javaparser.ParseStart;
import org.drools.javaparser.Provider;
import org.drools.javaparser.Range;
import org.drools.javaparser.TokenTypes;
import org.drools.javaparser.ast.DataKey;
import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.NodeList;
import org.drools.javaparser.ast.body.VariableDeclarator;
import org.drools.javaparser.ast.comments.Comment;
import org.drools.javaparser.ast.comments.JavadocComment;
import org.drools.javaparser.ast.nodeTypes.NodeWithVariables;
import org.drools.javaparser.ast.observer.AstObserver;
import org.drools.javaparser.ast.observer.ObservableProperty;
import org.drools.javaparser.ast.observer.PropagatingAstObserver;
import org.drools.javaparser.ast.type.PrimitiveType;
import org.drools.javaparser.ast.visitor.TreeVisitor;
import org.drools.javaparser.printer.ConcreteSyntaxModel;
import org.drools.javaparser.printer.concretesyntaxmodel.CsmElement;
import org.drools.javaparser.printer.concretesyntaxmodel.CsmMix;
import org.drools.javaparser.printer.concretesyntaxmodel.CsmToken;
import org.drools.javaparser.printer.lexicalpreservation.ChildTextElement;
import org.drools.javaparser.printer.lexicalpreservation.LexicalDifferenceCalculator;
import org.drools.javaparser.printer.lexicalpreservation.NodeText;
import org.drools.javaparser.printer.lexicalpreservation.PhantomNodeLogic;
import org.drools.javaparser.printer.lexicalpreservation.TextElement;
import org.drools.javaparser.printer.lexicalpreservation.TextElementIteratorsFactory;
import org.drools.javaparser.printer.lexicalpreservation.TextElementMatcher;
import org.drools.javaparser.printer.lexicalpreservation.TokenTextElement;
import org.drools.javaparser.utils.Pair;
import org.drools.javaparser.utils.Utils;

public class LexicalPreservingPrinter {
    public static final DataKey<NodeText> NODE_TEXT_DATA = new DataKey<NodeText>(){};

    public static <N extends Node> Pair<ParseResult<N>, LexicalPreservingPrinter> setup(ParseStart<N> parseStart, Provider provider) {
        ParseResult<N> parseResult = new JavaParser().parse(parseStart, provider);
        if (!parseResult.isSuccessful()) {
            throw new RuntimeException("Parsing failed, unable to setup the lexical preservation printer: " + parseResult.getProblems());
        }
        LexicalPreservingPrinter lexicalPreservingPrinter = new LexicalPreservingPrinter((Node)parseResult.getResult().get());
        return new Pair<ParseResult<N>, LexicalPreservingPrinter>(parseResult, lexicalPreservingPrinter);
    }

    public static <N extends Node> N setup(N node) {
        Utils.assertNotNull(node);
        node.getTokenRange().ifPresent(r -> {
            LexicalPreservingPrinter.storeInitialText(node);
            AstObserver observer = LexicalPreservingPrinter.createObserver();
            node.registerForSubtree(observer);
        });
        return node;
    }

    @Deprecated
    public LexicalPreservingPrinter(Node node) {
        LexicalPreservingPrinter.setup(node);
    }

    private static AstObserver createObserver() {
        return new PropagatingAstObserver(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void concretePropertyChange(Node observedNode, ObservableProperty property, Object oldValue, Object newValue) {
                NodeText nodeText;
                if (oldValue != null && oldValue.equals(newValue) || oldValue == null && newValue == null) {
                    return;
                }
                if (property == ObservableProperty.RANGE || property == ObservableProperty.COMMENTED_NODE) {
                    return;
                }
                if (property == ObservableProperty.COMMENT) {
                    if (!observedNode.getParentNode().isPresent()) {
                        throw new IllegalStateException();
                    }
                    nodeText = LexicalPreservingPrinter.getOrCreateNodeText(observedNode.getParentNode().get());
                    if (oldValue == null) {
                        int index = nodeText.findChild(observedNode);
                        nodeText.addChild(index, (Comment)newValue);
                        nodeText.addToken(index + 1, TokenTypes.eolTokenKind(), Utils.EOL);
                    } else if (newValue == null) {
                        if (!(oldValue instanceof JavadocComment)) throw new UnsupportedOperationException();
                        JavadocComment javadocComment = (JavadocComment)oldValue;
                        List matchingTokens = nodeText.getElements().stream().filter(e -> e.isToken(8) && ((TokenTextElement)e).getText().equals("/**" + javadocComment.getContent() + "*/")).map(e -> (TokenTextElement)e).collect(Collectors.toList());
                        if (matchingTokens.size() != 1) {
                            throw new IllegalStateException();
                        }
                        int index = nodeText.findElement((TextElementMatcher)matchingTokens.get(0));
                        nodeText.removeElement(index);
                        if (nodeText.getElements().get(index).isNewline()) {
                            nodeText.removeElement(index);
                        }
                    } else {
                        if (!(oldValue instanceof JavadocComment)) throw new UnsupportedOperationException();
                        JavadocComment oldJavadocComment = (JavadocComment)oldValue;
                        List matchingTokens = nodeText.getElements().stream().filter(e -> e.isToken(8) && ((TokenTextElement)e).getText().equals("/**" + oldJavadocComment.getContent() + "*/")).map(e -> (TokenTextElement)e).collect(Collectors.toList());
                        if (matchingTokens.size() != 1) {
                            throw new IllegalStateException();
                        }
                        JavadocComment newJavadocComment = (JavadocComment)newValue;
                        nodeText.replace((TextElementMatcher)matchingTokens.get(0), new TokenTextElement(8, "/**" + newJavadocComment.getContent() + "*/"));
                    }
                }
                if ((nodeText = LexicalPreservingPrinter.getOrCreateNodeText(observedNode)) == null) {
                    throw new NullPointerException(observedNode.getClass().getSimpleName());
                }
                new LexicalDifferenceCalculator().calculatePropertyChange(nodeText, observedNode, property, oldValue, newValue);
            }

            @Override
            public void concreteListChange(NodeList changedList, AstObserver.ListChangeType type, int index, Node nodeAddedOrRemoved) {
                NodeText nodeText = LexicalPreservingPrinter.getOrCreateNodeText(changedList.getParentNodeForChildren());
                if (type == AstObserver.ListChangeType.REMOVAL) {
                    new LexicalDifferenceCalculator().calculateListRemovalDifference(LexicalPreservingPrinter.findNodeListName(changedList), changedList, index).apply(nodeText, changedList.getParentNodeForChildren());
                } else if (type == AstObserver.ListChangeType.ADDITION) {
                    new LexicalDifferenceCalculator().calculateListAdditionDifference(LexicalPreservingPrinter.findNodeListName(changedList), changedList, index, nodeAddedOrRemoved).apply(nodeText, changedList.getParentNodeForChildren());
                } else {
                    throw new UnsupportedOperationException();
                }
            }

            @Override
            public void concreteListReplacement(NodeList changedList, int index, Node oldValue, Node newValue) {
                NodeText nodeText = LexicalPreservingPrinter.getOrCreateNodeText(changedList.getParentNodeForChildren());
                new LexicalDifferenceCalculator().calculateListReplacementDifference(LexicalPreservingPrinter.findNodeListName(changedList), changedList, index, newValue).apply(nodeText, changedList.getParentNodeForChildren());
            }
        };
    }

    private static void storeInitialText(Node root) {
        final IdentityHashMap tokensByNode = new IdentityHashMap();
        for (JavaToken token : root.getTokenRange().get()) {
            Range tokenRange = token.getRange().orElseThrow(() -> new RuntimeException("Token without range: " + token));
            Node owner = LexicalPreservingPrinter.findNodeForToken(root, tokenRange);
            if (owner == null) {
                throw new RuntimeException("Token without node owning it: " + token);
            }
            if (!tokensByNode.containsKey(owner)) {
                tokensByNode.put(owner, new LinkedList());
            }
            ((List)tokensByNode.get(owner)).add(token);
        }
        new TreeVisitor(){

            @Override
            public void process(Node node) {
                if (!PhantomNodeLogic.isPhantomNode(node)) {
                    LexicalPreservingPrinter.storeInitialTextForOneNode(node, (List)tokensByNode.get(node));
                }
            }
        }.visitBreadthFirst(root);
    }

    private static Node findNodeForToken(Node node, Range tokenRange) {
        if (PhantomNodeLogic.isPhantomNode(node)) {
            return null;
        }
        if (node.getRange().get().contains(tokenRange)) {
            for (Node child : node.getChildNodes()) {
                Node found = LexicalPreservingPrinter.findNodeForToken(child, tokenRange);
                if (found == null) continue;
                return found;
            }
            return node;
        }
        return null;
    }

    private static void storeInitialTextForOneNode(Node node, List<JavaToken> nodeTokens) {
        if (nodeTokens == null) {
            nodeTokens = Collections.emptyList();
        }
        LinkedList<Pair> elements = new LinkedList<Pair>();
        for (Node child : node.getChildNodes()) {
            if (PhantomNodeLogic.isPhantomNode(child)) continue;
            if (!child.getRange().isPresent()) {
                throw new RuntimeException("Range not present on node " + child);
            }
            elements.add(new Pair<Range, ChildTextElement>(child.getRange().get(), new ChildTextElement(child)));
        }
        for (JavaToken token : nodeTokens) {
            elements.add(new Pair<Range, TokenTextElement>(token.getRange().get(), new TokenTextElement(token)));
        }
        elements.sort(Comparator.comparing(e -> ((Range)e.a).begin));
        node.setData(NODE_TEXT_DATA, new NodeText(elements.stream().map(p -> (TextElement)p.b).collect(Collectors.toList())));
    }

    private static Iterator<TokenTextElement> tokensPreceeding(Node node) {
        if (!node.getParentNode().isPresent()) {
            return new TextElementIteratorsFactory.EmptyIterator<TokenTextElement>();
        }
        NodeText parentNodeText = LexicalPreservingPrinter.getOrCreateNodeText(node.getParentNode().get());
        int index = parentNodeText.tryToFindChild(node);
        if (index == -1) {
            if (node.getParentNode().get() instanceof VariableDeclarator) {
                return LexicalPreservingPrinter.tokensPreceeding(node.getParentNode().get());
            }
            throw new IllegalArgumentException(String.format("I could not find child '%s' in parent '%s'. parentNodeText: %s", node, node.getParentNode().get(), parentNodeText));
        }
        return new TextElementIteratorsFactory.CascadingIterator<TokenTextElement>(TextElementIteratorsFactory.partialReverseIterator(parentNodeText, index - 1), () -> LexicalPreservingPrinter.tokensPreceeding(node.getParentNode().get()));
    }

    public static String print(Node node) {
        StringWriter writer = new StringWriter();
        try {
            LexicalPreservingPrinter.print(node, writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException on a StringWriter", e);
        }
        return writer.toString();
    }

    public static void print(Node node, Writer writer) throws IOException {
        if (!node.containsData(NODE_TEXT_DATA)) {
            LexicalPreservingPrinter.getOrCreateNodeText(node);
        }
        NodeText text = node.getData(NODE_TEXT_DATA);
        writer.append(text.expand());
    }

    private static NodeText prettyPrintingTextNode(Node node, NodeText nodeText) {
        if (node instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)node;
            switch (primitiveType.getType()) {
                case BOOLEAN: {
                    nodeText.addToken(13, node.toString());
                    break;
                }
                case CHAR: {
                    nodeText.addToken(18, node.toString());
                    break;
                }
                case BYTE: {
                    nodeText.addToken(15, node.toString());
                    break;
                }
                case SHORT: {
                    nodeText.addToken(49, node.toString());
                    break;
                }
                case INT: {
                    nodeText.addToken(38, node.toString());
                    break;
                }
                case LONG: {
                    nodeText.addToken(40, node.toString());
                    break;
                }
                case FLOAT: {
                    nodeText.addToken(31, node.toString());
                    break;
                }
                case DOUBLE: {
                    nodeText.addToken(24, node.toString());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return nodeText;
        }
        if (node instanceof JavadocComment) {
            nodeText.addToken(8, "/**" + ((JavadocComment)node).getContent() + "*/");
            return nodeText;
        }
        return LexicalPreservingPrinter.interpret(node, ConcreteSyntaxModel.forClass(node.getClass()), nodeText);
    }

    private static NodeText interpret(Node node, CsmElement csm, NodeText nodeText) {
        LexicalDifferenceCalculator.CalculatedSyntaxModel calculatedSyntaxModel = new LexicalDifferenceCalculator().calculatedSyntaxModelForNode(csm, node);
        List<TokenTextElement> indentation = LexicalPreservingPrinter.findIndentation(node);
        boolean pendingIndentation = false;
        for (CsmElement element : calculatedSyntaxModel.elements) {
            block10: {
                block11: {
                    if (!pendingIndentation) break block10;
                    if (!(element instanceof CsmToken)) break block11;
                    if (((CsmToken)element).isNewLine()) break block10;
                }
                indentation.forEach(nodeText::addElement);
            }
            pendingIndentation = false;
            if (element instanceof LexicalDifferenceCalculator.CsmChild) {
                nodeText.addChild(((LexicalDifferenceCalculator.CsmChild)element).getChild());
                continue;
            }
            if (element instanceof CsmToken) {
                CsmToken csmToken = (CsmToken)element;
                nodeText.addToken(csmToken.getTokenType(), csmToken.getContent(node));
                if (!csmToken.isNewLine()) continue;
                pendingIndentation = true;
                continue;
            }
            if (element instanceof CsmMix) {
                CsmMix csmMix = (CsmMix)element;
                csmMix.getElements().forEach(e -> LexicalPreservingPrinter.interpret(node, e, nodeText));
                continue;
            }
            throw new UnsupportedOperationException(element.getClass().getSimpleName());
        }
        if (node instanceof VariableDeclarator) {
            VariableDeclarator variableDeclarator = (VariableDeclarator)node;
            if (!variableDeclarator.getParentNode().isPresent()) {
                throw new RuntimeException("VariableDeclarator without parent: I cannot handle the array levels");
            }
            NodeWithVariables nodeWithVariables = (NodeWithVariables)((Object)variableDeclarator.getParentNode().get());
            int extraArrayLevels = variableDeclarator.getType().getArrayLevel() - nodeWithVariables.getMaximumCommonType().getArrayLevel();
            for (int i = 0; i < extraArrayLevels; ++i) {
                nodeText.addElement(new TokenTextElement(101));
                nodeText.addElement(new TokenTextElement(102));
            }
        }
        return nodeText;
    }

    static NodeText getOrCreateNodeText(Node node) {
        if (!node.containsData(NODE_TEXT_DATA)) {
            NodeText nodeText = new NodeText();
            node.setData(NODE_TEXT_DATA, nodeText);
            LexicalPreservingPrinter.prettyPrintingTextNode(node, nodeText);
        }
        return node.getData(NODE_TEXT_DATA);
    }

    static List<TokenTextElement> findIndentation(Node node) {
        TokenTextElement tte;
        LinkedList<TokenTextElement> followingNewlines = new LinkedList<TokenTextElement>();
        Iterator<TokenTextElement> it = LexicalPreservingPrinter.tokensPreceeding(node);
        while (it.hasNext() && (tte = it.next()).getTokenKind() != 5 && !tte.isNewline()) {
            followingNewlines.add(tte);
        }
        Collections.reverse(followingNewlines);
        for (int i = 0; i < followingNewlines.size(); ++i) {
            if (((TokenTextElement)followingNewlines.get(i)).isSpaceOrTab()) continue;
            return followingNewlines.subList(0, i);
        }
        return followingNewlines;
    }

    private static boolean isReturningOptionalNodeList(Method m) {
        if (!m.getReturnType().getCanonicalName().equals(Optional.class.getCanonicalName())) {
            return false;
        }
        if (!(m.getGenericReturnType() instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)m.getGenericReturnType();
        Type optionalArgument = parameterizedType.getActualTypeArguments()[0];
        return optionalArgument.getTypeName().startsWith(NodeList.class.getCanonicalName());
    }

    private static ObservableProperty findNodeListName(NodeList nodeList) {
        Node parent = nodeList.getParentNodeForChildren();
        for (Method m : parent.getClass().getMethods()) {
            Object raw;
            if (m.getParameterCount() == 0 && m.getReturnType().getCanonicalName().equals(NodeList.class.getCanonicalName())) {
                try {
                    raw = m.invoke((Object)parent, new Object[0]);
                    if (!(raw instanceof NodeList)) {
                        throw new IllegalStateException("Expected NodeList, found " + raw.getClass().getCanonicalName());
                    }
                    NodeList result = (NodeList)raw;
                    if (result != nodeList) continue;
                    String name = m.getName();
                    if (name.startsWith("get")) {
                        name = name.substring("get".length());
                    }
                    return ObservableProperty.fromCamelCaseName(Utils.decapitalize(name));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (m.getParameterCount() != 0 || !LexicalPreservingPrinter.isReturningOptionalNodeList(m)) continue;
            try {
                raw = (Optional)m.invoke((Object)parent, new Object[0]);
                if (!((Optional)raw).isPresent() || ((Optional)raw).get() != nodeList) continue;
                String name = m.getName();
                if (name.startsWith("get")) {
                    name = name.substring("get".length());
                }
                return ObservableProperty.fromCamelCaseName(Utils.decapitalize(name));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("Cannot find list name of NodeList of size " + nodeList.size());
    }
}

