/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.pmml_4_2.model.tree;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kie.pmml.pmml_4_2.model.tree.ScoreDistributionInfo;

public class TreeNode {
    private String context;
    private String id;
    private String parent;
    private List children;
    private String outcome;
    private int recordCount;
    private Map counts;
    private Map confidence;
    private String defaultChld;

    public TreeNode(String correlationId, String context, String id, String parent, List children, String outcome, int recordCount, Map counts, Map confidence, String defaultChld) {
        this.context = context;
        this.id = id;
        this.parent = parent;
        this.children = children;
        this.outcome = outcome;
        this.recordCount = recordCount;
        this.counts = counts;
        this.confidence = confidence;
        this.defaultChld = defaultChld;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public List getChildren() {
        return this.children;
    }

    public void setChildren(List children) {
        this.children = children;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public Map getCounts() {
        return this.counts;
    }

    public void setCounts(Map counts) {
        this.counts = counts;
    }

    public Map getConfidence() {
        return this.confidence;
    }

    public void setConfidence(Map confidence) {
        this.confidence = confidence;
    }

    public String getDefaultChld() {
        return this.defaultChld;
    }

    public void setDefaultChld(String defaultChld) {
        this.defaultChld = defaultChld;
    }

    public ScoreDistributionInfo getWeightedConfidenceWinner(List<TreeNode> childNodes) {
        ScoreDistributions distributedScores = new ScoreDistributions(childNodes);
        return distributedScores.getWeightedDistribution();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TreeNode other = (TreeNode)obj;
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        Object value;
        Object key;
        StringBuilder builder = new StringBuilder("TreeNode( ");
        builder.append("context=").append(this.context).append(", ");
        builder.append("id=").append(this.id).append(", ");
        builder.append("parent=").append(this.parent).append(", ");
        builder.append("children=[");
        Iterator lstIter = this.children.iterator();
        while (lstIter.hasNext()) {
            Object object = lstIter.next();
            builder.append(object.toString());
            if (!lstIter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append("], ");
        builder.append("outcome=").append(this.outcome).append(", ");
        builder.append("recordCount=").append(this.recordCount).append(", ");
        builder.append("counts=[");
        Iterator keyIter = this.counts.keySet().iterator();
        while (keyIter.hasNext()) {
            key = keyIter.next();
            value = this.counts.get(key);
            builder.append("(").append(key.toString()).append("->").append(value != null ? value.toString() : "null").append(")");
            if (!keyIter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append("], ");
        builder.append("confidence=[");
        keyIter = this.confidence.keySet().iterator();
        while (keyIter.hasNext()) {
            key = keyIter.next();
            value = this.confidence.get(key);
            builder.append("(").append(key.toString()).append("->").append(value != null ? value.toString() : "null").append(")");
            if (!keyIter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append("], ");
        builder.append("defaultChild=").append(this.defaultChld).append(" )");
        return builder.toString();
    }

    public static class ScoreDistributions {
        private Map<String, Map<String, ScoreDistributionInfo>> distributions = new HashMap<String, Map<String, ScoreDistributionInfo>>();
        private Map<String, Double> recordsPerNode;
        private Set<String> keyValues;
        private Set<String> nodeIds;
        private Double totalRecords;

        private ScoreDistributions() {
        }

        private void initKeyValues(List<TreeNode> nodes) {
            this.keyValues = new HashSet<String>();
            nodes.forEach(n -> {
                this.keyValues.addAll(((TreeNode)n).confidence.keySet());
                this.keyValues.addAll(((TreeNode)n).counts.keySet());
            });
        }

        private void initFromNodes(List<TreeNode> nodes) {
            this.recordsPerNode = new HashMap<String, Double>();
            this.nodeIds = new HashSet<String>();
            this.totalRecords = 0.0;
            nodes.forEach(n -> {
                double cnt = 0.0;
                for (Double val : ((TreeNode)n).counts.values()) {
                    cnt += val.doubleValue();
                }
                this.totalRecords = this.totalRecords + cnt;
                this.recordsPerNode.put(((TreeNode)n).id, cnt);
                this.nodeIds.add(((TreeNode)n).id);
            });
        }

        public ScoreDistributions(List<TreeNode> nodes) {
            this.initKeyValues(nodes);
            this.initFromNodes(nodes);
            for (TreeNode node : nodes) {
                String nodeKey = node.id;
                HashMap<String, ScoreDistributionInfo> scoresMap = new HashMap<String, ScoreDistributionInfo>();
                for (String key : this.keyValues) {
                    Double conf = (Double)node.confidence.get(key);
                    Double cnt = (Double)node.counts.get(key);
                    ScoreDistributionInfo info = new ScoreDistributionInfo(key, cnt, conf);
                    scoresMap.put(key, info);
                }
                this.distributions.put(nodeKey, scoresMap);
            }
        }

        public ScoreDistributionInfo getWeightedDistribution() {
            Double maxConf = 0.0;
            ScoreDistributionInfo winner = new ScoreDistributionInfo();
            HashMap<String, Double> weightedConfidences = new HashMap<String, Double>();
            HashMap<String, Double> combinedCounts = new HashMap<String, Double>();
            for (String key : this.keyValues) {
                weightedConfidences.put(key, 0.0);
            }
            for (String nodeKey : this.nodeIds) {
                Double recordCount = this.recordsPerNode.get(nodeKey);
                if (recordCount == null || !(recordCount > 0.0)) continue;
                Double weightFactor = recordCount / this.totalRecords;
                Map<String, ScoreDistributionInfo> distMap = this.distributions.get(nodeKey);
                for (String key : this.keyValues) {
                    if (combinedCounts.containsKey(key)) {
                        combinedCounts.put(key, (Double)combinedCounts.get(key) + recordCount);
                    } else {
                        combinedCounts.put(key, recordCount);
                    }
                    ScoreDistributionInfo sdi = distMap.get(key);
                    Double nodeConf = sdi.getConfidence();
                    Double weightedNodeConf = (nodeConf != null ? nodeConf : 0.0) * weightFactor;
                    Double weightedTotalConf = (Double)weightedConfidences.get(key) + weightedNodeConf;
                    weightedConfidences.put(key, weightedTotalConf);
                    if (!(weightedTotalConf > maxConf)) continue;
                    maxConf = weightedTotalConf;
                    winner.setConfidence(weightedTotalConf);
                    winner.setValue(key);
                }
            }
            winner.setCount((Double)combinedCounts.get(winner.getValue()));
            return winner;
        }

        public String toString() {
            return "ScoreDistributions [distributions=" + this.distributions + ", recordsPerNode=" + this.recordsPerNode + ", totalRecords=" + this.totalRecords + "]";
        }
    }
}

