/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.TestingDir;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;

public final class FS {
    private FS() {
    }

    public static void delete(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            FS.deleteFile(path);
        } else if (Files.isDirectory(path, new LinkOption[0])) {
            FS.deleteDirectory(path);
        } else {
            Assert.fail("Not able to delete path, not a file or directory? : " + path.toAbsolutePath());
        }
    }

    public static void delete(File path) {
        FS.delete(path.toPath());
    }

    public static void deleteDirectory(File dir) {
        FS.deleteDirectory(dir.toPath());
    }

    public static void deleteDirectory(Path dir) {
        FS.recursiveDeleteDir(dir);
    }

    public static void deleteFile(File path) {
        Assert.assertTrue("Path must be a file: " + path.getAbsolutePath(), path.isFile());
        Assert.assertTrue("Can only delete content within the /target/tests/ directory: " + path.getAbsolutePath(), FS.isTestingDir(path.getParentFile()));
        Assert.assertTrue("Failed to delete file: " + path.getAbsolutePath(), path.delete());
    }

    public static void deleteFile(Path path) {
        String location = path.toAbsolutePath().toString();
        if (Files.exists(path, new LinkOption[0])) {
            Assert.assertTrue("Path must be a file: " + location, Files.isRegularFile(path, new LinkOption[0]));
            Assert.assertTrue("Can only delete content within the /target/tests/ directory: " + location, FS.isTestingDir(path.getParent()));
            try {
                Assert.assertTrue("Failed to delete file: " + location, Files.deleteIfExists(path));
            }
            catch (IOException e) {
                throw new AssertionError("Unable to delete file: " + location, e);
            }
        }
    }

    public static void deleteDir(Path path) {
        String location = path.toAbsolutePath().toString();
        if (Files.exists(path, new LinkOption[0])) {
            Assert.assertTrue("Path must be a file: " + location, Files.isDirectory(path, new LinkOption[0]));
            Assert.assertTrue("Can only delete content within the /target/tests/ directory: " + location, FS.isTestingDir(path.getParent()));
            try {
                Assert.assertTrue("Failed to delete directory: " + location, Files.deleteIfExists(path));
            }
            catch (IOException e) {
                throw new AssertionError("Unable to delete directory: " + location, e);
            }
        }
    }

    private static void recursiveDeleteDir(Path path) {
        String location = path.toAbsolutePath().toString();
        Assert.assertTrue("Can only delete content within the /target/tests/ directory: " + location, FS.isTestingDir(path));
        try (DirectoryStream<Path> dir = Files.newDirectoryStream(path);){
            for (Path entry : dir) {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    FS.recursiveDeleteDir(entry);
                    continue;
                }
                FS.deleteFile(entry);
            }
        }
        catch (DirectoryIteratorException e) {
            throw new AssertionError("Unable to (recursively) delete path: " + location, e);
        }
        catch (IOException e) {
            throw new AssertionError("Unable to (recursively) delete path: " + location, e);
        }
        FS.deleteDir(path);
    }

    public static void cleanDirectory(File dir) {
        FS.cleanDirectory(dir.toPath());
    }

    public static void cleanDirectory(Path dir) {
        FS.deleteDirectory(dir);
        FS.ensureDirExists(dir);
    }

    public static void ensureEmpty(File dir) {
        FS.ensureEmpty(dir.toPath());
    }

    public static void ensureEmpty(Path dir) {
        if (Files.exists(dir, new LinkOption[0])) {
            FS.cleanDirectory(dir);
        } else {
            FS.ensureDirExists(dir);
        }
    }

    public static void ensureEmpty(TestingDir testingdir) {
        FS.ensureEmpty(testingdir.getPath());
    }

    public static void ensureDeleted(File dir) {
        FS.ensureDeleted(dir.toPath());
    }

    public static void ensureDeleted(Path dir) {
        if (Files.exists(dir, new LinkOption[0])) {
            FS.deleteDirectory(dir);
        }
    }

    public static void ensureDirExists(File dir) {
        if (dir.exists()) {
            Assert.assertTrue("Path exists, but should be a Dir : " + dir.getAbsolutePath(), dir.isDirectory());
        } else {
            Assert.assertTrue("Creating dir: " + dir, dir.mkdirs());
        }
    }

    public static void ensureDirExists(Path dir) {
        if (Files.exists(dir, new LinkOption[0])) {
            Assert.assertTrue("Path exists, but should be a Dir : " + dir.toAbsolutePath(), Files.isDirectory(dir, new LinkOption[0]));
        } else {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
                Assert.assertTrue("Failed to create dir: " + dir, Files.exists(dir, new LinkOption[0]));
            }
            catch (IOException e) {
                throw new AssertionError("Failed to create directory: " + dir, e);
            }
        }
    }

    protected static boolean isTestingDir(File dir) {
        return FS.isTestingDir(dir.toPath());
    }

    protected static boolean isTestingDir(Path dir) {
        try {
            return dir.toRealPath(new LinkOption[0]).startsWith(MavenTestingUtils.getTargetTestingPath());
        }
        catch (IOException e) {
            return dir.toAbsolutePath().startsWith(MavenTestingUtils.getTargetTestingPath());
        }
    }

    public static void touch(File file) throws IOException {
        if (file.exists()) {
            Assert.assertTrue("Updating last modified timestamp", file.setLastModified(System.currentTimeMillis()));
        } else {
            Assert.assertTrue("Creating file: " + file, file.createNewFile());
        }
    }

    public static void touch(Path file) throws IOException {
        if (Files.exists(file, new LinkOption[0])) {
            FileTime timeOrig = Files.getLastModifiedTime(file, new LinkOption[0]);
            Files.setLastModifiedTime(file, FileTime.from(System.currentTimeMillis(), TimeUnit.MILLISECONDS));
            FileTime timeNow = Files.getLastModifiedTime(file, new LinkOption[0]);
            Assert.assertThat("Timestamp updated", timeOrig, CoreMatchers.not(CoreMatchers.equalTo(timeNow)));
        } else {
            Files.createFile(file, new FileAttribute[0]);
            Assert.assertTrue("Created new file?: " + file, Files.exists(file, new LinkOption[0]));
        }
    }
}

