/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import junit.framework.TestCase;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.OS;
import org.eclipse.jetty.toolchain.test.PathAssert;
import org.eclipse.jetty.toolchain.test.StringMangler;
import org.junit.Assert;

public final class MavenTestingUtils {
    private static Path basePath;
    private static Path testResourcesPath;
    private static Path targetPath;

    private MavenTestingUtils() {
    }

    @Deprecated
    public static File getBasedir() {
        return MavenTestingUtils.getBaseDir();
    }

    public static File getBaseDir() {
        return MavenTestingUtils.getBasePath().toFile();
    }

    public static Path getBasePath() {
        if (basePath == null) {
            String cwd = System.getProperty("basedir");
            if (cwd == null) {
                cwd = System.getProperty("user.dir");
            }
            try {
                basePath = new File(cwd).toPath().toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                basePath = new File(cwd).getAbsoluteFile().toPath();
            }
        }
        return basePath;
    }

    public static URI getBaseURI() {
        return MavenTestingUtils.getBasePath().toUri();
    }

    public static File getTargetDir() {
        return MavenTestingUtils.getTargetPath().toFile();
    }

    public static Path getTargetPath() {
        if (targetPath == null) {
            targetPath = MavenTestingUtils.getBasePath().resolve("target");
            PathAssert.assertDirExists("Target Dir", targetPath);
        }
        return targetPath;
    }

    public static File getTargetFile(String path) {
        return MavenTestingUtils.getTargetPath(path).toFile();
    }

    public static Path getTargetPath(String path) {
        Path targetPath = MavenTestingUtils.getTargetPath();
        FileSystem fs = targetPath.getFileSystem();
        return fs.getPath(targetPath.toString(), path);
    }

    public static File getTargetTestingDir() {
        return MavenTestingUtils.getTargetTestingPath().toFile();
    }

    public static Path getTargetTestingPath() {
        return MavenTestingUtils.getTargetPath().resolve("tests");
    }

    public static File getTargetTestingDir(String testname) {
        return MavenTestingUtils.getTargetTestingPath(testname).toFile();
    }

    public static Path getTargetTestingPath(String testname) {
        return MavenTestingUtils.getTargetTestingPath().resolve("test-" + testname);
    }

    public static File getTargetTestingDir(TestCase test) {
        return MavenTestingUtils.getTargetTestingPath(test.getName()).toFile();
    }

    public static Path getTargetTestingPath(TestCase test) {
        return MavenTestingUtils.getTargetTestingPath(test.getName());
    }

    public static URI getTargetURI(String path) {
        return MavenTestingUtils.getTargetPath(path).toUri();
    }

    public static URL getTargetURL(String path) throws MalformedURLException {
        return MavenTestingUtils.getTargetURI(path).toURL();
    }

    public static File getTargetTestingDir(Class<?> testclass, String testmethodname) {
        return MavenTestingUtils.getTargetTestingPath(testclass, testmethodname).toFile();
    }

    public static Path getTargetTestingPath(Class<?> testclass, String testmethodname) {
        String classname = testclass.getName();
        String methodname = testmethodname;
        classname = StringMangler.condensePackageString(classname);
        if (OS.IS_WINDOWS) {
            methodname = StringMangler.maxStringLength(30, methodname);
        }
        Path testdir = MavenTestingUtils.getTargetTestingPath().resolve(methodname);
        FS.ensureDirExists(testdir);
        return testdir;
    }

    @Deprecated
    public static String getTestIDAsPath() {
        TestID id = MavenTestingUtils.getTestID();
        id.classname = StringMangler.condensePackageString(id.classname);
        if (OS.IS_WINDOWS) {
            id.methodname = StringMangler.maxStringLength(30, id.methodname);
        }
        return id.classname + File.separatorChar + id.methodname;
    }

    public static File getProjectFile(String path) {
        return MavenTestingUtils.getProjectFilePath(path).toFile();
    }

    public static Path getProjectFilePath(String path) {
        Path file = MavenTestingUtils.getBasePath().resolve(path);
        PathAssert.assertFileExists("Project File", file);
        return file;
    }

    public static File getProjectDir(String path) {
        return MavenTestingUtils.getProjectDirPath(path).toFile();
    }

    public static Path getProjectDirPath(String path) {
        Path dir = MavenTestingUtils.getBasePath().resolve(path);
        PathAssert.assertDirExists("Project Dir", dir);
        return dir;
    }

    private static TestID getTestID() {
        StackTraceElement[] stacked;
        for (StackTraceElement stack : stacked = new Throwable().getStackTrace()) {
            if (!stack.getClassName().endsWith("Test") || !stack.getMethodName().startsWith("test")) continue;
            TestID testid = new TestID();
            testid.classname = stack.getClassName();
            testid.methodname = stack.getMethodName();
            return testid;
        }
        String LN = System.getProperty("line.separator");
        StringBuilder err = new StringBuilder();
        err.append("Unable to find a TestID from a testcase that ");
        err.append("doesn't follow the standard naming rules.");
        err.append(LN);
        err.append("Test class name must end in \"*Test\".");
        err.append(LN);
        err.append("Test method name must start in \"test*\".");
        err.append(LN);
        err.append("Call to ").append(MavenTestingUtils.class.getSimpleName());
        err.append(".getTestID(), must occur from within stack frame of ");
        err.append("test method, not @Before, @After, @BeforeClass, ");
        err.append("@AfterClass, or Constructors of test case.");
        Assert.fail(err.toString());
        return null;
    }

    public static File getTestResourcesDir() {
        return MavenTestingUtils.getTestResourcesPath().toFile();
    }

    public static Path getTestResourcesPath() {
        if (testResourcesPath == null) {
            testResourcesPath = MavenTestingUtils.getBasePath().resolve("src/test/resources");
            PathAssert.assertDirExists("Test Resources Dir", testResourcesPath);
        }
        return testResourcesPath;
    }

    public static File getTestResourceDir(String name) {
        return MavenTestingUtils.getTestResourcePathDir(name).toFile();
    }

    public static Path getTestResourcePathDir(String name) {
        Path dir = MavenTestingUtils.getTestResourcesPath().resolve(name);
        PathAssert.assertDirExists("Test Resource Dir", dir);
        return dir;
    }

    public static File getTestResourceFile(String name) {
        File file = new File(MavenTestingUtils.getTestResourcesDir(), OS.separators(name));
        PathAssert.assertFileExists("Test Resource File", file);
        return file;
    }

    public static Path getTestResourcePathFile(String name) {
        Path file = MavenTestingUtils.getTestResourcesPath().resolve(name);
        PathAssert.assertFileExists("Test Resource File", file);
        return file;
    }

    public static Path getTestResourcePath(String name) {
        Path path = MavenTestingUtils.getTestResourcesPath().resolve(name);
        PathAssert.assertPathExists("Test Resource Path", path);
        return path;
    }

    private static class TestID {
        public String classname;
        public String methodname;

        private TestID() {
        }
    }
}

