/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.junit.Assert;

public final class PathAssert {
    private PathAssert() {
    }

    public static void assertDirExists(String msg, File path) {
        PathAssert.assertPathExists(msg, path);
        Assert.assertTrue(msg + " path should be a Dir : " + path.getAbsolutePath(), path.isDirectory());
    }

    public static void assertDirExists(String msg, Path path) {
        PathAssert.assertPathExists(msg, path);
        Assert.assertTrue(msg + " path should be a Dir : " + path, Files.isDirectory(path, new LinkOption[0]));
    }

    public static void assertFileExists(String msg, File path) {
        PathAssert.assertPathExists(msg, path);
        Assert.assertTrue(msg + " path should be a File : " + path.getAbsolutePath(), path.isFile());
    }

    public static void assertFileExists(String msg, Path path) {
        PathAssert.assertPathExists(msg, path);
        Assert.assertTrue(msg + " path should be a File : " + path, Files.isRegularFile(path, new LinkOption[0]));
    }

    @Deprecated
    public static void assertExists(String msg, File path) {
        PathAssert.assertPathExists(msg, path);
    }

    @Deprecated
    public static void assertExists(String msg, Path path) {
        PathAssert.assertPathExists(msg, path);
    }

    public static void assertPathExists(String msg, File path) {
        Assert.assertTrue(msg + " path should exist: " + path.getAbsolutePath(), path.exists());
    }

    public static void assertPathExists(String msg, Path path) {
        Assert.assertTrue(msg + " path should exist: " + path, Files.exists(path, new LinkOption[0]));
    }

    @Deprecated
    public static void assertNotExists(String msg, File path) {
        PathAssert.assertNotPathExists(msg, path);
    }

    @Deprecated
    public static void assertNotExists(String msg, Path path) {
        PathAssert.assertNotPathExists(msg, path);
    }

    public static void assertNotPathExists(String msg, File path) {
        Assert.assertFalse(msg + " path should not exist: " + path.getAbsolutePath(), path.exists());
    }

    public static void assertNotPathExists(String msg, Path path) {
        Assert.assertFalse(msg + " path should not exist: " + path, Files.exists(path, new LinkOption[0]));
    }
}

