/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.test;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestingDir
implements TestRule {
    private Path dir;

    @Override
    public Statement apply(final Statement statement, final Description description) {
        return new Statement(){

            @Override
            public void evaluate() throws Throwable {
                TestingDir.this.dir = MavenTestingUtils.getTargetTestingPath(description.getTestClass(), description.getMethodName()).toRealPath(new LinkOption[0]);
                FS.ensureEmpty(TestingDir.this.dir);
                statement.evaluate();
            }
        };
    }

    public Path getPath() {
        if (Files.exists(this.dir, new LinkOption[0])) {
            return this.dir;
        }
        FS.ensureDirExists(this.dir);
        return this.dir;
    }

    @Deprecated
    public File getDir() {
        return this.getPath().toFile();
    }

    @Deprecated
    public File getFile(String name) {
        return this.getPathFile(name).toFile();
    }

    public Path getPathFile(String name) {
        return this.dir.resolve(name);
    }

    public void ensureEmpty() {
        FS.ensureEmpty(this.dir);
    }

    @Deprecated
    public File getEmptyDir() {
        return this.getEmptyPathDir().toFile();
    }

    public Path getEmptyPathDir() {
        FS.ensureEmpty(this.dir);
        return this.dir;
    }
}

