/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.script;

import java.io.File;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.executor.Context;
import org.flywaydb.core.api.executor.MigrationExecutor;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.database.DatabaseExecutionStrategy;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.resource.ResourceName;
import org.flywaydb.core.internal.util.FileUtils;
import org.flywaydb.core.internal.util.OsUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class ScriptMigrationExecutor
implements MigrationExecutor {
    @Generated
    private static final Log LOG = LogFactory.getLog(ScriptMigrationExecutor.class);
    private final LoadableResource resource;
    private final ParsingContext parsingContext;
    private final ResourceName resourceName;
    private final StatementInterceptor statementInterceptor;

    @Override
    public List<Results> execute(Context context) throws SQLException {
        if (this.statementInterceptor != null) {
            this.statementInterceptor.scriptMigration(this.resource);
        } else if (context.getConnection() == null) {
            this.executeOnce(context);
        } else {
            DatabaseType databaseType = DatabaseTypeRegister.getDatabaseTypeForConnection(context.getConnection(), context.getConfiguration());
            DatabaseExecutionStrategy strategy = databaseType.createExecutionStrategy(context.getConnection());
            strategy.execute(() -> {
                this.executeOnce(context);
                return true;
            });
        }
        return List.of();
    }

    private void executeOnce(Context context) {
        try {
            this.runScript(context);
        }
        catch (Exception e) {
            throw new FlywayException("Migration failed !", e);
        }
    }

    private String join(String joiner, List<String> strings) {
        if (strings.size() == 1) {
            return strings.get(0);
        }
        StringBuilder output = new StringBuilder();
        for (String s : strings) {
            output.append(s).append(joiner);
        }
        return output.toString();
    }

    List<String> getProcessArgs(Context context) {
        String resourcePath = this.resource.getAbsolutePathOnDisk();
        String resourceExt = StringUtils.getFileNameAndExtension(resourcePath).getRight();
        ArrayList<String> args = new ArrayList<String>();
        if ("bat".equalsIgnoreCase(resourceExt) || "cmd".equalsIgnoreCase(resourceExt)) {
            args.add("cmd");
            args.add("/c");
            args.add(resourcePath);
        } else if ("ps1".equalsIgnoreCase(resourceExt)) {
            String powershellExecutable = context.getConfiguration().getPowershellExecutable();
            if (StringUtils.hasText(powershellExecutable)) {
                this.validatePowershellExecutable(powershellExecutable);
                args.add(powershellExecutable);
            } else {
                args.add(OsUtils.isWindows() ? "powershell" : "pwsh");
            }
            args.add("-File");
            args.add(resourcePath);
        } else if ("py".equalsIgnoreCase(resourceExt)) {
            args.add("python");
            args.add(resourcePath);
        } else if ("sh".equalsIgnoreCase(resourceExt)) {
            args.add("sh");
            args.add(resourcePath);
        } else if ("bash".equalsIgnoreCase(resourceExt)) {
            args.add("bash");
            args.add(resourcePath);
        } else {
            File file = new File(resourcePath);
            if (!file.canExecute()) {
                file.setExecutable(true, true);
            }
            args.add(resourcePath);
        }
        return args;
    }

    private void setIfNotNull(ProcessBuilder builder, String property, String value) {
        if (value != null && !value.isEmpty()) {
            builder.environment().put(property, value);
        }
    }

    private void runScript(Context context) throws Exception {
        List<String> args = this.getProcessArgs(context);
        LOG.info("Executing " + this.join(" ", args));
        String url = context.getConfiguration().getUrl();
        String username = context.getConfiguration().getUser();
        String password = context.getConfiguration().getPassword();
        String prefix = context.getConfiguration().getScriptPlaceholderPrefix();
        String suffix = context.getConfiguration().getScriptPlaceholderSuffix();
        this.parsingContext.updateFilenamePlaceholder(this.resourceName, context.getConfiguration());
        Map<String, String> placeHolders = this.parsingContext.getPlaceholders();
        placeHolders.putAll(context.getConfiguration().getPlaceholders());
        if (url == null && context.getConnection() != null) {
            try {
                url = context.getConnection().getMetaData().getURL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (username == null && context.getConnection() != null) {
            try {
                username = context.getConnection().getMetaData().getUserName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ProcessBuilder builder = new ProcessBuilder(args);
        this.setIfNotNull(builder, "FLYWAY_URL", url);
        this.setIfNotNull(builder, "FLYWAY_USER", username);
        this.setIfNotNull(builder, "FLYWAY_PASSWORD", password);
        for (String key : placeHolders.keySet()) {
            String value = placeHolders.get(key);
            builder.environment().put(prefix + key.replace(':', '_') + suffix, value);
        }
        builder.redirectErrorStream(true);
        Process process = builder.start();
        String stdOut = FileUtils.copyToString(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        int returnCode = process.waitFor();
        LOG.info(stdOut);
        if (returnCode != 0) {
            throw new FlywayException(stdOut);
        }
    }

    @Override
    public boolean canExecuteInTransaction() {
        return true;
    }

    @Override
    public boolean shouldExecute() {
        return true;
    }

    private void validatePowershellExecutable(String powershellExecutable) {
        String executableName = powershellExecutable.toLowerCase();
        if (!executableName.equals("powershell") && !executableName.equals("pwsh")) {
            throw new FlywayException("Invalid PowerShell executable: " + powershellExecutable + ". Only 'powershell' or 'pwsh' are allowed.");
        }
    }

    @Generated
    public ScriptMigrationExecutor(LoadableResource resource, ParsingContext parsingContext, ResourceName resourceName, StatementInterceptor statementInterceptor) {
        this.resource = resource;
        this.parsingContext = parsingContext;
        this.resourceName = resourceName;
        this.statementInterceptor = statementInterceptor;
    }
}

