/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.common_impl;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.RepositoryChangeListener;
import com.sun.enterprise.module.common_impl.AbstractFactory;
import com.sun.enterprise.module.common_impl.AbstractRepositoryImpl;
import com.sun.enterprise.module.common_impl.ModuleId;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class DirectoryBasedRepository
extends AbstractRepositoryImpl {
    protected final File repository;
    private final int intervalInMs = Integer.getInteger("hk2.file.directory.changeIntervalTimer", 1000);
    private Timer timer;
    private boolean isTimerThreadDaemon = false;
    private List<File> subDirectories;

    public DirectoryBasedRepository(String name, File repository) {
        super(name, repository.toURI());
        this.repository = repository;
    }

    private void initializeSubDirectories() {
        if (this.subDirectories != null) {
            return;
        }
        this.subDirectories = new LinkedList<File>();
        for (File file : this.repository.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            this.subDirectories.add(file);
        }
    }

    public DirectoryBasedRepository(String name, File repository, boolean isTimerThreadDaemon) {
        this(name, repository);
        this.isTimerThreadDaemon = isTimerThreadDaemon;
    }

    @Override
    public synchronized boolean addListener(RepositoryChangeListener listener) {
        boolean returnValue = super.addListener(listener);
        if (returnValue && this.timer == null) {
            this.initializeSubDirectories();
            this.timer = new Timer("hk2-repo-listener-" + this.getName(), this.isTimerThreadDaemon);
            this.timer.schedule(new TimerTask(){
                long lastModified;
                {
                    this.lastModified = DirectoryBasedRepository.this.repository.lastModified();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.lastModified < DirectoryBasedRepository.this.repository.lastModified()) {
                            this.lastModified = DirectoryBasedRepository.this.repository.lastModified();
                            DirectoryBasedRepository.this.directoryChanged();
                        }
                    }
                }
            }, this.intervalInMs, (long)this.intervalInMs);
            this.timer.purge();
        }
        return returnValue;
    }

    @Override
    public void shutdown() throws IOException {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    @Override
    protected void loadModuleDefs(Map<ModuleId, ModuleDefinition> moduleDefs, List<URI> libraries) throws IOException {
        if (!this.repository.exists()) {
            throw new FileNotFoundException(this.repository.getAbsolutePath());
        }
        try {
            File[] files;
            for (File aFile : files = this.repository.listFiles()) {
                if (!aFile.getName().endsWith(".jar") || this.isDisabled(aFile)) continue;
                ModuleDefinition moduleDef = this.loadJar(aFile);
                if (moduleDef != null) {
                    moduleDefs.put(AbstractFactory.getInstance().createModuleId(moduleDef), moduleDef);
                    continue;
                }
                libraries.add(aFile.toURI());
            }
        }
        catch (IOException e) {
            IOException x = new IOException("Failed to load modules from " + this.repository);
            x.initCause(e);
            throw x;
        }
    }

    protected boolean isDisabled(File jar) {
        String fileName = jar.getName();
        fileName = fileName.substring(0, fileName.lastIndexOf(46)) + ".disabled";
        File disabledFile = new File(jar.getParent(), fileName);
        return disabledFile.exists();
    }

    private synchronized void directoryChanged() {
        HashMap<ModuleId, ModuleDefinition> newModuleDefs = new HashMap<ModuleId, ModuleDefinition>();
        LinkedList<URI> libraries = new LinkedList<URI>();
        try {
            this.loadModuleDefs(newModuleDefs, libraries);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        for (ModuleDefinition def : newModuleDefs.values()) {
            if (this.find(def.getName(), def.getVersion()) != null) continue;
            this.add(def);
            for (RepositoryChangeListener listener : this.listeners) {
                listener.moduleAdded(def);
            }
        }
        for (ModuleDefinition def : this.findAll()) {
            if (newModuleDefs.containsKey(AbstractFactory.getInstance().createModuleId(def))) continue;
            this.remove(def);
            for (RepositoryChangeListener listener : this.listeners) {
                listener.moduleRemoved(def);
            }
        }
        List<URI> originalLibraries = super.getJarLocations();
        for (URI location : libraries) {
            if (originalLibraries.contains(location)) continue;
            this.addLibrary(location);
            for (RepositoryChangeListener listener : this.listeners) {
                listener.added(location);
            }
        }
        if (originalLibraries.size() > 0) {
            LinkedList<URI> copy = new LinkedList<URI>();
            copy.addAll(originalLibraries);
            for (URI originalLocation : copy) {
                if (libraries.contains(originalLocation)) continue;
                this.removeLibrary(originalLocation);
                for (RepositoryChangeListener listener : this.listeners) {
                    listener.removed(originalLocation);
                }
            }
        }
        LinkedList<File> previous = new LinkedList<File>();
        previous.addAll(this.subDirectories);
        for (File file : this.repository.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            if (!this.subDirectories.contains(file)) {
                for (RepositoryChangeListener listener : this.listeners) {
                    listener.added(file.toURI());
                }
                this.subDirectories.add(file);
                continue;
            }
            previous.remove(file);
        }
        if (!previous.isEmpty()) {
            for (File file : previous) {
                for (RepositoryChangeListener listener : this.listeners) {
                    listener.removed(file.toURI());
                }
                this.subDirectories.remove(file);
            }
        }
    }
}

