/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.language.internal;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.IdentifiableType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.MappedSuperclassType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.tool.language.spi.MetamodelSerializer;
import org.hibernate.type.format.StringJsonDocumentWriter;

public class MetamodelJsonSerializerImpl
implements MetamodelSerializer {
    public static MetamodelJsonSerializerImpl INSTANCE = new MetamodelJsonSerializerImpl();

    @Override
    public String toString(Metamodel metamodel) {
        ArrayList<Map<String, Object>> entities = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> embeddables = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> mappedSupers = new ArrayList<Map<String, Object>>();
        block5: for (ManagedType managedType : metamodel.getManagedTypes()) {
            switch (managedType.getPersistenceType()) {
                case ENTITY: {
                    entities.add(MetamodelJsonSerializerImpl.getEntityTypeDescription((EntityType)managedType));
                    continue block5;
                }
                case EMBEDDABLE: {
                    embeddables.add(MetamodelJsonSerializerImpl.getEmbeddableTypeDescription((EmbeddableType)managedType));
                    continue block5;
                }
                case MAPPED_SUPERCLASS: {
                    mappedSupers.add(MetamodelJsonSerializerImpl.getMappedSuperclassTypeDescription((MappedSuperclassType)managedType));
                    continue block5;
                }
            }
            throw new IllegalStateException("Unexpected persistence type for managed type [" + String.valueOf(managedType) + "]");
        }
        return MetamodelJsonSerializerImpl.toJson(Map.of("entities", entities, "mappedSuperclasses", mappedSupers, "embeddables", embeddables));
    }

    private static String toJson(Map<String, Object> map) {
        if (map.isEmpty()) {
            return "{}";
        }
        StringJsonDocumentWriter writer = new StringJsonDocumentWriter(new StringBuilder());
        MetamodelJsonSerializerImpl.toJson(map, writer);
        return writer.toString();
    }

    private static void toJson(Object value, StringJsonDocumentWriter writer) {
        if (value instanceof String) {
            String strValue = (String)value;
            writer.stringValue(strValue);
        } else if (value instanceof Boolean) {
            Boolean boolValue = (Boolean)value;
            writer.booleanValue(boolValue.booleanValue());
        } else if (value instanceof Number) {
            Number numValue = (Number)value;
            writer.numericValue(numValue);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            writer.startObject();
            for (Map.Entry entry : map.entrySet()) {
                writer.objectKey(entry.getKey().toString());
                MetamodelJsonSerializerImpl.toJson(entry.getValue(), writer);
            }
            writer.endObject();
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            writer.startArray();
            for (Object item : collection) {
                MetamodelJsonSerializerImpl.toJson(item, writer);
            }
            writer.endArray();
        } else if (value == null) {
            writer.nullValue();
        } else {
            throw new IllegalArgumentException("Unsupported value type: " + value.getClass().getName());
        }
    }

    private static void putIfNotNull(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    private static <T> Map<String, Object> getEntityTypeDescription(EntityType<T> entityType) {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("name", entityType.getName());
        map.put("class", entityType.getJavaType().getTypeName());
        MetamodelJsonSerializerImpl.putIfNotNull(map, "superType", MetamodelJsonSerializerImpl.superTypeDescriptor((ManagedDomainType)entityType));
        MetamodelJsonSerializerImpl.putIfNotNull(map, "identifierAttribute", MetamodelJsonSerializerImpl.identifierDescriptor(entityType));
        map.put("attributes", MetamodelJsonSerializerImpl.attributeArray(entityType.getAttributes()));
        return map;
    }

    private static String superTypeDescriptor(ManagedDomainType<?> managedType) {
        ManagedDomainType superType = managedType.getSuperType();
        return superType != null ? superType.getJavaType().getTypeName() : null;
    }

    private static <T> Map<String, Object> getMappedSuperclassTypeDescription(MappedSuperclassType<T> mappedSuperclass) {
        Class javaType = mappedSuperclass.getJavaType();
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("name", javaType.getSimpleName());
        map.put("class", javaType.getTypeName());
        MetamodelJsonSerializerImpl.putIfNotNull(map, "superType", MetamodelJsonSerializerImpl.superTypeDescriptor((ManagedDomainType)mappedSuperclass));
        MetamodelJsonSerializerImpl.putIfNotNull(map, "identifierAttribute", MetamodelJsonSerializerImpl.identifierDescriptor(mappedSuperclass));
        map.put("attributes", MetamodelJsonSerializerImpl.attributeArray(mappedSuperclass.getAttributes()));
        return map;
    }

    private static <T> String identifierDescriptor(IdentifiableType<T> identifiableType) {
        Type idType = identifiableType.getIdType();
        if (idType != null) {
            SingularAttribute id = identifiableType.getId(idType.getJavaType());
            return id.getName();
        }
        return null;
    }

    private static <T> Map<String, Object> getEmbeddableTypeDescription(EmbeddableType<T> embeddableType) {
        Class javaType = embeddableType.getJavaType();
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("name", javaType.getSimpleName());
        map.put("class", javaType.getTypeName());
        MetamodelJsonSerializerImpl.putIfNotNull(map, "superType", MetamodelJsonSerializerImpl.superTypeDescriptor((ManagedDomainType)embeddableType));
        map.put("attributes", MetamodelJsonSerializerImpl.attributeArray(embeddableType.getAttributes()));
        return map;
    }

    private static <T> List<Map<String, String>> attributeArray(Set<Attribute<? super T, ?>> attributes) {
        if (attributes.isEmpty()) {
            return List.of();
        }
        return attributes.stream().map(attribute -> {
            String name = attribute.getName();
            Object type = attribute.getJavaType().getTypeName();
            if (attribute instanceof PluralAttribute) {
                PluralAttribute pluralAttribute = (PluralAttribute)attribute;
                type = (String)type + "<";
                PluralAttribute.CollectionType collectionType = pluralAttribute.getCollectionType();
                if (collectionType == PluralAttribute.CollectionType.MAP) {
                    type = (String)type + ((MapAttribute)pluralAttribute).getKeyJavaType().getTypeName() + ",";
                }
                type = (String)type + pluralAttribute.getElementType().getJavaType().getTypeName() + ">";
            }
            return Map.of("type", type, "name", name);
        }).toList();
    }
}

