/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.util.ArrayList;
import java.util.List;
import org.jooq.meta.AbstractDefinition;
import org.jooq.meta.AbstractTypedElementDefinition;
import org.jooq.meta.ContainerElementDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.tools.JooqLogger;

public abstract class AbstractContainerElementDefinition<T extends Definition>
extends AbstractDefinition
implements ContainerElementDefinition<T> {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractTypedElementDefinition.class);
    final T container;

    public AbstractContainerElementDefinition(T container, String name, int position, String comment) {
        this(container, name, position, comment, null);
    }

    public AbstractContainerElementDefinition(T container, String name, int position, String comment, String overload) {
        super(container.getDatabase(), container.getSchema(), AbstractContainerElementDefinition.protectName(container, name, position), comment, overload);
        this.container = container;
    }

    private static final String protectName(Definition container, String name, int position) {
        if (name == null) {
            if (container instanceof TableDefinition) {
                log.info((Object)"Missing name", (Object)("Table " + String.valueOf(container) + " holds a column without a name at position " + position));
            } else if (container instanceof UDTDefinition) {
                log.info((Object)"Missing name", (Object)("UDT " + String.valueOf(container) + " holds an attribute without a name at position " + position));
            } else if (container instanceof IndexDefinition) {
                log.info((Object)"Missing name", (Object)("Index " + String.valueOf(container) + " holds a column without a name at position " + position));
            } else if (container instanceof RoutineDefinition) {
                log.info((Object)"Missing name", (Object)("Routine " + String.valueOf(container) + " holds a parameter without a name at position " + position));
            } else if (container instanceof EnumDefinition) {
                log.info((Object)"Missing name", (Object)("Enum " + String.valueOf(container) + " holds a literal without a name at position " + position));
            } else {
                log.info((Object)"Missing name", (Object)("Object " + String.valueOf(container) + " holds an element without a name at position " + position));
            }
            return "_" + position;
        }
        return name;
    }

    @Override
    public final T getContainer() {
        return this.container;
    }

    @Override
    public List<Definition> getDefinitionPath() {
        ArrayList<Definition> result = new ArrayList<Definition>();
        result.addAll(this.getContainer().getDefinitionPath());
        result.add(this);
        return result;
    }
}

