/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ContentResolver {
    private static final Set<String> CLASSPATH_SCHEMES = new HashSet<String>(Arrays.asList("classpath", "resource", "java"));
    private final ObjectMapper objectMapper;

    public ContentResolver() {
        this(null);
    }

    public ContentResolver(JsonFactory jsonFactory) {
        this.objectMapper = new ObjectMapper(jsonFactory).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS}).enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
    }

    public JsonNode resolve(URI uri) {
        if (CLASSPATH_SCHEMES.contains(uri.getScheme())) {
            return this.resolveFromClasspath(uri);
        }
        try {
            return this.objectMapper.readTree(uri.toURL());
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Error parsing document: " + uri, e);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unrecognised URI, can't resolve this: " + uri, e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unrecognised URI, can't resolve this: " + uri, e);
        }
    }

    private JsonNode resolveFromClasspath(URI uri) {
        String path = StringUtils.removeStart((String)StringUtils.removeStart((String)uri.toString(), (String)(uri.getScheme() + ":")), (String)"/");
        InputStream contentAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (contentAsStream == null) {
            throw new IllegalArgumentException("Couldn't read content from the classpath, file not found: " + uri);
        }
        try {
            return this.objectMapper.readTree(contentAsStream);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Error parsing document: " + uri, e);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unrecognised URI, can't resolve this: " + uri, e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unrecognised URI, can't resolve this: " + uri, e);
        }
    }
}

