/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import android.os.Parcelable;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jsonschema2pojo.AnnotationStyle;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.exception.ClassAlreadyExistsException;
import org.jsonschema2pojo.rules.PrimitiveTypes;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.NameHelper;
import org.jsonschema2pojo.util.ParcelableHelper;
import org.jsonschema2pojo.util.SerializableHelper;
import org.jsonschema2pojo.util.TypeUtil;

public class ObjectRule
implements Rule<JPackage, JType> {
    private final RuleFactory ruleFactory;
    private final ParcelableHelper parcelableHelper;

    protected ObjectRule(RuleFactory ruleFactory, ParcelableHelper parcelableHelper) {
        this.ruleFactory = ruleFactory;
        this.parcelableHelper = parcelableHelper;
    }

    @Override
    public JType apply(String nodeName, JsonNode node, JPackage _package, Schema schema) {
        JDefinedClass jclass;
        JType superType = this.getSuperType(nodeName, node, _package, schema);
        if (superType.isPrimitive() || this.isFinal(superType)) {
            return superType;
        }
        try {
            jclass = this.createClass(nodeName, node, _package);
        }
        catch (ClassAlreadyExistsException e) {
            return e.getExistingClass();
        }
        jclass._extends((JClass)superType);
        schema.setJavaTypeIfEmpty((JType)jclass);
        if (node.has("deserializationClassProperty")) {
            this.addJsonTypeInfoAnnotation(jclass, node);
        }
        if (node.has("title")) {
            this.ruleFactory.getTitleRule().apply(nodeName, node.get("title"), (JDocCommentable)jclass, schema);
        }
        if (node.has("description")) {
            this.ruleFactory.getDescriptionRule().apply(nodeName, node.get("description"), (JDocCommentable)jclass, schema);
        }
        this.ruleFactory.getPropertiesRule().apply(nodeName, node.get("properties"), jclass, schema);
        if (node.has("javaInterfaces")) {
            this.addInterfaces(jclass, node.get("javaInterfaces"));
        }
        this.ruleFactory.getAdditionalPropertiesRule().apply(nodeName, node.get("additionalProperties"), jclass, schema);
        this.ruleFactory.getDynamicPropertiesRule().apply(nodeName, node.get("properties"), jclass, schema);
        if (node.has("required")) {
            this.ruleFactory.getRequiredArrayRule().apply(nodeName, node.get("required"), jclass, schema);
        }
        if (this.ruleFactory.getGenerationConfig().isIncludeToString()) {
            this.addToString(jclass);
        }
        if (this.ruleFactory.getGenerationConfig().isIncludeHashcodeAndEquals()) {
            this.addHashCode(jclass, node);
            this.addEquals(jclass, node);
        }
        if (this.ruleFactory.getGenerationConfig().isParcelable()) {
            this.addParcelSupport(jclass);
        }
        if (this.ruleFactory.getGenerationConfig().isIncludeConstructors()) {
            this.addConstructors(jclass, node, schema, this.ruleFactory.getGenerationConfig().isConstructorsRequiredPropertiesOnly());
        }
        if (this.ruleFactory.getGenerationConfig().isSerializable()) {
            SerializableHelper.addSerializableSupport(jclass);
        }
        return jclass;
    }

    private void addParcelSupport(JDefinedClass jclass) {
        jclass._implements(Parcelable.class);
        this.parcelableHelper.addWriteToParcel(jclass);
        this.parcelableHelper.addDescribeContents(jclass);
        this.parcelableHelper.addCreator(jclass);
        this.parcelableHelper.addConstructorFromParcel(jclass);
        if (!this.ruleFactory.getGenerationConfig().isIncludeConstructors()) {
            jclass.constructor(1);
        }
    }

    private LinkedHashSet<String> getConstructorProperties(JsonNode node, boolean onlyRequired) {
        JsonNode requiredArray;
        if (!node.has("properties")) {
            return new LinkedHashSet<String>();
        }
        LinkedHashSet<String> rtn = new LinkedHashSet<String>();
        HashSet<String> draft4RequiredProperties = new HashSet<String>();
        if (onlyRequired && node.has("required") && (requiredArray = node.get("required")).isArray()) {
            for (JsonNode requiredEntry : requiredArray) {
                if (!requiredEntry.isTextual()) continue;
                draft4RequiredProperties.add(requiredEntry.asText());
            }
        }
        NameHelper nameHelper = this.ruleFactory.getNameHelper();
        Iterator properties = node.get("properties").fields();
        while (properties.hasNext()) {
            Map.Entry property = (Map.Entry)properties.next();
            JsonNode propertyObj = (JsonNode)property.getValue();
            if (onlyRequired) {
                if (propertyObj.has("required") && propertyObj.get("required").asBoolean()) {
                    rtn.add(nameHelper.getPropertyName((String)property.getKey(), (JsonNode)property.getValue()));
                }
                if (!draft4RequiredProperties.contains(property.getKey())) continue;
                rtn.add(nameHelper.getPropertyName((String)property.getKey(), (JsonNode)property.getValue()));
                continue;
            }
            rtn.add(nameHelper.getPropertyName((String)property.getKey(), (JsonNode)property.getValue()));
        }
        return rtn;
    }

    private LinkedHashSet<String> getSuperTypeConstructorPropertiesRecursive(JsonNode node, Schema schema, boolean onlyRequired) {
        Schema superTypeSchema = this.getSuperSchema(node, schema, true);
        if (superTypeSchema == null) {
            return new LinkedHashSet<String>();
        }
        JsonNode superSchemaNode = superTypeSchema.getContent();
        LinkedHashSet<String> rtn = this.getConstructorProperties(superSchemaNode, onlyRequired);
        rtn.addAll(this.getSuperTypeConstructorPropertiesRecursive(superSchemaNode, superTypeSchema, onlyRequired));
        return rtn;
    }

    private JDefinedClass createClass(String nodeName, JsonNode node, JPackage _package) throws ClassAlreadyExistsException {
        JDefinedClass newType;
        try {
            boolean usePolymorphicDeserialization = this.usesPolymorphicDeserialization(node);
            if (node.has("javaType")) {
                String fqn = StringUtils.substringBefore((String)node.get("javaType").asText(), (String)"<");
                if (PrimitiveTypes.isPrimitive(fqn, _package.owner())) {
                    throw new ClassAlreadyExistsException((JType)PrimitiveTypes.primitiveType(fqn, _package.owner()));
                }
                try {
                    _package.owner().ref(Thread.currentThread().getContextClassLoader().loadClass(fqn));
                    JClass existingClass = TypeUtil.resolveType((JClassContainer)_package, fqn + (node.get("javaType").asText().contains("<") ? "<" + StringUtils.substringAfter((String)node.get("javaType").asText(), (String)"<") : ""));
                    throw new ClassAlreadyExistsException((JType)existingClass);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    int index = fqn.lastIndexOf(".") + 1;
                    if (index >= 0 && index < fqn.length()) {
                        fqn = fqn.substring(0, index) + this.ruleFactory.getGenerationConfig().getClassNamePrefix() + fqn.substring(index) + this.ruleFactory.getGenerationConfig().getClassNameSuffix();
                    }
                    try {
                        _package.owner().ref(Thread.currentThread().getContextClassLoader().loadClass(fqn));
                        JClass existingClass = TypeUtil.resolveType((JClassContainer)_package, fqn + (node.get("javaType").asText().contains("<") ? "<" + StringUtils.substringAfter((String)node.get("javaType").asText(), (String)"<") : ""));
                        throw new ClassAlreadyExistsException((JType)existingClass);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        newType = usePolymorphicDeserialization ? _package.owner()._class(1, fqn, ClassType.CLASS) : _package.owner()._class(fqn);
                    }
                }
            } else {
                newType = usePolymorphicDeserialization ? _package._class(1, this.getClassName(nodeName, node, _package), ClassType.CLASS) : _package._class(this.getClassName(nodeName, node, _package));
            }
        }
        catch (JClassAlreadyExistsException e) {
            throw new ClassAlreadyExistsException((JType)e.getExistingClass());
        }
        this.ruleFactory.getAnnotator().propertyInclusion(newType, node);
        return newType;
    }

    private boolean isFinal(JType superType) {
        try {
            Class<?> javaClass = Class.forName(superType.fullName());
            return Modifier.isFinal(javaClass.getModifiers());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private JType getSuperType(String nodeName, JsonNode node, JPackage jPackage, Schema schema) {
        if (node.has("extends") && node.has("extendsJavaClass")) {
            throw new IllegalStateException("'extends' and 'extendsJavaClass' defined simultaneously");
        }
        JClass superType = jPackage.owner().ref(Object.class);
        Schema superTypeSchema = this.getSuperSchema(node, schema, false);
        if (superTypeSchema != null) {
            superType = this.ruleFactory.getSchemaRule().apply(nodeName + "Parent", node.get("extends"), (JClassContainer)jPackage, superTypeSchema);
        } else if (node.has("extendsJavaClass")) {
            superType = TypeUtil.resolveType((JClassContainer)jPackage, node.get("extendsJavaClass").asText());
        }
        return superType;
    }

    private Schema getSuperSchema(JsonNode node, Schema schema, boolean followRefs) {
        if (node.has("extends")) {
            String path = schema.getId().getFragment() == null ? "#extends" : "#" + schema.getId().getFragment() + "/extends";
            Schema superSchema = this.ruleFactory.getSchemaStore().create(schema, path, this.ruleFactory.getGenerationConfig().getRefFragmentPathDelimiters());
            if (followRefs) {
                superSchema = this.resolveSchemaRefsRecursive(superSchema);
            }
            return superSchema;
        }
        return null;
    }

    private Schema resolveSchemaRefsRecursive(Schema schema) {
        JsonNode schemaNode = schema.getContent();
        if (schemaNode.has("$ref")) {
            schema = this.ruleFactory.getSchemaStore().create(schema, schemaNode.get("$ref").asText(), this.ruleFactory.getGenerationConfig().getRefFragmentPathDelimiters());
            return this.resolveSchemaRefsRecursive(schema);
        }
        return schema;
    }

    private void addJsonTypeInfoAnnotation(JDefinedClass jclass, JsonNode node) {
        if (this.ruleFactory.getGenerationConfig().getAnnotationStyle() == AnnotationStyle.JACKSON2) {
            String annotationName = node.get("deserializationClassProperty").asText();
            JAnnotationUse jsonTypeInfo = jclass.annotate(JsonTypeInfo.class);
            jsonTypeInfo.param("use", (Enum)JsonTypeInfo.Id.CLASS);
            jsonTypeInfo.param("include", (Enum)JsonTypeInfo.As.PROPERTY);
            jsonTypeInfo.param("property", annotationName);
        }
    }

    private void addToString(JDefinedClass jclass) {
        Map fields = jclass.fields();
        JMethod toString = jclass.method(1, String.class, "toString");
        HashSet<String> excludes = new HashSet<String>(Arrays.asList(this.ruleFactory.getGenerationConfig().getToStringExcludes()));
        JBlock body = toString.body();
        Class toStringBuilder = this.ruleFactory.getGenerationConfig().isUseCommonsLang3() ? ToStringBuilder.class : org.apache.commons.lang.builder.ToStringBuilder.class;
        JClass toStringBuilderClass = jclass.owner().ref(toStringBuilder);
        JInvocation toStringBuilderInvocation = JExpr._new((JClass)toStringBuilderClass).arg(JExpr._this());
        if (!jclass._extends().fullName().equals(Object.class.getName())) {
            toStringBuilderInvocation = toStringBuilderInvocation.invoke("appendSuper").arg((JExpression)JExpr._super().invoke("toString"));
        }
        for (JFieldVar fieldVar : fields.values()) {
            if (excludes.contains(fieldVar.name()) || (fieldVar.mods().getValue() & 0x10) == 16) continue;
            toStringBuilderInvocation = toStringBuilderInvocation.invoke("append").arg(fieldVar.name()).arg((JExpression)fieldVar);
        }
        body._return((JExpression)toStringBuilderInvocation.invoke("toString"));
        toString.annotate(Override.class);
    }

    private void addHashCode(JDefinedClass jclass, JsonNode node) {
        Map<String, JFieldVar> fields = this.removeFieldsExcludedFromEqualsAndHashCode(jclass.fields(), node);
        JMethod hashCode = jclass.method(1, Integer.TYPE, "hashCode");
        Class hashCodeBuilder = this.ruleFactory.getGenerationConfig().isUseCommonsLang3() ? org.apache.commons.lang3.builder.HashCodeBuilder.class : HashCodeBuilder.class;
        JBlock body = hashCode.body();
        JClass hashCodeBuilderClass = jclass.owner().ref(hashCodeBuilder);
        JInvocation hashCodeBuilderInvocation = JExpr._new((JClass)hashCodeBuilderClass);
        if (!jclass._extends().fullName().equals(Object.class.getName())) {
            hashCodeBuilderInvocation = hashCodeBuilderInvocation.invoke("appendSuper").arg((JExpression)JExpr._super().invoke("hashCode"));
        }
        for (JFieldVar fieldVar : fields.values()) {
            if ((fieldVar.mods().getValue() & 0x10) == 16) continue;
            hashCodeBuilderInvocation = hashCodeBuilderInvocation.invoke("append").arg((JExpression)fieldVar);
        }
        body._return((JExpression)hashCodeBuilderInvocation.invoke("toHashCode"));
        hashCode.annotate(Override.class);
    }

    private Map<String, JFieldVar> removeFieldsExcludedFromEqualsAndHashCode(Map<String, JFieldVar> fields, JsonNode node) {
        HashMap<String, JFieldVar> filteredFields = new HashMap<String, JFieldVar>(fields);
        JsonNode properties = node.get("properties");
        if (properties != null) {
            if (node.has("excludedFromEqualsAndHashCode")) {
                JsonNode excludedArray = node.get("excludedFromEqualsAndHashCode");
                Iterator iterator = excludedArray.elements();
                while (iterator.hasNext()) {
                    String excludedPropertyName = ((JsonNode)iterator.next()).asText();
                    JsonNode excludedPropertyNode = properties.get(excludedPropertyName);
                    filteredFields.remove(this.ruleFactory.getNameHelper().getPropertyName(excludedPropertyName, excludedPropertyNode));
                }
            }
            Iterator iterator = properties.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String propertyName = (String)entry.getKey();
                JsonNode propertyNode = (JsonNode)entry.getValue();
                if (!propertyNode.has("excludedFromEqualsAndHashCode") || !propertyNode.get("excludedFromEqualsAndHashCode").asBoolean()) continue;
                filteredFields.remove(this.ruleFactory.getNameHelper().getPropertyName(propertyName, propertyNode));
            }
        }
        return filteredFields;
    }

    private void addConstructors(JDefinedClass jclass, JsonNode node, Schema schema, boolean onlyRequired) {
        LinkedHashSet<String> classProperties = this.getConstructorProperties(node, onlyRequired);
        LinkedHashSet<String> combinedSuperProperties = this.getSuperTypeConstructorPropertiesRecursive(node, schema, onlyRequired);
        if (classProperties.isEmpty() && combinedSuperProperties.isEmpty()) {
            return;
        }
        JMethod noargsConstructor = jclass.constructor(1);
        noargsConstructor.javadoc().add((Object)"No args constructor for use in serialization");
        JMethod fieldsConstructor = jclass.constructor(1);
        JBlock constructorBody = fieldsConstructor.body();
        JInvocation superInvocation = constructorBody.invoke("super");
        Map fields = jclass.fields();
        HashMap<String, JVar> classFieldParams = new HashMap<String, JVar>();
        for (String property : classProperties) {
            JFieldVar field = (JFieldVar)fields.get(property);
            if (field == null) {
                throw new IllegalStateException("Property " + property + " hasn't been added to JDefinedClass before calling addConstructors");
            }
            fieldsConstructor.javadoc().addParam(property);
            JVar param = fieldsConstructor.param(field.type(), field.name());
            constructorBody.assign((JAssignmentTarget)JExpr._this().ref((JVar)field), (JExpression)param);
            classFieldParams.put(property, param);
        }
        ArrayList<JVar> superConstructorParams = new ArrayList<JVar>();
        for (String property : combinedSuperProperties) {
            JFieldVar field = this.searchSuperClassesForField(property, jclass);
            if (field == null) {
                throw new IllegalStateException("Property " + property + " hasn't been added to JDefinedClass before calling addConstructors");
            }
            JVar param = (JVar)classFieldParams.get(property);
            if (param == null) {
                param = fieldsConstructor.param(field.type(), field.name());
            }
            fieldsConstructor.javadoc().addParam(property);
            superConstructorParams.add(param);
        }
        for (JVar param : superConstructorParams) {
            superInvocation.arg((JExpression)param);
        }
    }

    private static JDefinedClass definedClassOrNullFromType(JType type) {
        if (type == null || type.isPrimitive()) {
            return null;
        }
        JClass fieldClass = type.boxify();
        JPackage jPackage = fieldClass._package();
        return jPackage._getClass(fieldClass.name());
    }

    private JFieldVar searchSuperClassesForField(String property, JDefinedClass jclass) {
        JClass superClass = jclass._extends();
        JDefinedClass definedSuperClass = ObjectRule.definedClassOrNullFromType((JType)superClass);
        if (definedSuperClass == null) {
            return null;
        }
        return this.searchClassAndSuperClassesForField(property, definedSuperClass);
    }

    private JFieldVar searchClassAndSuperClassesForField(String property, JDefinedClass jclass) {
        Map fields = jclass.fields();
        JFieldVar field = (JFieldVar)fields.get(property);
        if (field == null) {
            return this.searchSuperClassesForField(property, jclass);
        }
        return field;
    }

    private void addEquals(JDefinedClass jclass, JsonNode node) {
        Map<String, JFieldVar> fields = this.removeFieldsExcludedFromEqualsAndHashCode(jclass.fields(), node);
        JMethod equals = jclass.method(1, Boolean.TYPE, "equals");
        JVar otherObject = equals.param(Object.class, "other");
        Class equalsBuilder = this.ruleFactory.getGenerationConfig().isUseCommonsLang3() ? EqualsBuilder.class : org.apache.commons.lang.builder.EqualsBuilder.class;
        JBlock body = equals.body();
        body._if(otherObject.eq(JExpr._this()))._then()._return(JExpr.TRUE);
        body._if(otherObject._instanceof((JType)jclass).eq(JExpr.FALSE))._then()._return(JExpr.FALSE);
        JVar rhsVar = body.decl((JType)jclass, "rhs").init((JExpression)JExpr.cast((JType)jclass, (JExpression)otherObject));
        JClass equalsBuilderClass = jclass.owner().ref(equalsBuilder);
        JInvocation equalsBuilderInvocation = JExpr._new((JClass)equalsBuilderClass);
        if (!jclass._extends().fullName().equals(Object.class.getName())) {
            equalsBuilderInvocation = equalsBuilderInvocation.invoke("appendSuper").arg((JExpression)JExpr._super().invoke("equals").arg((JExpression)otherObject));
        }
        for (JFieldVar fieldVar : fields.values()) {
            if ((fieldVar.mods().getValue() & 0x10) == 16) continue;
            equalsBuilderInvocation = equalsBuilderInvocation.invoke("append").arg((JExpression)fieldVar).arg((JExpression)rhsVar.ref(fieldVar.name()));
        }
        JInvocation reflectionEquals = jclass.owner().ref(equalsBuilder).staticInvoke("reflectionEquals");
        reflectionEquals.arg(JExpr._this());
        reflectionEquals.arg((JExpression)otherObject);
        body._return((JExpression)equalsBuilderInvocation.invoke("isEquals"));
        equals.annotate(Override.class);
    }

    private void addInterfaces(JDefinedClass jclass, JsonNode javaInterfaces) {
        for (JsonNode i : javaInterfaces) {
            jclass._implements(TypeUtil.resolveType((JClassContainer)jclass._package(), i.asText()));
        }
    }

    private String getClassName(String nodeName, JsonNode node, JPackage _package) {
        String prefix = this.ruleFactory.getGenerationConfig().getClassNamePrefix();
        String suffix = this.ruleFactory.getGenerationConfig().getClassNameSuffix();
        String fieldName = this.ruleFactory.getNameHelper().getFieldName(nodeName, node);
        String capitalizedFieldName = StringUtils.capitalize((String)fieldName);
        String fullFieldName = this.createFullFieldName(capitalizedFieldName, prefix, suffix);
        String className = this.ruleFactory.getNameHelper().replaceIllegalCharacters(fullFieldName);
        String normalizedName = this.ruleFactory.getNameHelper().normalizeName(className);
        return this.makeUnique(normalizedName, _package);
    }

    private String createFullFieldName(String nodeName, String prefix, String suffix) {
        String returnString = nodeName;
        if (prefix != null) {
            returnString = prefix + returnString;
        }
        if (suffix != null) {
            returnString = returnString + suffix;
        }
        return returnString;
    }

    private String makeUnique(String className, JPackage _package) {
        try {
            JDefinedClass _class = _package._class(className);
            _package.remove((JClass)_class);
            return className;
        }
        catch (JClassAlreadyExistsException e) {
            return this.makeUnique(className + "_", _package);
        }
    }

    private boolean usesPolymorphicDeserialization(JsonNode node) {
        if (this.ruleFactory.getGenerationConfig().getAnnotationStyle() == AnnotationStyle.JACKSON2) {
            return node.has("deserializationClassProperty");
        }
        return false;
    }
}

