/*
 * Decompiled with CFR 0.152.
 */
package org.jsonschema2pojo.rules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jsonschema2pojo.AnnotationStyle;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.exception.ClassAlreadyExistsException;
import org.jsonschema2pojo.exception.GenerationException;
import org.jsonschema2pojo.rules.PrimitiveTypes;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.MakeUniqueClassName;
import org.jsonschema2pojo.util.NameHelper;
import org.jsonschema2pojo.util.ParcelableHelper;
import org.jsonschema2pojo.util.SerializableHelper;
import org.jsonschema2pojo.util.TypeUtil;

public class ObjectRule
implements Rule<JPackage, JType> {
    private final RuleFactory ruleFactory;
    private final ParcelableHelper parcelableHelper;

    protected ObjectRule(RuleFactory ruleFactory, ParcelableHelper parcelableHelper) {
        this.ruleFactory = ruleFactory;
        this.parcelableHelper = parcelableHelper;
    }

    @Override
    public JType apply(String nodeName, JsonNode node, JPackage _package, Schema schema) {
        JDefinedClass jclass;
        JType superType = this.getSuperType(nodeName, node, _package, schema);
        if (superType.isPrimitive() || this.isFinal(superType)) {
            return superType;
        }
        try {
            jclass = this.createClass(nodeName, node, _package);
        }
        catch (ClassAlreadyExistsException e) {
            return e.getExistingClass();
        }
        jclass._extends((JClass)superType);
        schema.setJavaTypeIfEmpty((JType)jclass);
        if (node.has("deserializationClassProperty")) {
            this.addJsonTypeInfoAnnotation(jclass, node);
        }
        if (node.has("title")) {
            this.ruleFactory.getTitleRule().apply(nodeName, node.get("title"), (JDocCommentable)jclass, schema);
        }
        if (node.has("description")) {
            this.ruleFactory.getDescriptionRule().apply(nodeName, node.get("description"), (JDocCommentable)jclass, schema);
        }
        this.ruleFactory.getPropertiesRule().apply(nodeName, node.get("properties"), jclass, schema);
        if (node.has("javaInterfaces")) {
            this.addInterfaces(jclass, node.get("javaInterfaces"));
        }
        this.ruleFactory.getAdditionalPropertiesRule().apply(nodeName, node.get("additionalProperties"), jclass, schema);
        this.ruleFactory.getDynamicPropertiesRule().apply(nodeName, node.get("properties"), jclass, schema);
        if (node.has("required")) {
            this.ruleFactory.getRequiredArrayRule().apply(nodeName, node.get("required"), jclass, schema);
        }
        if (this.ruleFactory.getGenerationConfig().isIncludeToString()) {
            this.addToString(jclass);
        }
        if (this.ruleFactory.getGenerationConfig().isIncludeHashcodeAndEquals()) {
            this.addHashCode(jclass, node);
            this.addEquals(jclass, node);
        }
        if (this.ruleFactory.getGenerationConfig().isParcelable()) {
            this.addParcelSupport(jclass);
        }
        if (this.ruleFactory.getGenerationConfig().isIncludeConstructors()) {
            this.addConstructors(jclass, node, schema, this.ruleFactory.getGenerationConfig().isConstructorsRequiredPropertiesOnly());
        }
        if (this.ruleFactory.getGenerationConfig().isSerializable()) {
            SerializableHelper.addSerializableSupport(jclass);
        }
        return jclass;
    }

    private void addParcelSupport(JDefinedClass jclass) {
        jclass._implements(jclass.owner().directClass("android.os.Parcelable"));
        this.parcelableHelper.addWriteToParcel(jclass);
        this.parcelableHelper.addDescribeContents(jclass);
        this.parcelableHelper.addCreator(jclass);
        this.parcelableHelper.addConstructorFromParcel(jclass);
        if (!this.ruleFactory.getGenerationConfig().isIncludeConstructors()) {
            jclass.constructor(1);
        }
    }

    private LinkedHashSet<String> getConstructorProperties(JsonNode node, boolean onlyRequired) {
        JsonNode requiredArray;
        if (!node.has("properties")) {
            return new LinkedHashSet<String>();
        }
        LinkedHashSet<String> rtn = new LinkedHashSet<String>();
        HashSet<String> draft4RequiredProperties = new HashSet<String>();
        if (onlyRequired && node.has("required") && (requiredArray = node.get("required")).isArray()) {
            for (JsonNode requiredEntry : requiredArray) {
                if (!requiredEntry.isTextual()) continue;
                draft4RequiredProperties.add(requiredEntry.asText());
            }
        }
        NameHelper nameHelper = this.ruleFactory.getNameHelper();
        Iterator properties = node.get("properties").fields();
        while (properties.hasNext()) {
            Map.Entry property = (Map.Entry)properties.next();
            JsonNode propertyObj = (JsonNode)property.getValue();
            if (onlyRequired) {
                if (propertyObj.has("required") && propertyObj.get("required").asBoolean()) {
                    rtn.add(nameHelper.getPropertyName((String)property.getKey(), (JsonNode)property.getValue()));
                }
                if (!draft4RequiredProperties.contains(property.getKey())) continue;
                rtn.add(nameHelper.getPropertyName((String)property.getKey(), (JsonNode)property.getValue()));
                continue;
            }
            rtn.add(nameHelper.getPropertyName((String)property.getKey(), (JsonNode)property.getValue()));
        }
        return rtn;
    }

    private LinkedHashSet<String> getSuperTypeConstructorPropertiesRecursive(JsonNode node, Schema schema, boolean onlyRequired) {
        Schema superTypeSchema = this.getSuperSchema(node, schema, true);
        if (superTypeSchema == null) {
            return new LinkedHashSet<String>();
        }
        JsonNode superSchemaNode = superTypeSchema.getContent();
        LinkedHashSet<String> rtn = this.getConstructorProperties(superSchemaNode, onlyRequired);
        rtn.addAll(this.getSuperTypeConstructorPropertiesRecursive(superSchemaNode, superTypeSchema, onlyRequired));
        return rtn;
    }

    private JDefinedClass createClass(String nodeName, JsonNode node, JPackage _package) throws ClassAlreadyExistsException {
        JDefinedClass newType;
        try {
            if (node.has("existingJavaType")) {
                String fqn = StringUtils.substringBefore((String)node.get("existingJavaType").asText(), (String)"<");
                if (PrimitiveTypes.isPrimitive(fqn, _package.owner())) {
                    throw new ClassAlreadyExistsException((JType)PrimitiveTypes.primitiveType(fqn, _package.owner()));
                }
                JClass existingClass = TypeUtil.resolveType((JClassContainer)_package, fqn + (node.get("existingJavaType").asText().contains("<") ? "<" + StringUtils.substringAfter((String)node.get("existingJavaType").asText(), (String)"<") : ""));
                throw new ClassAlreadyExistsException((JType)existingClass);
            }
            boolean usePolymorphicDeserialization = this.usesPolymorphicDeserialization(node);
            if (node.has("javaType")) {
                String fqn = node.path("javaType").asText();
                if (PrimitiveTypes.isPrimitive(fqn, _package.owner())) {
                    throw new GenerationException("javaType cannot refer to a primitive type (" + fqn + "), did you mean to use existingJavaType?");
                }
                if (fqn.contains("<")) {
                    throw new GenerationException("javaType does not support generic args (" + fqn + "), did you mean to use existingJavaType?");
                }
                int index = fqn.lastIndexOf(".") + 1;
                if (index >= 0 && index < fqn.length()) {
                    fqn = fqn.substring(0, index) + this.ruleFactory.getGenerationConfig().getClassNamePrefix() + fqn.substring(index) + this.ruleFactory.getGenerationConfig().getClassNameSuffix();
                }
                newType = usePolymorphicDeserialization ? _package.owner()._class(1, fqn, ClassType.CLASS) : _package.owner()._class(fqn);
            } else {
                newType = usePolymorphicDeserialization ? _package._class(1, this.getClassName(nodeName, node, _package), ClassType.CLASS) : _package._class(this.getClassName(nodeName, node, _package));
            }
        }
        catch (JClassAlreadyExistsException e) {
            throw new ClassAlreadyExistsException((JType)e.getExistingClass());
        }
        this.ruleFactory.getAnnotator().propertyInclusion(newType, node);
        return newType;
    }

    private boolean isFinal(JType superType) {
        try {
            Class<?> javaClass = Class.forName(superType.fullName());
            return Modifier.isFinal(javaClass.getModifiers());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private JType getSuperType(String nodeName, JsonNode node, JPackage jPackage, Schema schema) {
        if (node.has("extends") && node.has("extendsJavaClass")) {
            throw new IllegalStateException("'extends' and 'extendsJavaClass' defined simultaneously");
        }
        JClass superType = jPackage.owner().ref(Object.class);
        Schema superTypeSchema = this.getSuperSchema(node, schema, false);
        if (superTypeSchema != null) {
            superType = this.ruleFactory.getSchemaRule().apply(nodeName + "Parent", node.get("extends"), (JClassContainer)jPackage, superTypeSchema);
        } else if (node.has("extendsJavaClass")) {
            superType = TypeUtil.resolveType((JClassContainer)jPackage, node.get("extendsJavaClass").asText());
        }
        return superType;
    }

    private Schema getSuperSchema(JsonNode node, Schema schema, boolean followRefs) {
        if (node.has("extends")) {
            String path = schema.getId().getFragment() == null ? "#extends" : "#" + schema.getId().getFragment() + "/extends";
            Schema superSchema = this.ruleFactory.getSchemaStore().create(schema, path, this.ruleFactory.getGenerationConfig().getRefFragmentPathDelimiters());
            if (followRefs) {
                superSchema = this.resolveSchemaRefsRecursive(superSchema);
            }
            return superSchema;
        }
        return null;
    }

    private Schema resolveSchemaRefsRecursive(Schema schema) {
        JsonNode schemaNode = schema.getContent();
        if (schemaNode.has("$ref")) {
            schema = this.ruleFactory.getSchemaStore().create(schema, schemaNode.get("$ref").asText(), this.ruleFactory.getGenerationConfig().getRefFragmentPathDelimiters());
            return this.resolveSchemaRefsRecursive(schema);
        }
        return schema;
    }

    private void addJsonTypeInfoAnnotation(JDefinedClass jclass, JsonNode node) {
        if (this.ruleFactory.getGenerationConfig().getAnnotationStyle() == AnnotationStyle.JACKSON2) {
            String annotationName = node.get("deserializationClassProperty").asText();
            JAnnotationUse jsonTypeInfo = jclass.annotate(JsonTypeInfo.class);
            jsonTypeInfo.param("use", (Enum)JsonTypeInfo.Id.CLASS);
            jsonTypeInfo.param("include", (Enum)JsonTypeInfo.As.PROPERTY);
            jsonTypeInfo.param("property", annotationName);
        }
    }

    private void addToString(JDefinedClass jclass) {
        Map fields = jclass.fields();
        JMethod toString = jclass.method(1, String.class, "toString");
        HashSet<String> excludes = new HashSet<String>(Arrays.asList(this.ruleFactory.getGenerationConfig().getToStringExcludes()));
        JBlock body = toString.body();
        JClass stringBuilderClass = jclass.owner().ref(StringBuilder.class);
        JVar sb = body.decl((JType)stringBuilderClass, "sb", (JExpression)JExpr._new((JClass)stringBuilderClass));
        body.add((JStatement)sb.invoke("append").arg((JExpression)jclass.dotclass().invoke("getName")).invoke("append").arg(JExpr.lit((char)'@')).invoke("append").arg((JExpression)jclass.owner().ref(Integer.class).staticInvoke("toHexString").arg((JExpression)jclass.owner().ref(System.class).staticInvoke("identityHashCode").arg(JExpr._this()))).invoke("append").arg(JExpr.lit((char)'[')));
        if (!jclass._extends().fullName().equals(Object.class.getName())) {
            JVar baseLength = body.decl((JType)jclass.owner().INT, "baseLength", (JExpression)sb.invoke("length"));
            JVar superString = body.decl((JType)jclass.owner().ref(String.class), "superString", (JExpression)JExpr._super().invoke("toString"));
            JBlock superToStringBlock = body._if(superString.ne(JExpr._null()))._then();
            JVar contentStart = superToStringBlock.decl((JType)jclass.owner().INT, "contentStart", (JExpression)superString.invoke("indexOf").arg(JExpr.lit((char)'[')));
            JVar contentEnd = superToStringBlock.decl((JType)jclass.owner().INT, "contentEnd", (JExpression)superString.invoke("lastIndexOf").arg(JExpr.lit((char)']')));
            JConditional superToStringInnerConditional = superToStringBlock._if(contentStart.gte(JExpr.lit((int)0)).cand(contentEnd.gt((JExpression)contentStart)));
            superToStringInnerConditional._then().add((JStatement)sb.invoke("append").arg((JExpression)superString).arg(contentStart.plus(JExpr.lit((int)1))).arg((JExpression)contentEnd));
            superToStringInnerConditional._else().add((JStatement)sb.invoke("append").arg((JExpression)superString));
            body._if(sb.invoke("length").gt((JExpression)baseLength))._then().add((JStatement)sb.invoke("append").arg(JExpr.lit((char)',')));
        }
        for (JFieldVar fieldVar : fields.values()) {
            if (excludes.contains(fieldVar.name()) || (fieldVar.mods().getValue() & 0x10) == 16) continue;
            body.add((JStatement)sb.invoke("append").arg(fieldVar.name()));
            body.add((JStatement)sb.invoke("append").arg(JExpr.lit((char)'=')));
            if (fieldVar.type().isPrimitive()) {
                body.add((JStatement)sb.invoke("append").arg((JExpression)JExpr.refthis((String)fieldVar.name())));
            } else if (fieldVar.type().isArray()) {
                if (!fieldVar.type().elementType().isPrimitive()) {
                    throw new UnsupportedOperationException("Only primitive arrays are supported");
                }
                body.add((JStatement)sb.invoke("append").arg(JOp.cond((JExpression)JExpr.refthis((String)fieldVar.name()).eq(JExpr._null()), (JExpression)JExpr.lit((String)"<null>"), (JExpression)jclass.owner().ref(Arrays.class).staticInvoke("toString").arg((JExpression)JExpr.refthis((String)fieldVar.name())).invoke("replace").arg(JExpr.lit((char)'[')).arg(JExpr.lit((char)'{')).invoke("replace").arg(JExpr.lit((char)']')).arg(JExpr.lit((char)'}')).invoke("replace").arg(JExpr.lit((String)", ")).arg(JExpr.lit((String)",")))));
            } else {
                body.add((JStatement)sb.invoke("append").arg(JOp.cond((JExpression)JExpr.refthis((String)fieldVar.name()).eq(JExpr._null()), (JExpression)JExpr.lit((String)"<null>"), (JExpression)JExpr.refthis((String)fieldVar.name()))));
            }
            body.add((JStatement)sb.invoke("append").arg(JExpr.lit((char)',')));
        }
        JConditional trailerConditional = body._if(sb.invoke("charAt").arg(sb.invoke("length").minus(JExpr.lit((int)1))).eq(JExpr.lit((char)',')));
        trailerConditional._then().add((JStatement)sb.invoke("setCharAt").arg(sb.invoke("length").minus(JExpr.lit((int)1))).arg(JExpr.lit((char)']')));
        trailerConditional._else().add((JStatement)sb.invoke("append").arg(JExpr.lit((char)']')));
        body._return((JExpression)sb.invoke("toString"));
        toString.annotate(Override.class);
    }

    private void addHashCode(JDefinedClass jclass, JsonNode node) {
        Map<String, JFieldVar> fields = this.removeFieldsExcludedFromEqualsAndHashCode(jclass.fields(), node);
        JMethod hashCode = jclass.method(1, Integer.TYPE, "hashCode");
        JBlock body = hashCode.body();
        JVar result = body.decl((JType)jclass.owner().INT, "result", JExpr.lit((int)1));
        for (JFieldVar fieldVar : fields.values()) {
            Object fieldHash;
            if ((fieldVar.mods().getValue() & 0x10) == 16) continue;
            JFieldRef fieldRef = JExpr.refthis((String)fieldVar.name());
            if (fieldVar.type().isPrimitive()) {
                if ("long".equals(fieldVar.type().name())) {
                    fieldHash = JExpr.cast((JType)jclass.owner().INT, (JExpression)fieldRef.xor(fieldRef.shrz(JExpr.lit((int)32))));
                } else if ("boolean".equals(fieldVar.type().name())) {
                    fieldHash = JOp.cond((JExpression)fieldRef, (JExpression)JExpr.lit((int)1), (JExpression)JExpr.lit((int)0));
                } else if ("int".equals(fieldVar.type().name())) {
                    fieldHash = fieldRef;
                } else if ("double".equals(fieldVar.type().name())) {
                    JClass doubleClass = jclass.owner().ref(Double.class);
                    JInvocation longField = doubleClass.staticInvoke("doubleToLongBits").arg((JExpression)fieldRef);
                    fieldHash = JExpr.cast((JType)jclass.owner().INT, (JExpression)longField.xor(longField.shrz(JExpr.lit((int)32))));
                } else {
                    fieldHash = "float".equals(fieldVar.type().name()) ? jclass.owner().ref(Float.class).staticInvoke("floatToIntBits").arg((JExpression)fieldRef) : JExpr.cast((JType)jclass.owner().INT, (JExpression)fieldRef);
                }
            } else if (fieldVar.type().isArray()) {
                if (!fieldVar.type().elementType().isPrimitive()) {
                    throw new UnsupportedOperationException("Only primitive arrays are supported");
                }
                fieldHash = jclass.owner().ref(Arrays.class).staticInvoke("hashCode").arg((JExpression)fieldRef);
            } else {
                fieldHash = JOp.cond((JExpression)fieldRef.eq(JExpr._null()), (JExpression)JExpr.lit((int)0), (JExpression)fieldRef.invoke("hashCode"));
            }
            body.assign((JAssignmentTarget)result, result.mul(JExpr.lit((int)31)).plus(fieldHash));
        }
        if (!jclass._extends().fullName().equals(Object.class.getName())) {
            body.assign((JAssignmentTarget)result, result.mul(JExpr.lit((int)31)).plus((JExpression)JExpr._super().invoke("hashCode")));
        }
        body._return((JExpression)result);
        hashCode.annotate(Override.class);
    }

    private Map<String, JFieldVar> removeFieldsExcludedFromEqualsAndHashCode(Map<String, JFieldVar> fields, JsonNode node) {
        HashMap<String, JFieldVar> filteredFields = new HashMap<String, JFieldVar>(fields);
        JsonNode properties = node.get("properties");
        if (properties != null) {
            if (node.has("excludedFromEqualsAndHashCode")) {
                JsonNode excludedArray = node.get("excludedFromEqualsAndHashCode");
                Iterator iterator = excludedArray.elements();
                while (iterator.hasNext()) {
                    String excludedPropertyName = ((JsonNode)iterator.next()).asText();
                    JsonNode excludedPropertyNode = properties.get(excludedPropertyName);
                    filteredFields.remove(this.ruleFactory.getNameHelper().getPropertyName(excludedPropertyName, excludedPropertyNode));
                }
            }
            Iterator iterator = properties.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String propertyName = (String)entry.getKey();
                JsonNode propertyNode = (JsonNode)entry.getValue();
                if (!propertyNode.has("excludedFromEqualsAndHashCode") || !propertyNode.get("excludedFromEqualsAndHashCode").asBoolean()) continue;
                filteredFields.remove(this.ruleFactory.getNameHelper().getPropertyName(propertyName, propertyNode));
            }
        }
        return filteredFields;
    }

    private void addConstructors(JDefinedClass jclass, JsonNode node, Schema schema, boolean onlyRequired) {
        LinkedHashSet<String> classProperties = this.getConstructorProperties(node, onlyRequired);
        LinkedHashSet<String> combinedSuperProperties = this.getSuperTypeConstructorPropertiesRecursive(node, schema, onlyRequired);
        if (classProperties.isEmpty() && combinedSuperProperties.isEmpty()) {
            return;
        }
        JMethod noargsConstructor = jclass.constructor(1);
        noargsConstructor.javadoc().add((Object)"No args constructor for use in serialization");
        JMethod fieldsConstructor = jclass.constructor(1);
        JBlock constructorBody = fieldsConstructor.body();
        JInvocation superInvocation = constructorBody.invoke("super");
        Map fields = jclass.fields();
        HashMap<String, JVar> classFieldParams = new HashMap<String, JVar>();
        for (String property : classProperties) {
            JFieldVar field = (JFieldVar)fields.get(property);
            if (field == null) {
                throw new IllegalStateException("Property " + property + " hasn't been added to JDefinedClass before calling addConstructors");
            }
            fieldsConstructor.javadoc().addParam(property);
            JVar param = fieldsConstructor.param(field.type(), field.name());
            constructorBody.assign((JAssignmentTarget)JExpr._this().ref((JVar)field), (JExpression)param);
            classFieldParams.put(property, param);
        }
        ArrayList<JVar> superConstructorParams = new ArrayList<JVar>();
        for (String property : combinedSuperProperties) {
            JFieldVar field = this.searchSuperClassesForField(property, jclass);
            if (field == null) {
                throw new IllegalStateException("Property " + property + " hasn't been added to JDefinedClass before calling addConstructors");
            }
            JVar param = (JVar)classFieldParams.get(property);
            if (param == null) {
                param = fieldsConstructor.param(field.type(), field.name());
            }
            fieldsConstructor.javadoc().addParam(property);
            superConstructorParams.add(param);
        }
        for (JVar param : superConstructorParams) {
            superInvocation.arg((JExpression)param);
        }
    }

    private static JDefinedClass definedClassOrNullFromType(JType type) {
        if (type == null || type.isPrimitive()) {
            return null;
        }
        JClass fieldClass = type.boxify();
        JPackage jPackage = fieldClass._package();
        return jPackage._getClass(fieldClass.name());
    }

    private JFieldVar searchSuperClassesForField(String property, JDefinedClass jclass) {
        JClass superClass = jclass._extends();
        JDefinedClass definedSuperClass = ObjectRule.definedClassOrNullFromType((JType)superClass);
        if (definedSuperClass == null) {
            return null;
        }
        return this.searchClassAndSuperClassesForField(property, definedSuperClass);
    }

    private JFieldVar searchClassAndSuperClassesForField(String property, JDefinedClass jclass) {
        Map fields = jclass.fields();
        JFieldVar field = (JFieldVar)fields.get(property);
        if (field == null) {
            return this.searchSuperClassesForField(property, jclass);
        }
        return field;
    }

    private void addEquals(JDefinedClass jclass, JsonNode node) {
        Map<String, JFieldVar> fields = this.removeFieldsExcludedFromEqualsAndHashCode(jclass.fields(), node);
        JMethod equals = jclass.method(1, Boolean.TYPE, "equals");
        JVar otherObject = equals.param(Object.class, "other");
        JBlock body = equals.body();
        body._if(otherObject.eq(JExpr._this()))._then()._return(JExpr.TRUE);
        body._if(otherObject._instanceof((JType)jclass).eq(JExpr.FALSE))._then()._return(JExpr.FALSE);
        JVar rhsVar = body.decl((JType)jclass, "rhs").init((JExpression)JExpr.cast((JType)jclass, (JExpression)otherObject));
        JExpression result = JExpr.lit((boolean)true);
        if (!jclass._extends().fullName().equals(Object.class.getName())) {
            result = result.cand((JExpression)JExpr._super().invoke("equals").arg((JExpression)rhsVar));
        }
        for (JFieldVar fieldVar : fields.values()) {
            JExpression fieldEquals;
            if ((fieldVar.mods().getValue() & 0x10) == 16) continue;
            JFieldRef thisFieldRef = JExpr.refthis((String)fieldVar.name());
            JFieldRef otherFieldRef = JExpr.ref((JExpression)rhsVar, (String)fieldVar.name());
            if (fieldVar.type().isPrimitive()) {
                if ("double".equals(fieldVar.type().name())) {
                    JClass doubleClass = jclass.owner().ref(Double.class);
                    fieldEquals = doubleClass.staticInvoke("doubleToLongBits").arg((JExpression)thisFieldRef).eq((JExpression)doubleClass.staticInvoke("doubleToLongBits").arg((JExpression)otherFieldRef));
                } else if ("float".equals(fieldVar.type().name())) {
                    JClass floatClass = jclass.owner().ref(Float.class);
                    fieldEquals = floatClass.staticInvoke("floatToIntBits").arg((JExpression)thisFieldRef).eq((JExpression)floatClass.staticInvoke("floatToIntBits").arg((JExpression)otherFieldRef));
                } else {
                    fieldEquals = thisFieldRef.eq((JExpression)otherFieldRef);
                }
            } else if (fieldVar.type().isArray()) {
                if (!fieldVar.type().elementType().isPrimitive()) {
                    throw new UnsupportedOperationException("Only primitive arrays are supported");
                }
                fieldEquals = jclass.owner().ref(Arrays.class).staticInvoke("equals").arg((JExpression)thisFieldRef).arg((JExpression)otherFieldRef);
            } else {
                fieldEquals = thisFieldRef.eq((JExpression)otherFieldRef).cor(thisFieldRef.ne(JExpr._null()).cand((JExpression)thisFieldRef.invoke("equals").arg((JExpression)otherFieldRef)));
            }
            result = result.cand(fieldEquals);
        }
        body._return(result);
        equals.annotate(Override.class);
    }

    private void addInterfaces(JDefinedClass jclass, JsonNode javaInterfaces) {
        for (JsonNode i : javaInterfaces) {
            jclass._implements(TypeUtil.resolveType((JClassContainer)jclass._package(), i.asText()));
        }
    }

    private String getClassName(String nodeName, JsonNode node, JPackage _package) {
        String prefix = this.ruleFactory.getGenerationConfig().getClassNamePrefix();
        String suffix = this.ruleFactory.getGenerationConfig().getClassNameSuffix();
        String fieldName = this.ruleFactory.getNameHelper().getFieldName(nodeName, node);
        String capitalizedFieldName = StringUtils.capitalize((String)fieldName);
        String fullFieldName = this.createFullFieldName(capitalizedFieldName, prefix, suffix);
        String className = this.ruleFactory.getNameHelper().replaceIllegalCharacters(fullFieldName);
        String normalizedName = this.ruleFactory.getNameHelper().normalizeName(className);
        return this.makeUnique(normalizedName, _package);
    }

    private String createFullFieldName(String nodeName, String prefix, String suffix) {
        String returnString = nodeName;
        if (prefix != null) {
            returnString = prefix + returnString;
        }
        if (suffix != null) {
            returnString = returnString + suffix;
        }
        return returnString;
    }

    private String makeUnique(String className, JPackage _package) {
        try {
            JDefinedClass _class = _package._class(className);
            _package.remove((JClass)_class);
            return className;
        }
        catch (JClassAlreadyExistsException e) {
            return this.makeUnique(MakeUniqueClassName.makeUnique(className), _package);
        }
    }

    private boolean usesPolymorphicDeserialization(JsonNode node) {
        if (this.ruleFactory.getGenerationConfig().getAnnotationStyle() == AnnotationStyle.JACKSON2) {
            return node.has("deserializationClassProperty");
        }
        return false;
    }
}

