/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.kie.api.io.Resource;
import org.kie.dmn.api.core.DMNCompiler;
import org.kie.dmn.api.core.DMNCompilerConfiguration;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.api.marshalling.v1_1.DMNExtensionRegister;
import org.kie.dmn.backend.marshalling.v1_1.DMNMarshallerFactory;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.ast.BusinessKnowledgeModelNodeImpl;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.ast.DecisionNodeImpl;
import org.kie.dmn.core.ast.ItemDefNodeImpl;
import org.kie.dmn.core.compiler.BusinessKnowledgeModelCompiler;
import org.kie.dmn.core.compiler.DMNCompilerConfigurationImpl;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNCompilerHelper;
import org.kie.dmn.core.compiler.DMNEvaluatorCompiler;
import org.kie.dmn.core.compiler.DMNFEELHelper;
import org.kie.dmn.core.compiler.DMNTypeRegistry;
import org.kie.dmn.core.compiler.DRGElementCompiler;
import org.kie.dmn.core.compiler.DecisionCompiler;
import org.kie.dmn.core.compiler.InputDataCompiler;
import org.kie.dmn.core.compiler.ItemDefinitionDependenciesSorter;
import org.kie.dmn.core.compiler.KnowledgeSourceCompiler;
import org.kie.dmn.core.compiler.RuntimeTypeCheckOption;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.model.v1_1.DMNElement;
import org.kie.dmn.model.v1_1.DMNElementReference;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.DRGElement;
import org.kie.dmn.model.v1_1.Decision;
import org.kie.dmn.model.v1_1.DecisionTable;
import org.kie.dmn.model.v1_1.Definitions;
import org.kie.dmn.model.v1_1.InformationRequirement;
import org.kie.dmn.model.v1_1.ItemDefinition;
import org.kie.dmn.model.v1_1.KnowledgeRequirement;
import org.kie.dmn.model.v1_1.NamedElement;
import org.kie.dmn.model.v1_1.OutputClause;
import org.kie.dmn.model.v1_1.UnaryTests;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNCompilerImpl
implements DMNCompiler {
    private static final Logger logger = LoggerFactory.getLogger(DMNCompilerImpl.class);
    private final DMNEvaluatorCompiler evaluatorCompiler;
    private final DMNFEELHelper feel;
    private DMNCompilerConfiguration dmnCompilerConfig;
    private Deque<DRGElementCompiler> drgCompilers = new LinkedList<DRGElementCompiler>();

    public DMNCompilerImpl() {
        this(DMNFactory.newCompilerConfiguration());
    }

    public DMNCompilerImpl(DMNCompilerConfiguration dmnCompilerConfig) {
        this.drgCompilers.add(new InputDataCompiler());
        this.drgCompilers.add(new BusinessKnowledgeModelCompiler());
        this.drgCompilers.add(new DecisionCompiler());
        this.drgCompilers.add(new KnowledgeSourceCompiler());
        this.dmnCompilerConfig = dmnCompilerConfig;
        DMNCompilerConfigurationImpl cc = (DMNCompilerConfigurationImpl)dmnCompilerConfig;
        this.addDRGElementCompilers(cc.getDRGElementCompilers());
        this.feel = new DMNFEELHelper(cc.getFeelProfiles());
        this.evaluatorCompiler = new DMNEvaluatorCompiler(this, this.feel);
    }

    private void addDRGElementCompiler(DRGElementCompiler compiler) {
        this.drgCompilers.push(compiler);
    }

    private void addDRGElementCompilers(List<DRGElementCompiler> compilers) {
        ListIterator<DRGElementCompiler> listIterator = compilers.listIterator(compilers.size());
        while (listIterator.hasPrevious()) {
            this.addDRGElementCompiler(listIterator.previous());
        }
    }

    public DMNModel compile(Resource resource) {
        try {
            DMNModel model = this.compile(resource.getReader());
            if (model == null) {
                return null;
            }
            ((DMNModelImpl)model).setResource(resource);
            return model;
        }
        catch (IOException e) {
            logger.error("Error retrieving reader for resource: " + resource.getSourcePath(), (Throwable)e);
            return null;
        }
    }

    public DMNModel compile(Reader source) {
        try {
            Definitions dmndefs = null;
            dmndefs = this.dmnCompilerConfig != null && !this.dmnCompilerConfig.getRegisteredExtensions().isEmpty() ? DMNMarshallerFactory.newMarshallerWithExtensions((List)this.getDmnCompilerConfig().getRegisteredExtensions()).unmarshal(source) : DMNMarshallerFactory.newDefaultMarshaller().unmarshal(source);
            DMNModel model = this.compile(dmndefs);
            return model;
        }
        catch (Exception e) {
            logger.error("Error compiling model from source.", (Throwable)e);
            return null;
        }
    }

    public DMNModel compile(Definitions dmndefs) {
        DMNModelImpl model = null;
        if (dmndefs != null) {
            model = new DMNModelImpl(dmndefs);
            model.setRuntimeTypeCheck(((DMNCompilerConfigurationImpl)this.dmnCompilerConfig).getOption(RuntimeTypeCheckOption.class).isRuntimeTypeCheck());
            DMNCompilerContext ctx = new DMNCompilerContext();
            this.processItemDefinitions(ctx, this.feel, model, dmndefs);
            this.processDrgElements(ctx, this.feel, model, dmndefs);
            return model;
        }
        return model;
    }

    private void processItemDefinitions(DMNCompilerContext ctx, DMNFEELHelper feel, DMNModelImpl model, Definitions dmndefs) {
        dmndefs.getItemDefinition().stream().forEach(x -> this.processItemDefQNameURIs((ItemDefinition)x));
        List<ItemDefinition> ordered = new ItemDefinitionDependenciesSorter(model.getNamespace()).sort(dmndefs.getItemDefinition());
        for (ItemDefinition id : ordered) {
            ItemDefNodeImpl idn = new ItemDefNodeImpl(id);
            DMNType type = this.buildTypeDef(ctx, feel, model, idn, id, true);
            idn.setType(type);
            model.addItemDefinition(idn);
        }
    }

    private void processItemDefQNameURIs(ItemDefinition id) {
        QName typeRef = id.getTypeRef();
        if (typeRef != null && "".equals(typeRef.getNamespaceURI())) {
            String actualNS = id.getNamespaceURI(typeRef.getPrefix());
            id.setTypeRef(new QName(actualNS, typeRef.getLocalPart(), typeRef.getPrefix()));
        }
        for (ItemDefinition ic : id.getItemComponent()) {
            this.processItemDefQNameURIs(ic);
        }
    }

    private void processDrgElements(DMNCompilerContext ctx, DMNFEELHelper feel, DMNModelImpl model, Definitions dmndefs) {
        for (DRGElement e : dmndefs.getDrgElement()) {
            boolean foundIt = false;
            for (DRGElementCompiler dc : this.drgCompilers) {
                if (!dc.accept(e)) continue;
                foundIt = true;
                dc.compileNode(e, this, model);
            }
            if (foundIt) continue;
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)e, model, null, null, Msg.UNSUPPORTED_ELEMENT, e.getClass().getSimpleName(), e.getId());
        }
        for (BusinessKnowledgeModelNode bkm : model.getBusinessKnowledgeModels()) {
            BusinessKnowledgeModelNodeImpl bkmi = (BusinessKnowledgeModelNodeImpl)bkm;
            for (DRGElementCompiler dc : this.drgCompilers) {
                if (bkmi.getEvaluator() != null || !dc.accept((DMNNode)bkm)) continue;
                dc.compileEvaluator((DMNNode)bkm, this, ctx, model);
            }
        }
        for (DecisionNode d : model.getDecisions()) {
            DecisionNodeImpl di = (DecisionNodeImpl)d;
            for (DRGElementCompiler dc : this.drgCompilers) {
                if (di.getEvaluator() != null || !dc.accept((DMNNode)d)) continue;
                dc.compileEvaluator((DMNNode)d, this, ctx, model);
            }
        }
        this.detectCycles(model);
    }

    private void detectCycles(DMNModelImpl model) {
        HashMap<DecisionNodeImpl, Boolean> registry = new HashMap<DecisionNodeImpl, Boolean>();
        for (DecisionNode decision : model.getDecisions()) {
            DecisionNodeImpl decisionNode = (DecisionNodeImpl)decision;
            this.detectCycles(decisionNode, registry, model);
        }
    }

    private void detectCycles(DecisionNodeImpl node, Map<DecisionNodeImpl, Boolean> registry, DMNModelImpl model) {
        if (Boolean.TRUE.equals(registry.get(node))) {
            return;
        }
        if (Boolean.FALSE.equals(registry.put(node, Boolean.FALSE))) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)node.getSource(), model, null, null, Msg.CYCLIC_DEP_FOR_NODE, node.getName());
            registry.put(node, Boolean.TRUE);
        }
        for (DMNNode dependency : node.getDependencies().values()) {
            if (!(dependency instanceof DecisionNodeImpl)) continue;
            this.detectCycles((DecisionNodeImpl)dependency, registry, model);
        }
        registry.put(node, Boolean.TRUE);
    }

    public void linkRequirements(DMNModelImpl model, DMNBaseNode node) {
        String id;
        for (InformationRequirement ir : node.getInformationRequirement()) {
            if (ir.getRequiredInput() != null) {
                id = this.getId(ir.getRequiredInput());
                InputDataNode input = model.getInputById(id);
                if (input != null) {
                    node.addDependency(input.getName(), (DMNNode)input);
                    continue;
                }
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)ir.getRequiredInput(), model, null, null, Msg.REQ_INPUT_NOT_FOUND_FOR_NODE, id, node.getName());
                continue;
            }
            if (ir.getRequiredDecision() == null) continue;
            id = this.getId(ir.getRequiredDecision());
            DecisionNode dn = model.getDecisionById(id);
            if (dn != null) {
                node.addDependency(dn.getName(), (DMNNode)dn);
                continue;
            }
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)ir.getRequiredDecision(), model, null, null, Msg.REQ_DECISION_NOT_FOUND_FOR_NODE, id, node.getName());
        }
        for (KnowledgeRequirement kr : node.getKnowledgeRequirement()) {
            if (kr.getRequiredKnowledge() == null) continue;
            id = this.getId(kr.getRequiredKnowledge());
            BusinessKnowledgeModelNode bkmn = model.getBusinessKnowledgeModelById(id);
            if (bkmn != null) {
                node.addDependency(bkmn.getName(), (DMNNode)bkmn);
                continue;
            }
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)kr.getRequiredKnowledge(), model, null, null, Msg.REQ_BKM_NOT_FOUND_FOR_NODE, id, node.getName());
        }
    }

    private String getId(DMNElementReference er) {
        String href = er.getHref();
        return href.contains("#") ? href.substring(href.indexOf(35) + 1) : href;
    }

    private DMNType buildTypeDef(DMNCompilerContext ctx, DMNFEELHelper feel, DMNModelImpl dmnModel, DMNNode node, ItemDefinition itemDef, boolean topLevel) {
        BaseDMNTypeImpl type = null;
        if (itemDef.getTypeRef() != null) {
            type = (BaseDMNTypeImpl)this.resolveTypeRef(dmnModel, node, (NamedElement)itemDef, (DMNModelInstrumentedBase)itemDef, itemDef.getTypeRef());
            if (type != null) {
                DMNType registered;
                UnaryTests allowedValuesStr = itemDef.getAllowedValues();
                if (topLevel || allowedValuesStr != null || itemDef.isIsCollection() != type.isCollection()) {
                    BaseDMNTypeImpl baseType = type;
                    type = type.clone();
                    type.setBaseType(baseType);
                    type.setNamespace(dmnModel.getNamespace());
                    type.setName(itemDef.getName());
                    type.setAllowedValues(null);
                    if (allowedValuesStr != null) {
                        List<UnaryTest> av = feel.evaluateUnaryTests(ctx, allowedValuesStr.getText(), dmnModel, (DMNElement)itemDef, Msg.ERR_COMPILING_ALLOWED_VALUES_LIST_ON_ITEM_DEF, allowedValuesStr.getText(), node.getName());
                        type.setAllowedValues(av);
                    }
                    if (itemDef.isIsCollection()) {
                        type.setCollection(itemDef.isIsCollection());
                    }
                }
                if (topLevel && (registered = dmnModel.getTypeRegistry().registerType(type)) != type) {
                    MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)itemDef, dmnModel, null, null, Msg.DUPLICATED_ITEM_DEFINITION, itemDef.getName());
                }
            }
        } else {
            DMNCompilerHelper.checkVariableName(dmnModel, (NamedElement)itemDef, itemDef.getName());
            CompositeTypeImpl compType = new CompositeTypeImpl(dmnModel.getNamespace(), itemDef.getName(), itemDef.getId(), itemDef.isIsCollection());
            DMNType registered = itemDef.getItemComponent().iterator();
            while (registered.hasNext()) {
                ItemDefinition fieldDef = (ItemDefinition)registered.next();
                DMNCompilerHelper.checkVariableName(dmnModel, (NamedElement)fieldDef, fieldDef.getName());
                DMNType fieldType = this.buildTypeDef(ctx, feel, dmnModel, node, fieldDef, false);
                fieldType = fieldType != null ? fieldType : DMNTypeRegistry.UNKNOWN;
                compType.addField(fieldDef.getName(), fieldType);
            }
            type = compType;
            if (topLevel && (registered = dmnModel.getTypeRegistry().registerType(type)) != type) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)itemDef, dmnModel, null, null, Msg.DUPLICATED_ITEM_DEFINITION, itemDef.getName());
            }
        }
        return type;
    }

    public DMNType resolveTypeRef(DMNModelImpl dmnModel, DMNNode node, NamedElement model, DMNModelInstrumentedBase localElement, QName typeRef) {
        if (typeRef != null) {
            String namespace = this.getNamespace(localElement, typeRef);
            DMNType type = dmnModel.getTypeRegistry().resolveType(namespace, typeRef.getLocalPart());
            if (type == null && "http://www.omg.org/spec/FEEL/20140401".equals(namespace)) {
                if (model instanceof Decision && ((Decision)model).getExpression() instanceof DecisionTable) {
                    DecisionTable dt = (DecisionTable)((Decision)model).getExpression();
                    if (dt.getOutput().size() > 1) {
                        CompositeTypeImpl compType = new CompositeTypeImpl(dmnModel.getNamespace(), model.getName() + "_Type", model.getId(), dt.getHitPolicy().isMultiHit());
                        for (OutputClause oc : dt.getOutput()) {
                            DMNType fieldType = this.resolveTypeRef(dmnModel, node, model, (DMNModelInstrumentedBase)oc, oc.getTypeRef());
                            compType.addField(oc.getName(), fieldType);
                        }
                        dmnModel.getTypeRegistry().registerType(compType);
                        return compType;
                    }
                    if (dt.getOutput().size() == 1) {
                        return this.resolveTypeRef(dmnModel, node, model, (DMNModelInstrumentedBase)dt.getOutput().get(0), ((OutputClause)dt.getOutput().get(0)).getTypeRef());
                    }
                }
            } else if (type == null) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, localElement, dmnModel, null, null, Msg.UNKNOWN_TYPE_REF_ON_NODE, typeRef.toString(), localElement.getParentDRDElement().getIdentifierString());
            }
            return type;
        }
        return dmnModel.getTypeRegistry().resolveType("http://www.omg.org/spec/FEEL/20140401", BuiltInType.UNKNOWN.getName());
    }

    private String getNamespace(DMNModelInstrumentedBase localElement, QName typeRef) {
        String prefix = typeRef.getPrefix();
        return localElement.getNamespaceURI(prefix);
    }

    public DMNCompilerConfiguration getDmnCompilerConfig() {
        return this.dmnCompilerConfig;
    }

    public List<DMNExtensionRegister> getRegisteredExtensions() {
        if (this.dmnCompilerConfig == null) {
            return Collections.emptyList();
        }
        return this.dmnCompilerConfig.getRegisteredExtensions();
    }

    public DMNEvaluatorCompiler getEvaluatorCompiler() {
        return this.evaluatorCompiler;
    }
}

