/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.ast;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.antlr.v4.runtime.ParserRuleContext;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.ast.BaseNode;
import org.kie.dmn.feel.lang.ast.IterationContextNode;
import org.kie.dmn.feel.lang.ast.ListNode;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.util.Msg;

public class ForExpressionNode
extends BaseNode {
    private List<IterationContextNode> iterationContexts = new ArrayList<IterationContextNode>();
    private BaseNode expression;

    public ForExpressionNode(ParserRuleContext ctx, ListNode iterationContexts, BaseNode expression) {
        super(ctx);
        this.expression = expression;
        for (BaseNode n : iterationContexts.getElements()) {
            this.iterationContexts.add((IterationContextNode)n);
        }
    }

    public List<IterationContextNode> getIterationContexts() {
        return this.iterationContexts;
    }

    public void setIterationContexts(List<IterationContextNode> iterationContexts) {
        this.iterationContexts = iterationContexts;
    }

    public BaseNode getExpression() {
        return this.expression;
    }

    public void setExpression(BaseNode expression) {
        this.expression = expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(EvaluationContext ctx) {
        try {
            ctx.enterFrame();
            ArrayList<Object> results = new ArrayList<Object>();
            ctx.setValue("partial", results);
            ForIteration[] ictx = this.initializeContexts(ctx, this.iterationContexts);
            while (this.nextIteration(ctx, ictx)) {
                Object result = this.expression.evaluate(ctx);
                results.add(result);
            }
            ArrayList<Object> arrayList = results;
            return arrayList;
        }
        catch (EndpointOfRangeNotOfNumberException e) {
            Object var3_5 = null;
            return var3_5;
        }
        finally {
            ctx.exitFrame();
        }
    }

    private boolean nextIteration(EvaluationContext ctx, ForIteration[] ictx) {
        int i = ictx.length - 1;
        while (i >= 0 && i < ictx.length) {
            if (ictx[i].hasNextValue()) {
                this.setValueIntoContext(ctx, ictx[i]);
                ++i;
                continue;
            }
            --i;
        }
        return i >= 0;
    }

    private void setValueIntoContext(EvaluationContext ctx, ForIteration forIteration) {
        ctx.setValue(forIteration.getName(), forIteration.getNextValue());
    }

    @Override
    public Type getResultType() {
        return BuiltInType.LIST;
    }

    private ForIteration[] initializeContexts(EvaluationContext ctx, List<IterationContextNode> iterationContexts) {
        ForIteration[] ictx = new ForIteration[iterationContexts.size()];
        int i = 0;
        for (IterationContextNode icn : iterationContexts) {
            ictx[i] = this.createQuantifiedExpressionIterationContext(ctx, icn);
            if (i < iterationContexts.size() - 1 && ictx[i].hasNextValue()) {
                this.setValueIntoContext(ctx, ictx[i]);
            }
            ++i;
        }
        return ictx;
    }

    private ForIteration createQuantifiedExpressionIterationContext(EvaluationContext ctx, IterationContextNode icn) {
        ForIteration fi = null;
        String name = icn.evaluateName(ctx);
        Object result = icn.evaluate(ctx);
        Object rangeEnd = icn.evaluateRangeEnd(ctx);
        if (rangeEnd == null) {
            List<Object> values = result instanceof Iterable ? (List<Object>)result : Collections.singletonList(result);
            fi = new ForIteration(name, values);
        } else {
            this.valueMustBeANumber(ctx, result);
            BigDecimal start = (BigDecimal)result;
            this.valueMustBeANumber(ctx, rangeEnd);
            BigDecimal end = (BigDecimal)rangeEnd;
            fi = new ForIteration(name, start, end);
        }
        return fi;
    }

    private void valueMustBeANumber(EvaluationContext ctx, Object value) {
        if (!(value instanceof BigDecimal)) {
            ctx.notifyEvt(this.astEvent(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.VALUE_X_NOT_A_VALID_ENDPOINT_FOR_RANGE_BECAUSE_NOT_A_NUMBER, value), null));
            throw new EndpointOfRangeNotOfNumberException();
        }
    }

    public static class BigDecimalRangeIterator
    implements Iterator<BigDecimal> {
        private final BigDecimal start;
        private final BigDecimal end;
        private BigDecimal cursor;
        private final Direction direction;
        private final BigDecimal increment;

        public BigDecimalRangeIterator(BigDecimal start, BigDecimal end) {
            this.start = start;
            this.end = end;
            this.direction = start.compareTo(end) <= 0 ? Direction.ASCENDANT : Direction.DESCENDANT;
            this.increment = this.direction == Direction.ASCENDANT ? new BigDecimal(1, MathContext.DECIMAL128) : new BigDecimal(-1, MathContext.DECIMAL128);
        }

        @Override
        public boolean hasNext() {
            if (this.cursor == null) {
                return true;
            }
            BigDecimal lookAhead = this.cursor.add(this.increment);
            if (this.direction == Direction.ASCENDANT) {
                return lookAhead.compareTo(this.end) <= 0;
            }
            return lookAhead.compareTo(this.end) >= 0;
        }

        @Override
        public BigDecimal next() {
            this.cursor = this.cursor == null ? this.start : this.cursor.add(this.increment);
            return this.cursor;
        }

        private static enum Direction {
            ASCENDANT,
            DESCENDANT;

        }
    }

    private static class ForIteration {
        private String name;
        private Iterable values;
        private Supplier<Iterator> iteratorGenerator;
        private Iterator iterator;

        public ForIteration(String name, Iterable values) {
            this.name = name;
            this.values = values;
            this.iteratorGenerator = () -> this.values.iterator();
        }

        public ForIteration(String name, BigDecimal start, BigDecimal end) {
            this.name = name;
            this.iteratorGenerator = () -> new BigDecimalRangeIterator(start, end);
        }

        public boolean hasNextValue() {
            boolean hasValue;
            if (this.iterator == null) {
                this.iterator = this.iteratorGenerator.get();
            }
            if (!(hasValue = this.iterator.hasNext())) {
                this.iterator = null;
            }
            return hasValue;
        }

        public Object getNextValue() {
            return this.iterator != null ? this.iterator.next() : null;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class EndpointOfRangeNotOfNumberException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private EndpointOfRangeNotOfNumberException() {
        }
    }
}

