/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.lang.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.dmn.feel.lang.CompositeType;
import org.kie.dmn.feel.lang.FEELProperty;
import org.kie.dmn.feel.lang.FEELType;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.parser.feel11.ParserHelper;
import org.kie.dmn.feel.util.EvalHelper;

public class JavaBackedType
implements CompositeType {
    private static Map<Class<?>, JavaBackedType> cache = new ConcurrentHashMap();
    private static Set<Method> javaObjectMethods = Collections.unmodifiableSet(new HashSet<Method>(Arrays.asList(Object.class.getMethods())));
    private Class<?> wrapped;
    private Map<String, Type> properties;

    private JavaBackedType(Class<?> class1) {
        this.wrapped = class1;
    }

    private static Optional<String> methodToCustomProperty(Method m) {
        return Optional.ofNullable(m.getAnnotation(FEELProperty.class)).map(a -> a.value());
    }

    public static Type of(Class<?> clazz) {
        return Optional.ofNullable((Type)cache.computeIfAbsent(clazz, JavaBackedType::createIfAnnotated)).orElse(BuiltInType.UNKNOWN);
    }

    private static JavaBackedType createIfAnnotated(Class<?> clazz) {
        if (clazz.isAnnotationPresent(FEELType.class) || Stream.of(clazz.getMethods()).anyMatch(m -> m.getAnnotation(FEELProperty.class) != null)) {
            return new JavaBackedType(clazz);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.wrapped.getName();
    }

    public Class<?> getWrapped() {
        return this.wrapped;
    }

    @Override
    public Map<String, Type> getFields() {
        if (this.properties == null) {
            this.properties = Stream.of(this.wrapped.getMethods()).filter(m -> Modifier.isPublic(m.getModifiers()) || Modifier.isProtected(m.getModifiers())).filter(m -> !javaObjectMethods.contains(m)).flatMap(m -> Stream.of(JavaBackedType::methodToCustomProperty, EvalHelper::propertyFromAccessor).map(f -> (Optional)f.apply(m)).filter(Optional::isPresent).map(p -> new Property((String)p.get(), ParserHelper.determineTypeFromClass(m.getReturnType())))).collect(Collectors.toMap(p -> p.name, p -> p.type, (p1, p2) -> {
                throw new IllegalArgumentException();
            }, LinkedHashMap::new));
        }
        return this.properties;
    }

    @Override
    public boolean isInstanceOf(Object o) {
        return this.wrapped.getClass().isInstance(o);
    }

    @Override
    public boolean isAssignableValue(Object value) {
        return value == null || this.wrapped.getClass().isAssignableFrom(value.getClass());
    }

    private static class Property {
        public final String name;
        public final Type type;

        public Property(String name, Type type) {
            this.name = name;
            this.type = type;
        }
    }
}

