/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.CompiledExpression;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.runtime.Range;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.runtime.decisiontables.DTDecisionRule;
import org.kie.dmn.feel.runtime.decisiontables.DTInputClause;
import org.kie.dmn.feel.runtime.decisiontables.DTOutputClause;
import org.kie.dmn.feel.runtime.decisiontables.DecisionTableImpl;
import org.kie.dmn.feel.runtime.decisiontables.HitPolicy;
import org.kie.dmn.feel.runtime.events.FEELEventBase;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.DTInvokerFunction;
import org.kie.dmn.feel.runtime.functions.ParameterName;
import org.kie.dmn.feel.util.Msg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionTableFunction
extends BaseFEELFunction {
    private static final Logger LOG = LoggerFactory.getLogger(DecisionTableFunction.class);

    public DecisionTableFunction() {
        super("decision table");
    }

    public Object invoke(@ParameterName(value="ctx") EvaluationContext ctx, @ParameterName(value="outputs") Object outputs, @ParameterName(value="input expression list") Object inputExpressionList, @ParameterName(value="input values list") List<?> inputValuesList, @ParameterName(value="output values") Object outputValues, @ParameterName(value="rule list") List<List> ruleList, @ParameterName(value="hit policy") String hitPolicy, @ParameterName(value="default output value") Object defaultOutputValue) {
        ArrayList<DTOutputClause> outputClauses;
        List<String> parseOutputs;
        List<DTInputClause> inputs;
        List<String> inputExpressions;
        List<String> list = inputExpressions = inputExpressionList instanceof List ? (List<String>)inputExpressionList : Collections.singletonList((String)inputExpressionList);
        if (inputValuesList != null) {
            List inputValues = inputValuesList.stream().map(o -> DecisionTableFunction.toUnaryTest(ctx, o)).collect(Collectors.toList());
            if (inputValues.size() != inputExpressions.size()) {
                // empty if block
            }
            inputs = IntStream.range(0, inputExpressions.size()).mapToObj(i -> new DTInputClause((String)inputExpressions.get(i), inputValuesList.toString(), Collections.singletonList(inputValues.get(i)), null)).collect(Collectors.toList());
        } else {
            inputs = inputExpressions.stream().map(ie -> new DTInputClause((String)ie, null, null, null)).collect(Collectors.toList());
        }
        List<String> list2 = parseOutputs = outputs instanceof List ? (List<String>)outputs : Collections.singletonList((String)outputs);
        if (outputValues != null) {
            if (parseOutputs.size() == 1) {
                outputClauses = new ArrayList();
                List<UnaryTest> outputValuesCompiled = this.objectToUnaryTestList(ctx, Collections.singletonList((List)outputValues)).get(0);
                outputClauses.add(new DTOutputClause(parseOutputs.get(0), outputValuesCompiled));
            } else {
                List<List<UnaryTest>> listOfList = this.objectToUnaryTestList(ctx, (List)outputValues);
                outputClauses = IntStream.range(0, parseOutputs.size()).mapToObj(i -> new DTOutputClause((String)parseOutputs.get(i), (List)listOfList.get(i))).collect(Collectors.toList());
            }
        } else {
            outputClauses = parseOutputs.stream().map(out -> new DTOutputClause((String)out, null)).collect(Collectors.toList());
        }
        FEEL feel = FEEL.newInstance();
        List<DTDecisionRule> decisionRules = IntStream.range(0, ruleList.size()).mapToObj(index -> DecisionTableFunction.toDecisionRule(ctx, feel, index, (List)ruleList.get(index), inputExpressions.size())).collect(Collectors.toList());
        DecisionTableImpl dti = new DecisionTableImpl(UUID.randomUUID().toString(), inputExpressions, inputs, outputClauses, decisionRules, HitPolicy.fromString(hitPolicy), FEEL.newInstance());
        return new DTInvokerFunction(dti);
    }

    protected List<List<UnaryTest>> objectToUnaryTestList(EvaluationContext ctx, List<List<Object>> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<UnaryTest>> tests = new ArrayList<List<UnaryTest>>();
        for (List<Object> lo : values) {
            ArrayList<UnaryTest> uts = new ArrayList<UnaryTest>();
            tests.add(uts);
            for (Object t : lo) {
                uts.add(DecisionTableFunction.toUnaryTest(ctx, t));
            }
        }
        return tests;
    }

    private static DTDecisionRule toDecisionRule(EvaluationContext mainCtx, FEEL embeddedFEEL, int index, List<?> rule, int inputSize) {
        DTDecisionRule dr = new DTDecisionRule(index);
        for (int i = 0; i < rule.size(); ++i) {
            Object o = rule.get(i);
            if (i < inputSize) {
                dr.getInputEntry().add(DecisionTableFunction.toUnaryTest(mainCtx, o));
                continue;
            }
            FEELEventListener ruleListener = event -> mainCtx.notifyEvt(() -> new FEELEventBase(event.getSeverity(), Msg.createMessage(Msg.ERROR_COMPILE_EXPR_DT_FUNCTION_RULE_IDX, index + 1, event.getMessage()), event.getSourceException()));
            embeddedFEEL.addListener(ruleListener);
            CompiledExpression compiledExpression = embeddedFEEL.compile((String)o, embeddedFEEL.newCompilerContext());
            dr.getOutputEntry().add(compiledExpression);
            embeddedFEEL.removeListener(ruleListener);
        }
        return dr;
    }

    private static UnaryTest toUnaryTest(EvaluationContext ctx, Object o) {
        if (o instanceof UnaryTest) {
            return (UnaryTest)o;
        }
        if (o instanceof Range) {
            return (c, x) -> {
                try {
                    return ((Range)o).includes(x);
                }
                catch (Exception e) {
                    ctx.notifyEvt(() -> new FEELEventBase(FEELEvent.Severity.ERROR, Msg.createMessage(Msg.EXPRESSION_IS_RANGE_BUT_VALUE_IS_NOT_COMPARABLE, o.toString(), x.toString()), e));
                    throw e;
                }
            };
        }
        if (o instanceof List) {
            return (c, x) -> ((List)o).contains(x);
        }
        return (c, x) -> x.equals(o);
    }
}

