/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class YearsAndMonthsFunction
extends BaseFEELFunction {
    public YearsAndMonthsFunction() {
        super("years and months duration");
    }

    public FEELFnResult<TemporalAmount> invoke(@ParameterName(value="from") Temporal from, @ParameterName(value="to") Temporal to) {
        if (from == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "cannot be null"));
        }
        if (to == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "to", "cannot be null"));
        }
        LocalDate fromDate = this.getLocalDateFromTemporal(from);
        if (fromDate == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "from", "is of type not suitable for years and months function"));
        }
        LocalDate toDate = this.getLocalDateFromTemporal(to);
        if (toDate == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "to", "is of type not suitable for years and months function"));
        }
        return FEELFnResult.ofResult(Period.between(fromDate, toDate).withDays(0));
    }

    private LocalDate getLocalDateFromTemporal(Temporal temporal) {
        if (temporal instanceof LocalDate) {
            return (LocalDate)temporal;
        }
        if (temporal instanceof Year) {
            return this.getLocalDateFromYear((Year)temporal);
        }
        if (temporal instanceof YearMonth) {
            return this.getLocalDateFromYearAndMonth((YearMonth)temporal);
        }
        try {
            return LocalDate.from(temporal);
        }
        catch (DateTimeException ex) {
            return null;
        }
    }

    private LocalDate getLocalDateFromYear(Year year) {
        return LocalDate.of(year.getValue(), 1, 1);
    }

    private LocalDate getLocalDateFromYearAndMonth(YearMonth yearMonth) {
        return LocalDate.of(yearMonth.getYear(), yearMonth.getMonth(), 1);
    }
}

