/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.feel.runtime.functions.extended;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.feel.runtime.events.InvalidParametersEvent;
import org.kie.dmn.feel.runtime.functions.BaseFEELFunction;
import org.kie.dmn.feel.runtime.functions.FEELFnResult;
import org.kie.dmn.feel.runtime.functions.ParameterName;

public class SplitFunction
extends BaseFEELFunction {
    public SplitFunction() {
        super("split");
    }

    public FEELFnResult<List<String>> invoke(@ParameterName(value="input") String input, @ParameterName(value="delimiter") String delimiter) {
        return this.invoke(input, delimiter, null);
    }

    public FEELFnResult<List<String>> invoke(@ParameterName(value="input") String input, @ParameterName(value="delimiter") String delimiter, @ParameterName(value="flags") String flags) {
        if (input == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "input", "cannot be null"));
        }
        if (delimiter == null) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "delimiter", "cannot be null"));
        }
        try {
            int f = this.processFlags(flags);
            Pattern p = Pattern.compile(delimiter, f);
            String[] split = p.split(input);
            return FEELFnResult.ofResult(Arrays.asList(split));
        }
        catch (PatternSyntaxException e) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "delimiter", "is invalid and can not be compiled", e));
        }
        catch (IllegalArgumentException t) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "flags", "contains unknown flags", t));
        }
        catch (Throwable t) {
            return FEELFnResult.ofError(new InvalidParametersEvent(FEELEvent.Severity.ERROR, "delimiter", "is invalid and can not be compiled", t));
        }
    }

    private int processFlags(String flags) {
        int f = 0;
        if (flags != null) {
            if (flags.contains("s")) {
                f |= 0x20;
            }
            if (flags.contains("m")) {
                f |= 8;
            }
            if (flags.contains("i")) {
                f |= 2;
            }
        }
        return f;
    }
}

