/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.value.decorator;

import java.util.Iterator;
import java.util.List;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.value.AbstractValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.decorator.EntityIndependentFilteringValueSelector;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class FilteringValueSelector
extends AbstractValueSelector {
    protected final ValueSelector childValueSelector;
    protected final List<SelectionFilter> filterList;
    protected final boolean bailOutEnabled;
    protected ScoreDirector scoreDirector = null;

    public static ValueSelector create(ValueSelector valueSelector, List<SelectionFilter> filterList) {
        if (valueSelector instanceof EntityIndependentValueSelector) {
            return new EntityIndependentFilteringValueSelector((EntityIndependentValueSelector)valueSelector, filterList);
        }
        return new FilteringValueSelector(valueSelector, filterList);
    }

    protected FilteringValueSelector(ValueSelector childValueSelector, List<SelectionFilter> filterList) {
        this.childValueSelector = childValueSelector;
        this.filterList = filterList;
        this.bailOutEnabled = childValueSelector.isNeverEnding();
        this.phaseLifecycleSupport.addEventListener(childValueSelector);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.scoreDirector = phaseScope.getScoreDirector();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.scoreDirector = null;
    }

    @Override
    public GenuineVariableDescriptor getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    @Override
    public boolean isCountable() {
        return this.childValueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childValueSelector.isNeverEnding();
    }

    @Override
    public long getSize(Object entity) {
        return this.childValueSelector.getSize(entity);
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return new JustInTimeFilteringValueIterator(this.childValueSelector.iterator(entity), this.determineBailOutSize(entity));
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        return new JustInTimeFilteringValueIterator(this.childValueSelector.endingIterator(entity), this.determineBailOutSize(entity));
    }

    protected long determineBailOutSize(Object entity) {
        if (!this.bailOutEnabled) {
            return -1L;
        }
        return this.childValueSelector.getSize(entity) * 10L;
    }

    protected boolean accept(ScoreDirector scoreDirector, Object entity) {
        for (SelectionFilter filter : this.filterList) {
            if (filter.accept(scoreDirector, entity)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Filtering(" + this.childValueSelector + ")";
    }

    protected class JustInTimeFilteringValueIterator
    extends UpcomingSelectionIterator<Object> {
        private final Iterator<Object> childValueIterator;
        private final long bailOutSize;

        public JustInTimeFilteringValueIterator(Iterator<Object> childValueIterator, long bailOutSize) {
            this.childValueIterator = childValueIterator;
            this.bailOutSize = bailOutSize;
        }

        @Override
        protected Object createUpcomingSelection() {
            Object next;
            long attemptsBeforeBailOut = this.bailOutSize;
            do {
                if (!this.childValueIterator.hasNext()) {
                    return this.noUpcomingSelection();
                }
                if (!FilteringValueSelector.this.bailOutEnabled) continue;
                if (attemptsBeforeBailOut <= 0L) {
                    FilteringValueSelector.this.logger.warn("Bailing out of neverEnding selector ({}) to avoid infinite loop.", (Object)FilteringValueSelector.this);
                    return this.noUpcomingSelection();
                }
                --attemptsBeforeBailOut;
            } while (!FilteringValueSelector.this.accept(FilteringValueSelector.this.scoreDirector, next = this.childValueIterator.next()));
            return next;
        }
    }
}

