/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import java.util.List;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.solver.ChildThreadType;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.AbstractCompositeTermination;
import org.optaplanner.core.impl.solver.termination.Termination;

public class AndCompositeTermination
extends AbstractCompositeTermination {
    public AndCompositeTermination(List<Termination> terminationList) {
        super(terminationList);
    }

    public AndCompositeTermination(Termination ... terminations) {
        super(terminations);
    }

    @Override
    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        for (Termination termination : this.terminationList) {
            if (termination.isSolverTerminated(solverScope)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope phaseScope) {
        for (Termination termination : this.terminationList) {
            if (termination.isPhaseTerminated(phaseScope)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        double timeGradient = 1.0;
        for (Termination termination : this.terminationList) {
            double nextTimeGradient = termination.calculateSolverTimeGradient(solverScope);
            if (!(nextTimeGradient >= 0.0)) continue;
            timeGradient = Math.min(timeGradient, nextTimeGradient);
        }
        return timeGradient;
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope phaseScope) {
        double timeGradient = 1.0;
        for (Termination termination : this.terminationList) {
            double nextTimeGradient = termination.calculatePhaseTimeGradient(phaseScope);
            if (!(nextTimeGradient >= 0.0)) continue;
            timeGradient = Math.min(timeGradient, nextTimeGradient);
        }
        return timeGradient;
    }

    @Override
    public AndCompositeTermination createChildThreadTermination(DefaultSolverScope solverScope, ChildThreadType childThreadType) {
        return new AndCompositeTermination(this.createChildThreadTerminationList(solverScope, childThreadType));
    }

    public String toString() {
        return "And(" + this.terminationList + ")";
    }
}

