/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.solver.ChildThreadType;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.AbstractTermination;
import org.optaplanner.core.impl.solver.termination.Termination;

public class BasicPlumbingTermination
extends AbstractTermination {
    protected final boolean daemon;
    protected boolean terminatedEarly = false;
    protected BlockingQueue<ProblemFactChange> problemFactChangeQueue = new LinkedBlockingQueue<ProblemFactChange>();
    protected boolean problemFactChangesBeingProcessed = false;

    public BasicPlumbingTermination(boolean daemon) {
        this.daemon = daemon;
    }

    public synchronized void resetTerminateEarly() {
        this.terminatedEarly = false;
    }

    public synchronized boolean terminateEarly() {
        boolean terminationEarlySuccessful = !this.terminatedEarly;
        this.terminatedEarly = true;
        this.notifyAll();
        return terminationEarlySuccessful;
    }

    public synchronized boolean isTerminateEarly() {
        return this.terminatedEarly;
    }

    public synchronized boolean waitForRestartSolverDecision() {
        if (!this.daemon) {
            return !this.problemFactChangeQueue.isEmpty() && !this.terminatedEarly;
        }
        while (this.problemFactChangeQueue.isEmpty() && !this.terminatedEarly) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Solver thread was interrupted during Object.wait().", e);
            }
        }
        return !this.terminatedEarly;
    }

    public synchronized <Solution_> boolean addProblemFactChange(ProblemFactChange<Solution_> problemFactChange) {
        boolean added = this.problemFactChangeQueue.add(problemFactChange);
        this.notifyAll();
        return added;
    }

    public synchronized <Solution_> boolean addProblemFactChanges(List<ProblemFactChange<Solution_>> problemFactChangeList) {
        boolean added = this.problemFactChangeQueue.addAll(problemFactChangeList);
        this.notifyAll();
        return added;
    }

    public synchronized BlockingQueue<ProblemFactChange> startProblemFactChangesProcessing() {
        this.problemFactChangesBeingProcessed = true;
        return this.problemFactChangeQueue;
    }

    public synchronized void endProblemFactChangesProcessing() {
        this.problemFactChangesBeingProcessed = false;
    }

    public synchronized boolean isEveryProblemFactChangeProcessed() {
        return this.problemFactChangeQueue.isEmpty() && !this.problemFactChangesBeingProcessed;
    }

    @Override
    public synchronized boolean isSolverTerminated(DefaultSolverScope solverScope) {
        if (Thread.currentThread().isInterrupted() && !this.terminatedEarly) {
            this.logger.info("The solver thread got interrupted, so this solver is terminating early.");
            this.terminatedEarly = true;
        }
        return this.terminatedEarly || !this.problemFactChangeQueue.isEmpty();
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope phaseScope) {
        throw new IllegalStateException(BasicPlumbingTermination.class.getSimpleName() + " configured only as solver termination. It is always bridged to phase termination.");
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        return -1.0;
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope phaseScope) {
        throw new IllegalStateException(BasicPlumbingTermination.class.getSimpleName() + " configured only as solver termination. It is always bridged to phase termination.");
    }

    @Override
    public Termination createChildThreadTermination(DefaultSolverScope solverScope, ChildThreadType childThreadType) {
        return this;
    }

    public String toString() {
        return "BasicPlumbing()";
    }
}

