/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class BuildInfo {
    private static final Properties BUILD_PROPERTIES = BuildInfo.loadBuildProperties();

    private static Properties loadBuildProperties() {
        Properties properties = new Properties();
        URL resource = BuildInfo.class.getResource("/META-INF/selenium-build.properties");
        try (InputStream is = resource.openStream();){
            properties.load(is);
        }
        catch (IOException | NullPointerException exception) {
            // empty catch block
        }
        return properties;
    }

    public String getReleaseLabel() {
        return this.read("Selenium-Version");
    }

    public String getBuildRevision() {
        return this.read("Build-Revision");
    }

    public String toString() {
        return String.format("Build info: version: '%s', revision: '%s'", this.getReleaseLabel(), this.getBuildRevision());
    }

    private String read(String propertyName) {
        String value = BUILD_PROPERTIES.getProperty(propertyName);
        if (value == null || value.trim().isEmpty()) {
            return "unknown";
        }
        return value.trim();
    }
}

