/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.ScriptKey;
import org.openqa.selenium.UnpinnedScriptKey;
import org.openqa.selenium.internal.Require;

@NullMarked
public interface JavascriptExecutor {
    public @Nullable Object executeScript(String var1, Object ... var2);

    public @Nullable Object executeAsyncScript(String var1, Object ... var2);

    default public ScriptKey pin(String script) {
        Require.nonNull("Script to pin", script);
        return UnpinnedScriptKey.pin(this, script);
    }

    default public void unpin(ScriptKey key) {
        Require.nonNull("Key to unpin", key);
        Require.stateCondition(key instanceof UnpinnedScriptKey, "Script key should have been generated by this driver", new Object[0]);
        UnpinnedScriptKey.unpin(this, (UnpinnedScriptKey)key);
    }

    default public Set<ScriptKey> getPinnedScripts() {
        return UnpinnedScriptKey.getPinnedScripts(this).stream().map(key -> key).collect(Collectors.toUnmodifiableSet());
    }

    default public @Nullable Object executeScript(ScriptKey key, Object ... args) {
        Require.stateCondition(key instanceof UnpinnedScriptKey, "Script key should have been generated by this driver", new Object[0]);
        if (!this.getPinnedScripts().contains(key)) {
            throw new JavascriptException("Script is unpinned");
        }
        return this.executeScript(((UnpinnedScriptKey)key).getScript(), args);
    }
}

