package org.openqa.selenium.devtools.v138.filesystem.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class Directory {

    private final java.lang.String name;

    private final java.util.List<java.lang.String> nestedDirectories;

    private final java.util.List<org.openqa.selenium.devtools.v138.filesystem.model.File> nestedFiles;

    public Directory(java.lang.String name, java.util.List<java.lang.String> nestedDirectories, java.util.List<org.openqa.selenium.devtools.v138.filesystem.model.File> nestedFiles) {
        this.name = java.util.Objects.requireNonNull(name, "name is required");
        this.nestedDirectories = java.util.Objects.requireNonNull(nestedDirectories, "nestedDirectories is required");
        this.nestedFiles = java.util.Objects.requireNonNull(nestedFiles, "nestedFiles is required");
    }

    public java.lang.String getName() {
        return name;
    }

    public java.util.List<java.lang.String> getNestedDirectories() {
        return nestedDirectories;
    }

    /**
     * Files that are directly nested under this directory.
     */
    public java.util.List<org.openqa.selenium.devtools.v138.filesystem.model.File> getNestedFiles() {
        return nestedFiles;
    }

    private static Directory fromJson(JsonInput input) {
        java.lang.String name = null;
        java.util.List<java.lang.String> nestedDirectories = null;
        java.util.List<org.openqa.selenium.devtools.v138.filesystem.model.File> nestedFiles = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "name":
                    name = input.nextString();
                    break;
                case "nestedDirectories":
                    nestedDirectories = input.readArray(java.lang.String.class);
                    break;
                case "nestedFiles":
                    nestedFiles = input.readArray(org.openqa.selenium.devtools.v138.filesystem.model.File.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new Directory(name, nestedDirectories, nestedFiles);
    }
}
