package org.openqa.selenium.devtools.v139.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Configuration data for the highlighting of Flex container elements.
 */
public class FlexContainerHighlightConfig {

    private final java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.LineStyle> containerBorder;

    private final java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.LineStyle> lineSeparator;

    private final java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.LineStyle> itemSeparator;

    private final java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.BoxStyle> mainDistributedSpace;

    private final java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.BoxStyle> crossDistributedSpace;

    private final java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.BoxStyle> rowGapSpace;

    private final java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.BoxStyle> columnGapSpace;

    private final java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.LineStyle> crossAlignment;

    public FlexContainerHighlightConfig(java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.LineStyle> containerBorder, java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.LineStyle> lineSeparator, java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.LineStyle> itemSeparator, java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.BoxStyle> mainDistributedSpace, java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.BoxStyle> crossDistributedSpace, java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.BoxStyle> rowGapSpace, java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.BoxStyle> columnGapSpace, java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.LineStyle> crossAlignment) {
        this.containerBorder = containerBorder;
        this.lineSeparator = lineSeparator;
        this.itemSeparator = itemSeparator;
        this.mainDistributedSpace = mainDistributedSpace;
        this.crossDistributedSpace = crossDistributedSpace;
        this.rowGapSpace = rowGapSpace;
        this.columnGapSpace = columnGapSpace;
        this.crossAlignment = crossAlignment;
    }

    /**
     * The style of the container border
     */
    public java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.LineStyle> getContainerBorder() {
        return containerBorder;
    }

    /**
     * The style of the separator between lines
     */
    public java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.LineStyle> getLineSeparator() {
        return lineSeparator;
    }

    /**
     * The style of the separator between items
     */
    public java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.LineStyle> getItemSeparator() {
        return itemSeparator;
    }

    /**
     * Style of content-distribution space on the main axis (justify-content).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.BoxStyle> getMainDistributedSpace() {
        return mainDistributedSpace;
    }

    /**
     * Style of content-distribution space on the cross axis (align-content).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.BoxStyle> getCrossDistributedSpace() {
        return crossDistributedSpace;
    }

    /**
     * Style of empty space caused by row gaps (gap/row-gap).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.BoxStyle> getRowGapSpace() {
        return rowGapSpace;
    }

    /**
     * Style of empty space caused by columns gaps (gap/column-gap).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.BoxStyle> getColumnGapSpace() {
        return columnGapSpace;
    }

    /**
     * Style of the self-alignment line (align-items).
     */
    public java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.LineStyle> getCrossAlignment() {
        return crossAlignment;
    }

    private static FlexContainerHighlightConfig fromJson(JsonInput input) {
        java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.LineStyle> containerBorder = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.LineStyle> lineSeparator = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.LineStyle> itemSeparator = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.BoxStyle> mainDistributedSpace = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.BoxStyle> crossDistributedSpace = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.BoxStyle> rowGapSpace = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.BoxStyle> columnGapSpace = java.util.Optional.empty();
        java.util.Optional<org.openqa.selenium.devtools.v139.overlay.model.LineStyle> crossAlignment = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "containerBorder":
                    containerBorder = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v139.overlay.model.LineStyle.class));
                    break;
                case "lineSeparator":
                    lineSeparator = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v139.overlay.model.LineStyle.class));
                    break;
                case "itemSeparator":
                    itemSeparator = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v139.overlay.model.LineStyle.class));
                    break;
                case "mainDistributedSpace":
                    mainDistributedSpace = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v139.overlay.model.BoxStyle.class));
                    break;
                case "crossDistributedSpace":
                    crossDistributedSpace = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v139.overlay.model.BoxStyle.class));
                    break;
                case "rowGapSpace":
                    rowGapSpace = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v139.overlay.model.BoxStyle.class));
                    break;
                case "columnGapSpace":
                    columnGapSpace = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v139.overlay.model.BoxStyle.class));
                    break;
                case "crossAlignment":
                    crossAlignment = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v139.overlay.model.LineStyle.class));
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FlexContainerHighlightConfig(containerBorder, lineSeparator, itemSeparator, mainDistributedSpace, crossDistributedSpace, rowGapSpace, columnGapSpace, crossAlignment);
    }
}
