/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v139.dom.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v139.dom.model.NodeId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class ScrollableFlagUpdated {
    private final NodeId nodeId;
    private final Boolean isScrollable;

    public ScrollableFlagUpdated(NodeId nodeId, Boolean isScrollable) {
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId is required");
        this.isScrollable = Objects.requireNonNull(isScrollable, "isScrollable is required");
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public Boolean getIsScrollable() {
        return this.isScrollable;
    }

    private static ScrollableFlagUpdated fromJson(JsonInput input) {
        NodeId nodeId = null;
        Boolean isScrollable = false;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodeId": {
                    nodeId = (NodeId)input.read(NodeId.class);
                    continue block8;
                }
                case "isScrollable": {
                    isScrollable = input.nextBoolean();
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ScrollableFlagUpdated(nodeId, isScrollable);
    }
}

