/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.idealized;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.events.ConsoleEvent;
import org.openqa.selenium.internal.Require;

public abstract class Events<CONSOLEEVENT, EXCEPTIONTHROWN> {
    private final DevTools devtools;
    private final List<Consumer<ConsoleEvent>> consoleListeners = new LinkedList<Consumer<ConsoleEvent>>();
    private final List<Consumer<JavascriptException>> exceptionListeners = new LinkedList<Consumer<JavascriptException>>();
    private boolean consoleListenersEnabled = false;

    public Events(DevTools devtools) {
        this.devtools = (DevTools)Require.nonNull((String)"DevTools", (Object)devtools);
    }

    public void addConsoleListener(Consumer<ConsoleEvent> listener) {
        Require.nonNull((String)"Event handler", listener);
        this.consoleListeners.add(listener);
        this.initializeConsoleListeners();
    }

    public void addJavascriptExceptionListener(Consumer<JavascriptException> listener) {
        Require.nonNull((String)"Listener", listener);
        this.exceptionListeners.add(listener);
        this.initializeConsoleListeners();
    }

    private void initializeConsoleListeners() {
        if (this.consoleListenersEnabled) {
            return;
        }
        this.devtools.send(this.enableRuntime());
        this.devtools.addListener(this.consoleEvent(), event -> {
            ConsoleEvent consoleEvent = this.toConsoleEvent(event);
            this.consoleListeners.forEach(l -> l.accept(consoleEvent));
        });
        this.devtools.addListener(this.exceptionThrownEvent(), event -> {
            JavascriptException exception = this.toJsException(event);
            this.exceptionListeners.forEach(l -> l.accept(exception));
        });
        this.consoleListenersEnabled = true;
    }

    public void disable() {
        this.devtools.send(this.disableRuntime());
        this.consoleListeners.clear();
        this.consoleListenersEnabled = false;
    }

    protected abstract Command<Void> enableRuntime();

    protected abstract Command<Void> disableRuntime();

    protected abstract Event<CONSOLEEVENT> consoleEvent();

    protected abstract Event<EXCEPTIONTHROWN> exceptionThrownEvent();

    protected abstract ConsoleEvent toConsoleEvent(CONSOLEEVENT var1);

    protected abstract JavascriptException toJsException(EXCEPTIONTHROWN var1);
}

