/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.internal.jvm.Jvm;
import org.gradle.util.GradleVersion;
import org.sonarqube.gradle.Gradle6dot6Utils;
import org.sonarqube.gradle.JavaCompilerConfiguration;
import org.sonarqube.gradle.ToolchainUtils;

public class JavaCompilerUtils {
    private static final Logger LOGGER = Logging.getLogger(JavaCompilerUtils.class);

    private JavaCompilerUtils() {
    }

    public static Optional<JavaCompilerConfiguration> extractJavaCompilerConfigurationFromCompileTasks(Project project) {
        TaskCollection javaCompileTaskCollection = project.getTasks().withType(JavaCompile.class);
        if (javaCompileTaskCollection.isEmpty()) {
            return Optional.empty();
        }
        List jdkHomesUsedByCompileTasks = javaCompileTaskCollection.stream().map(JavaCompilerUtils::extractConfiguration).collect(Collectors.toList());
        JavaCompilerConfiguration first = (JavaCompilerConfiguration)jdkHomesUsedByCompileTasks.get(0);
        if (!jdkHomesUsedByCompileTasks.stream().allMatch(config -> JavaCompilerConfiguration.same(config, first))) {
            LOGGER.info("Heterogeneous compiler configuration has been detected. Using compiler configuration from task: '" + first.getTaskName() + "'");
        }
        return Optional.of(first);
    }

    static JavaCompilerConfiguration extractConfiguration(JavaCompile compileTask) {
        JavaCompilerConfiguration javaCompilerConfiguration = new JavaCompilerConfiguration(compileTask.getName());
        JavaCompilerUtils.configureCompatibilityOptions(compileTask, javaCompilerConfiguration);
        javaCompilerConfiguration.setJdkHome(JavaCompilerUtils.extractJavaHome(compileTask).getAbsolutePath());
        return javaCompilerConfiguration;
    }

    private static File extractJavaHome(JavaCompile compileTask) {
        File javaHome;
        Optional<Object> jdkHomeFromToolchains = Optional.empty();
        if (JavaCompilerUtils.areToolchainsSupported()) {
            jdkHomeFromToolchains = ToolchainUtils.getJdkHome(compileTask);
        }
        if (jdkHomeFromToolchains.isPresent()) {
            return (File)jdkHomeFromToolchains.get();
        }
        CompileOptions compileOptions = compileTask.getOptions();
        if (compileOptions.isFork() && (javaHome = compileOptions.getForkOptions().getJavaHome()) != null) {
            return javaHome;
        }
        return Jvm.current().getJavaHome();
    }

    private static boolean areToolchainsSupported() {
        return GradleVersion.current().compareTo(GradleVersion.version((String)"6.7")) >= 0;
    }

    private static void configureCompatibilityOptions(JavaCompile compileTask, JavaCompilerConfiguration config) {
        List compilerArgs = compileTask.getOptions().getCompilerArgs();
        config.setEnablePreview(compilerArgs.stream().anyMatch(it -> it.equals("--enable-preview")));
        if (JavaCompilerUtils.areToolchainsSupported() && ToolchainUtils.hasToolchains(compileTask)) {
            ToolchainUtils.configureCompatibilityOptions(compileTask, config);
        } else {
            Optional<String> release = JavaCompilerUtils.getRelease(compileTask.getOptions());
            Optional<String> parsedVersion = JavaCompilerUtils.parseReleaseArgument(compileTask.getOptions());
            if (release.isPresent()) {
                config.setRelease(release.get());
            } else if (parsedVersion.isPresent()) {
                config.setRelease(parsedVersion.get());
            } else {
                config.setTarget(compileTask.getTargetCompatibility());
                config.setSource(compileTask.getSourceCompatibility());
            }
        }
    }

    private static Optional<String> parseReleaseArgument(CompileOptions options) {
        List compilerArgs = options.getCompilerArgs();
        for (int i = 0; i < compilerArgs.size(); ++i) {
            if (!"--release".equals(compilerArgs.get(i)) || i >= compilerArgs.size() - 1) continue;
            return Optional.of((String)compilerArgs.get(i + 1));
        }
        return Optional.empty();
    }

    private static Optional<String> getRelease(CompileOptions options) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.6")) >= 0) {
            return Gradle6dot6Utils.getRelease(options);
        }
        return Optional.empty();
    }
}

