/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.DynamicFeaturePlugin;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.LibraryPlugin;
import com.android.build.gradle.TestExtension;
import com.android.build.gradle.TestPlugin;
import com.android.build.gradle.api.ApkVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.api.UnitTestVariant;
import com.android.build.gradle.internal.api.TestedVariant;
import com.android.build.gradle.internal.dsl.BaseFlavor;
import com.android.build.gradle.internal.lint.AndroidLintTask;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.tasks.factory.AndroidUnitTest;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.SourceProvider;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.PluginCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.util.GradleVersion;
import org.sonarqube.gradle.JavaCompilerUtils;
import org.sonarqube.gradle.SonarUtils;
import org.sonarqube.gradle.Version;

class AndroidUtils {
    private static final Logger LOGGER = Logging.getLogger(AndroidUtils.class);
    private static final String SONAR_ANDROID_LINT_REPORT_PATHS_PROP = "sonar.androidLint.reportPaths";

    private AndroidUtils() {
    }

    static void configureForAndroid(Project project, @Nullable String userConfiguredBuildVariantName, Map<String, Object> properties) {
        AndroidVariantAndExtension android = AndroidUtils.findVariantAndExtension(project, userConfiguredBuildVariantName);
        if (android != null && android.getVariant() != null) {
            AndroidUtils.configureForAndroid(project, android, properties);
        } else {
            LOGGER.warn("No variant found for '{}'. No android specific configuration will be done", (Object)project.getName());
        }
    }

    static Version getAndroidPluginVersion() {
        return Version.of(com.android.builder.model.Version.ANDROID_GRADLE_PLUGIN_VERSION);
    }

    private static void configureForAndroid(Project project, AndroidVariantAndExtension android, Map<String, Object> properties) {
        List<File> bootClassPath = AndroidUtils.getBootClasspath(project);
        BaseVariant variant = android.getVariant();
        AndroidUtils.populateSonarQubeAndroidProperties(android, properties);
        AndroidUtils.configureTestReports(project, variant, properties);
        AndroidUtils.configureLintReports(project, variant, properties);
        if (project.getPlugins().hasPlugin("com.android.test")) {
            AndroidUtils.populateSonarQubeProps(properties, bootClassPath, variant, true);
        } else {
            AndroidUtils.populateSonarQubeProps(properties, bootClassPath, variant, false);
            if (variant instanceof TestedVariant) {
                TestVariant testVariant;
                UnitTestVariant unitTestVariant = ((TestedVariant)variant).getUnitTestVariant();
                if (unitTestVariant != null) {
                    AndroidUtils.populateSonarQubeProps(properties, bootClassPath, (BaseVariant)unitTestVariant, true);
                }
                if ((testVariant = ((TestedVariant)variant).getTestVariant()) != null) {
                    AndroidUtils.populateSonarQubeProps(properties, bootClassPath, (BaseVariant)testVariant, true);
                }
            }
        }
    }

    private static void populateSonarQubeAndroidProperties(AndroidVariantAndExtension android, Map<String, Object> properties) {
        properties.put("sonar.android.detected", true);
        if (!AndroidUtils.isMinSdkSupported()) {
            return;
        }
        if (android.isVariantProvidedByUser()) {
            ApiVersion minSdkVersion = android.getVariant().getMergedFlavor().getMinSdkVersion();
            if (minSdkVersion != null) {
                properties.put("sonar.android.minsdkversion.min", minSdkVersion.getApiLevel());
                properties.put("sonar.android.minsdkversion.max", minSdkVersion.getApiLevel());
            }
        } else {
            Set minSdks = Stream.concat(android.getExtension().getProductFlavors().stream().map(BaseFlavor::getMinSdk), Stream.of(android.getExtension().getDefaultConfig().getMinSdk())).filter(Objects::nonNull).collect(Collectors.toSet());
            if (!minSdks.isEmpty()) {
                properties.put("sonar.android.minsdkversion.min", Collections.min(minSdks));
                properties.put("sonar.android.minsdkversion.max", Collections.max(minSdks));
            }
        }
    }

    private static void configureTestReports(Project project, BaseVariant variant, Map<String, Object> map) {
        TestVariant testVariant;
        if (!(variant instanceof TestedVariant)) {
            return;
        }
        if (AndroidUtils.getAndroidPluginVersion().compareTo(Version.of("3.3")) < 0 || GradleVersion.current().compareTo(GradleVersion.version((String)"6.0")) < 0) {
            return;
        }
        LinkedList directories = new LinkedList();
        UnitTestVariant unitTestVariant = ((TestedVariant)variant).getUnitTestVariant();
        if (unitTestVariant != null) {
            directories.addAll(project.getTasks().withType(AndroidUnitTest.class).stream().filter(task -> unitTestVariant.getName().equals(task.getVariantName())).map(task -> task.getReports().getJunitXml().getOutputLocation()).collect(Collectors.toList()));
        }
        if ((testVariant = ((TestedVariant)variant).getTestVariant()) != null) {
            Function<DeviceProviderInstrumentTestTask, DirectoryProperty> testTaskToDirectoryProperty = AndroidUtils.getAndroidPluginVersion().compareTo(Version.of("4.2")) < 0 ? AndroidUtils::getReportsDirBeforeGradle42 : DeviceProviderInstrumentTestTask::getReportsDir;
            project.getTasks().withType(DeviceProviderInstrumentTestTask.class).stream().filter(t -> testVariant.getName().equals(t.getVariantName())).map(testTaskToDirectoryProperty).filter(Provider::isPresent).forEach(directories::add);
        }
        if (directories.isEmpty()) {
            return;
        }
        List value = directories.stream().filter(Provider::isPresent).map(d -> ((Directory)d.get()).getAsFile()).filter(file -> file.isDirectory() && file.list().length > 0).collect(Collectors.toList());
        map.put("sonar.junit.reportPaths", value);
    }

    private static DirectoryProperty getReportsDirBeforeGradle42(DeviceProviderInstrumentTestTask testTask) {
        try {
            Method getReportsDir = testTask.getClass().getMethod("getReportsDir", new Class[0]);
            File dir = (File)getReportsDir.invoke((Object)testTask, new Object[0]);
            return testTask.getProject().getObjects().directoryProperty().fileValue(dir);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to get tests directory", e);
        }
    }

    private static void configureLintReports(Project project, BaseVariant variant, Map<String, Object> properties) {
        if (AndroidUtils.getAndroidPluginVersion().compareTo(Version.of("7.0")) >= 0) {
            project.getTasks().withType(AndroidLintTask.class).stream().filter(a -> a.getXmlReportOutputFile().isPresent()).filter(a -> a.getVariantName().equals(variant.getName())).map(a -> ((RegularFile)a.getXmlReportOutputFile().get()).getAsFile()).findFirst().ifPresent(output -> properties.put(SONAR_ANDROID_LINT_REPORT_PATHS_PROP, output));
        }
    }

    @Nullable
    private static List<File> getBootClasspath(Project project) {
        PluginCollection appPlugins = project.getPlugins().withType(AppPlugin.class);
        if (!appPlugins.isEmpty()) {
            AppExtension androidExtension = (AppExtension)project.getExtensions().getByType(AppExtension.class);
            return androidExtension.getBootClasspath();
        }
        PluginCollection libPlugins = project.getPlugins().withType(LibraryPlugin.class);
        if (!libPlugins.isEmpty()) {
            LibraryExtension androidExtension = (LibraryExtension)project.getExtensions().getByType(LibraryExtension.class);
            return androidExtension.getBootClasspath();
        }
        PluginCollection testPlugins = project.getPlugins().withType(TestPlugin.class);
        if (!testPlugins.isEmpty()) {
            TestExtension androidExtension = (TestExtension)project.getExtensions().getByType(TestExtension.class);
            return androidExtension.getBootClasspath();
        }
        PluginCollection dynamicFeaturePlugins = project.getPlugins().withType(DynamicFeaturePlugin.class);
        if (!dynamicFeaturePlugins.isEmpty()) {
            AppExtension androidExtension = (AppExtension)project.getExtensions().getByType(AppExtension.class);
            return androidExtension.getBootClasspath();
        }
        return null;
    }

    @Nullable
    private static String getTestBuildType(Project project) {
        PluginCollection appPlugins = project.getPlugins().withType(AppPlugin.class);
        if (!appPlugins.isEmpty()) {
            AppExtension androidExtension = (AppExtension)project.getExtensions().getByType(AppExtension.class);
            return androidExtension.getTestBuildType();
        }
        PluginCollection libPlugins = project.getPlugins().withType(LibraryPlugin.class);
        if (!libPlugins.isEmpty()) {
            LibraryExtension androidExtension = (LibraryExtension)project.getExtensions().getByType(LibraryExtension.class);
            return androidExtension.getTestBuildType();
        }
        PluginCollection dynamicFeaturePlugins = project.getPlugins().withType(DynamicFeaturePlugin.class);
        if (!dynamicFeaturePlugins.isEmpty()) {
            AppExtension androidExtension = (AppExtension)project.getExtensions().getByType(AppExtension.class);
            return androidExtension.getTestBuildType();
        }
        return null;
    }

    @Nullable
    static AndroidVariantAndExtension findVariantAndExtension(Project project, @Nullable String userConfiguredBuildVariantName) {
        String testBuildType = AndroidUtils.getTestBuildType(project);
        PluginCollection appPlugins = project.getPlugins().withType(AppPlugin.class);
        if (!appPlugins.isEmpty()) {
            AppExtension androidExtension = (AppExtension)project.getExtensions().getByType(AppExtension.class);
            BaseVariant variant = AndroidUtils.findVariant(new ArrayList<BaseVariant>((Collection<BaseVariant>)androidExtension.getApplicationVariants()), testBuildType, userConfiguredBuildVariantName);
            return new AndroidVariantAndExtension((BaseExtension)androidExtension, variant, userConfiguredBuildVariantName);
        }
        PluginCollection libPlugins = project.getPlugins().withType(LibraryPlugin.class);
        if (!libPlugins.isEmpty()) {
            LibraryExtension androidExtension = (LibraryExtension)project.getExtensions().getByType(LibraryExtension.class);
            BaseVariant variant = AndroidUtils.findVariant(new ArrayList<BaseVariant>((Collection<BaseVariant>)androidExtension.getLibraryVariants()), testBuildType, userConfiguredBuildVariantName);
            return new AndroidVariantAndExtension((BaseExtension)androidExtension, variant, userConfiguredBuildVariantName);
        }
        PluginCollection testPlugins = project.getPlugins().withType(TestPlugin.class);
        if (!testPlugins.isEmpty()) {
            TestExtension androidExtension = (TestExtension)project.getExtensions().getByType(TestExtension.class);
            BaseVariant variant = AndroidUtils.findVariant(new ArrayList<BaseVariant>((Collection<BaseVariant>)androidExtension.getApplicationVariants()), testBuildType, userConfiguredBuildVariantName);
            return new AndroidVariantAndExtension((BaseExtension)androidExtension, variant, userConfiguredBuildVariantName);
        }
        PluginCollection dynamicFeaturePlugins = project.getPlugins().withType(DynamicFeaturePlugin.class);
        if (!dynamicFeaturePlugins.isEmpty()) {
            AppExtension androidExtension = (AppExtension)project.getExtensions().getByType(AppExtension.class);
            BaseVariant variant = AndroidUtils.findVariant(new ArrayList<BaseVariant>((Collection<BaseVariant>)androidExtension.getApplicationVariants()), testBuildType, userConfiguredBuildVariantName);
            return new AndroidVariantAndExtension((BaseExtension)androidExtension, variant, userConfiguredBuildVariantName);
        }
        return null;
    }

    @Nullable
    private static BaseVariant findVariant(List<BaseVariant> candidates, @Nullable String testBuildType, @Nullable String userConfiguredBuildVariantName) {
        if (candidates.isEmpty()) {
            return null;
        }
        if (userConfiguredBuildVariantName == null) {
            Optional<BaseVariant> firstDebug = candidates.stream().filter(v -> testBuildType != null && testBuildType.equals(v.getBuildType().getName())).findFirst();
            BaseVariant result = firstDebug.orElse(candidates.get(0));
            LOGGER.info("No variant name specified to be used by SonarQube. Default to '{}'", (Object)result.getName());
            return result;
        }
        Optional<BaseVariant> result = candidates.stream().filter(v -> userConfiguredBuildVariantName.equals(v.getName())).findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        throw new IllegalArgumentException("Unable to find variant '" + userConfiguredBuildVariantName + "' to use for SonarQube analysis. Candidates are: " + candidates.stream().map(BaseVariant::getName).collect(Collectors.joining(", ")));
    }

    private static void populateSonarQubeProps(Map<String, Object> properties, @Nullable List<File> bootClassPath, BaseVariant variant, boolean isTest) {
        Set<File> destinationDirs;
        JavaCompile javaCompile;
        List srcDirs = variant.getSourceSets().stream().map(AndroidUtils::getFilesFromSourceSet).collect(ArrayList::new, ArrayList::addAll, ArrayList::addAll);
        List<File> sourcesOrTests = SonarUtils.nonEmptyOrNull(srcDirs.stream().filter(File::exists).collect(Collectors.toList()));
        if (sourcesOrTests != null) {
            SonarUtils.appendSourcesProp(properties, sourcesOrTests, isTest);
        }
        if ((javaCompile = AndroidUtils.getJavaCompiler(variant)) == null) {
            LOGGER.warn("Unable to find Java compiler on variant '{}'. Is Jack toolchain used? SonarQube analysis will be less accurate without bytecode.", (Object)variant.getName());
        } else {
            SonarUtils.populateJdkProperties(properties, JavaCompilerUtils.extractConfiguration(javaCompile));
            JavaCompilerUtils.extractConfiguration(javaCompile);
        }
        LinkedHashSet<File> libraries = new LinkedHashSet<File>(bootClassPath);
        if (variant instanceof ApkVariant) {
            libraries.addAll(AndroidUtils.getLibraries((ApkVariant)variant));
        }
        if (javaCompile != null) {
            libraries.addAll(SonarUtils.exists((Iterable<File>)javaCompile.getClasspath()));
        }
        Set<File> set = destinationDirs = javaCompile != null ? Collections.singleton((File)javaCompile.getDestinationDirectory().getAsFile().get()) : Collections.emptySet();
        if (isTest) {
            SonarUtils.setTestClasspathProps(properties, destinationDirs, libraries);
        } else {
            SonarUtils.setMainClasspathProps(properties, destinationDirs, libraries, false);
        }
    }

    @Nonnull
    private static Collection<File> getLibraries(ApkVariant variant) {
        try {
            Method methodOnAndroidBefore30 = variant.getClass().getMethod("getCompileLibraries", new Class[0]);
            return (Set)methodOnAndroidBefore30.invoke((Object)variant, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            return SonarUtils.exists((Iterable<File>)variant.getCompileClasspath(null));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to call getCompileLibraries", e);
        }
    }

    private static boolean isMinSdkSupported() {
        return GradleVersion.current().compareTo(GradleVersion.version((String)"6.5")) >= 0;
    }

    @Nullable
    private static JavaCompile getJavaCompiler(BaseVariant variant) {
        return (JavaCompile)variant.getJavaCompileProvider().getOrNull();
    }

    private static List<File> getFilesFromSourceSet(SourceProvider sourceSet) {
        ArrayList<File> srcDirs = new ArrayList<File>();
        srcDirs.add(sourceSet.getManifestFile());
        srcDirs.addAll(sourceSet.getCDirectories());
        srcDirs.addAll(sourceSet.getAidlDirectories());
        srcDirs.addAll(sourceSet.getAssetsDirectories());
        srcDirs.addAll(sourceSet.getCppDirectories());
        srcDirs.addAll(sourceSet.getJavaDirectories());
        srcDirs.addAll(sourceSet.getRenderscriptDirectories());
        srcDirs.addAll(sourceSet.getResDirectories());
        srcDirs.addAll(sourceSet.getResourcesDirectories());
        return srcDirs;
    }

    static class AndroidVariantAndExtension {
        private final BaseExtension extension;
        private final BaseVariant variant;
        private final boolean variantProvidedByUser;

        AndroidVariantAndExtension(BaseExtension baseExtension, @Nullable BaseVariant baseVariant, @Nullable String userConfiguredVariantName) {
            this.extension = baseExtension;
            this.variant = baseVariant;
            this.variantProvidedByUser = this.variant != null && this.variant.getName().equals(userConfiguredVariantName);
        }

        BaseExtension getExtension() {
            return this.extension;
        }

        BaseVariant getVariant() {
            return this.variant;
        }

        boolean isVariantProvidedByUser() {
            return this.variantProvidedByUser;
        }
    }
}

