/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.sonarqube.gradle.ProjectProperties;

public class ResolutionSerializer {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = Logging.getLogger(ResolutionSerializer.class);

    private ResolutionSerializer() {
    }

    public static ProjectProperties read(File input) throws IOException {
        try (FileReader reader = new FileReader(input, StandardCharsets.UTF_8);){
            ProjectProperties projectProperties = (ProjectProperties)GSON.fromJson((Reader)reader, ProjectProperties.class);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Read project properties from file: {}", (Object)input.getAbsolutePath());
            }
            ProjectProperties projectProperties2 = projectProperties;
            return projectProperties2;
        }
    }

    public static File write(File output, ProjectProperties properties) throws IOException {
        try (FileWriter writer = new FileWriter(output, StandardCharsets.UTF_8);){
            GSON.toJson((Object)properties, (Appendable)writer);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Wrote project properties to file: {}", (Object)output.getAbsolutePath());
            }
        }
        return output;
    }
}

