/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.sonarqube.gradle.ProjectProperties;
import org.sonarqube.gradle.ResolutionSerializer;
import org.sonarqube.gradle.SonarUtils;

public abstract class SonarResolverTask
extends DefaultTask {
    public static final String TASK_NAME = "sonarResolver";
    public static final String TASK_DESCRIPTION = "Resolves and serializes project information and classpath for SonarQube analysis.";
    private static final Logger LOGGER = Logger.getLogger(SonarResolverTask.class.getName());
    private String projectName;
    private boolean isTopLevelProject;
    private FileCollection compileClasspath;
    private FileCollection testCompileClasspath;
    private File outputDirectory;

    @Input
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String name) {
        this.projectName = name;
    }

    @Input
    public boolean isTopLevelProject() {
        return this.isTopLevelProject;
    }

    public void setTopLevelProject(boolean topLevelProject) {
        this.isTopLevelProject = topLevelProject;
    }

    @InputFiles
    @Optional
    FileCollection getCompileClasspath() {
        return this.compileClasspath;
    }

    public void setCompileClasspath(FileCollection compileClasspath) {
        this.compileClasspath = compileClasspath;
    }

    @InputFiles
    @Optional
    FileCollection getTestCompileClasspath() {
        return this.testCompileClasspath;
    }

    public void setTestCompileClasspath(FileCollection testCompileClasspath) {
        this.testCompileClasspath = testCompileClasspath;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @OutputFile
    public File getOutputFile() throws IOException {
        String filename = "properties";
        File output = new File(this.outputDirectory, filename);
        if (output.isFile() && output.exists()) {
            return output;
        }
        if (!output.createNewFile()) {
            throw new IOException("Could not create output file: " + output.getAbsolutePath());
        }
        return output;
    }

    @TaskAction
    void run() throws IOException {
        String displayName = this.getProjectName();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Resolving properties for " + displayName + ".");
        }
        if (this.compileClasspath == null && this.configurationCacheIsDisabled()) {
            this.compileClasspath = SonarUtils.getMainClassPath(this.getProject());
        }
        if (this.testCompileClasspath == null && this.configurationCacheIsDisabled()) {
            this.testCompileClasspath = SonarUtils.getTestClassPath(this.getProject());
        }
        List<String> compileClasspathFilenames = SonarUtils.exists((Iterable<File>)(this.compileClasspath == null ? Collections.emptyList() : this.compileClasspath)).stream().map(File::getAbsolutePath).collect(Collectors.toList());
        List<String> testCompileClasspathFilenames = SonarUtils.exists((Iterable<File>)(this.testCompileClasspath == null ? Collections.emptyList() : this.testCompileClasspath)).stream().map(File::getAbsolutePath).collect(Collectors.toList());
        ProjectProperties projectProperties = new ProjectProperties(this.getProjectName(), this.isTopLevelProject(), compileClasspathFilenames, testCompileClasspathFilenames);
        ResolutionSerializer.write(this.getOutputFile(), projectProperties);
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Resolved properties for " + displayName + " and wrote them to " + String.valueOf(this.getOutputFile()) + ".");
        }
    }

    public boolean configurationCacheIsDisabled() {
        return true;
    }
}

