/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import java.time.Duration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.image.Image;
import org.springframework.ai.image.ImageClient;
import org.springframework.ai.image.ImageGeneration;
import org.springframework.ai.image.ImageGenerationMetadata;
import org.springframework.ai.image.ImageMessage;
import org.springframework.ai.image.ImageOptions;
import org.springframework.ai.image.ImagePrompt;
import org.springframework.ai.image.ImageResponse;
import org.springframework.ai.image.ImageResponseMetadata;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.openai.OpenAiImageOptions;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.openai.api.OpenAiImageApi;
import org.springframework.ai.openai.metadata.OpenAiImageGenerationMetadata;
import org.springframework.ai.openai.metadata.OpenAiImageResponseMetadata;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class OpenAiImageClient
implements ImageClient {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private OpenAiImageOptions defaultOptions;
    private final OpenAiImageApi openAiImageApi;
    public final RetryTemplate retryTemplate = RetryTemplate.builder().maxAttempts(10).retryOn(OpenAiApi.OpenAiApiException.class).exponentialBackoff(Duration.ofMillis(2000L), 5.0, Duration.ofMillis(180000L)).withListener(new RetryListener(){

        public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
            OpenAiImageClient.this.logger.warn("Retry error. Retry count:" + context.getRetryCount(), throwable);
        }
    }).build();

    public OpenAiImageClient(OpenAiImageApi openAiImageApi) {
        Assert.notNull((Object)openAiImageApi, (String)"OpenAiImageApi must not be null");
        this.openAiImageApi = openAiImageApi;
    }

    public OpenAiImageOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    public OpenAiImageClient withDefaultOptions(OpenAiImageOptions defaultOptions) {
        this.defaultOptions = defaultOptions;
        return this;
    }

    public ImageResponse call(ImagePrompt imagePrompt) {
        return (ImageResponse)this.retryTemplate.execute(ctx -> {
            String instructions = ((ImageMessage)imagePrompt.getInstructions().get(0)).getText();
            OpenAiImageApi.OpenAiImageRequest imageRequest = new OpenAiImageApi.OpenAiImageRequest(instructions, "dall-e-2");
            if (this.defaultOptions != null) {
                imageRequest = (OpenAiImageApi.OpenAiImageRequest)ModelOptionsUtils.merge((Object)this.defaultOptions, (Object)imageRequest, OpenAiImageApi.OpenAiImageRequest.class);
            }
            if (imagePrompt.getOptions() != null) {
                imageRequest = (OpenAiImageApi.OpenAiImageRequest)ModelOptionsUtils.merge((Object)this.toOpenAiImageOptions(imagePrompt.getOptions()), (Object)imageRequest, OpenAiImageApi.OpenAiImageRequest.class);
            }
            ResponseEntity<OpenAiImageApi.OpenAiImageResponse> imageResponseEntity = this.openAiImageApi.createImage(imageRequest);
            return this.convertResponse(imageResponseEntity, imageRequest);
        });
    }

    private ImageResponse convertResponse(ResponseEntity<OpenAiImageApi.OpenAiImageResponse> imageResponseEntity, OpenAiImageApi.OpenAiImageRequest openAiImageRequest) {
        OpenAiImageApi.OpenAiImageResponse imageApiResponse = (OpenAiImageApi.OpenAiImageResponse)imageResponseEntity.getBody();
        if (imageApiResponse == null) {
            this.logger.warn("No image response returned for request: {}", (Object)openAiImageRequest);
            return new ImageResponse(List.of());
        }
        List<ImageGeneration> imageGenerationList = imageApiResponse.data().stream().map(entry -> new ImageGeneration(new Image(entry.url(), entry.b64Json()), (ImageGenerationMetadata)new OpenAiImageGenerationMetadata(entry.revisedPrompt()))).toList();
        OpenAiImageResponseMetadata openAiImageResponseMetadata = OpenAiImageResponseMetadata.from(imageApiResponse);
        return new ImageResponse(imageGenerationList, (ImageResponseMetadata)openAiImageResponseMetadata);
    }

    private OpenAiImageOptions toOpenAiImageOptions(ImageOptions runtimeImageOptions) {
        OpenAiImageOptions.Builder openAiImageOptionsBuilder = OpenAiImageOptions.builder();
        if (runtimeImageOptions != null) {
            if (runtimeImageOptions.getN() != null) {
                openAiImageOptionsBuilder.withN(runtimeImageOptions.getN());
            }
            if (runtimeImageOptions.getModel() != null) {
                openAiImageOptionsBuilder.withModel(runtimeImageOptions.getModel());
            }
            if (runtimeImageOptions.getResponseFormat() != null) {
                openAiImageOptionsBuilder.withResponseFormat(runtimeImageOptions.getResponseFormat());
            }
            if (runtimeImageOptions.getWidth() != null) {
                openAiImageOptionsBuilder.withWidth(runtimeImageOptions.getWidth());
            }
            if (runtimeImageOptions.getHeight() != null) {
                openAiImageOptionsBuilder.withHeight(runtimeImageOptions.getHeight());
            }
            if (runtimeImageOptions instanceof OpenAiImageOptions) {
                OpenAiImageOptions runtimeOpenAiImageOptions = (OpenAiImageOptions)runtimeImageOptions;
                if (runtimeOpenAiImageOptions.getQuality() != null) {
                    openAiImageOptionsBuilder.withQuality(runtimeOpenAiImageOptions.getQuality());
                }
                if (runtimeOpenAiImageOptions.getStyle() != null) {
                    openAiImageOptionsBuilder.withStyle(runtimeOpenAiImageOptions.getStyle());
                }
                if (runtimeOpenAiImageOptions.getUser() != null) {
                    openAiImageOptionsBuilder.withUser(runtimeOpenAiImageOptions.getUser());
                }
            }
        }
        return openAiImageOptionsBuilder.build();
    }
}

